/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ToolProvider;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class InputTool {
    protected static final int STATE_NONE = 0;
    protected static final int STATE_INIT = 1;
    protected static final int STATE_DRAG = 2;
    protected static final int STATE_DRAG_IN_PROGRESS = 3;
    protected static final int STATE_INVALID = 4;
    protected ToolProvider myToolProvider;
    protected EditableArea myArea;
    protected boolean myExecuteEnabled;
    private boolean c;
    protected int myState;
    protected int myCurrentScreenX;
    protected int myCurrentScreenY;
    protected InputEvent myInputEvent;
    protected int myModifiers;
    protected int myButton;
    protected int myStartScreenX;
    protected int myStartScreenY;
    private boolean b;
    private Cursor a;
    private Cursor e;
    private static final int d = 5;

    public void activate() {
        this.b = false;
        this.resetState();
        this.myState = 1;
        this.c = true;
    }

    public void deactivate() {
        this.c = false;
        this.setExecuteEnabled(false);
    }

    protected void resetState() {
        this.myCurrentScreenX = 0;
        this.myCurrentScreenY = 0;
        this.myInputEvent = null;
        this.myButton = 0;
        this.myStartScreenX = 0;
        this.myStartScreenY = 0;
    }

    public final void setToolProvider(ToolProvider toolProvider) {
        this.myToolProvider = toolProvider;
    }

    public final void setArea(@Nullable EditableArea editableArea) {
        if (this.myArea != editableArea) {
            this.setCursor(null);
            this.myArea = editableArea;
            if (this.myArea != null) {
                Point point = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(point, this.myArea.getNativeComponent());
                this.myCurrentScreenX = point.x;
                this.myCurrentScreenY = point.y;
            }
            this.refreshCursor();
        }
    }

    protected final void setExecuteEnabled(boolean bl2) {
        this.myExecuteEnabled = bl2;
        this.refreshCursor();
    }

    protected final void setCursor(@Nullable Cursor cursor) {
        if (this.myArea != null) {
            this.myArea.setCursor(cursor);
        }
    }

    public void refreshCursor() {
        if (this.c) {
            this.setCursor(this.calculateCursor());
        }
    }

    @Nullable
    protected Cursor calculateCursor() {
        if (this.myState == 0) {
            return null;
        }
        return this.myExecuteEnabled ? this.getDefaultCursor() : this.getDisabledCursor();
    }

    protected Cursor getDefaultCursor() {
        return this.a;
    }

    public final void setDefaultCursor(@Nullable Cursor cursor) {
        if (this.a != cursor) {
            this.a = cursor;
            this.refreshCursor();
        }
    }

    protected final Cursor getDisabledCursor() {
        return this.e == null ? this.getDefaultCursor() : this.e;
    }

    public final void setDisabledCursor(@Nullable Cursor cursor) {
        if (this.e != cursor) {
            this.e = cursor;
            this.refreshCursor();
        }
    }

    @Nullable
    protected String getDescription() {
        return null;
    }

    public void keyTyped(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        this.a(keyEvent);
        this.setArea(editableArea);
    }

    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        this.a(keyEvent);
        this.setArea(editableArea);
    }

    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        this.a(keyEvent);
        this.setArea(editableArea);
    }

    private void a(KeyEvent keyEvent) {
        this.myInputEvent = keyEvent;
        this.myModifiers = keyEvent.getModifiers();
    }

    protected final boolean isShiftPressed() {
        return (this.myModifiers & 1) != 0;
    }

    protected final boolean isAltOptionPressed() {
        return (this.myModifiers & 8) != 0;
    }

    protected final boolean isCtrlCmdPressed() {
        return (this.myModifiers & 0x102) != 0;
    }

    private void a(MouseEvent mouseEvent) {
        this.myCurrentScreenX = mouseEvent.getX();
        this.myCurrentScreenY = mouseEvent.getY();
        this.myModifiers = mouseEvent.getModifiers();
        this.myButton = mouseEvent.getButton();
        this.myInputEvent = mouseEvent;
        this.myToolProvider.setEvent(mouseEvent);
    }

    private boolean a() {
        if (!this.b) {
            this.b = Math.abs(this.moveDeltaWidth()) > 5 || Math.abs(this.moveDeltaHeight()) > 5;
        }
        return this.b;
    }

    protected final int moveDeltaWidth() {
        return this.myCurrentScreenX - this.myStartScreenX;
    }

    protected final int moveDeltaHeight() {
        return this.myCurrentScreenY - this.myStartScreenY;
    }

    protected final Point getLocation() {
        return new Point(this.myCurrentScreenX, this.myCurrentScreenY);
    }

    protected void handleButtonDown(int n2) {
    }

    protected void handleButtonUp(int n2) {
    }

    protected void handleMove() {
    }

    protected void handleDrag() {
    }

    protected void handleDragStarted() {
    }

    protected void handleDragInProgress() {
    }

    protected void handlePopup() {
    }

    protected void handleDoubleClick(int n2) {
    }

    protected void handleAreaExited() {
    }

    public void mouseDown(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.setArea(editableArea);
        this.a(mouseEvent);
        this.myStartScreenX = mouseEvent.getX();
        this.myStartScreenY = mouseEvent.getY();
        this.handleButtonDown(mouseEvent.getButton());
    }

    public void mouseUp(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.setArea(editableArea);
        this.a(mouseEvent);
        this.handleButtonUp(mouseEvent.getButton());
    }

    public void mouseMove(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.setArea(editableArea);
        this.a(mouseEvent);
        if (this.myState == 3) {
            this.handleDragInProgress();
        } else {
            this.handleMove();
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.setArea(editableArea);
        boolean bl2 = this.a();
        this.a(mouseEvent);
        this.handleDrag();
        if (this.a()) {
            if (!bl2) {
                this.handleDragStarted();
            }
            this.handleDragInProgress();
        }
    }

    public void mousePopup(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.setArea(editableArea);
        this.a(mouseEvent);
        this.handlePopup();
    }

    public void mouseDoubleClick(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.setArea(editableArea);
        this.a(mouseEvent);
        this.handleDoubleClick(mouseEvent.getButton());
    }

    public void mouseEntered(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        this.a(mouseEvent);
        if (this.myArea != null) {
            this.handleAreaExited();
        }
        this.setArea(editableArea);
        this.myToolProvider.setArea(editableArea);
    }

    public void mouseExited(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        if (this.myArea == editableArea) {
            this.a(mouseEvent);
            this.handleAreaExited();
            this.setArea(null);
            this.myToolProvider.setArea(null);
        }
    }
}

