/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResizeTracker
extends InputTool {
    private final int h;
    private final String i;
    private OperationContext g;
    private List<EditOperation> j;
    private boolean f;

    public ResizeTracker(int n2, Object object, @Nullable String string) {
        this.h = n2;
        this.i = string;
        this.g = new OperationContext(object);
        this.g.setResizeDirection(n2);
        this.setDefaultCursor(Cursors.getResizeCursor(n2));
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    @Nullable
    protected String getDescription() {
        return this.i;
    }

    @Override
    public void deactivate() {
        this.d();
        this.g = null;
        this.j = null;
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (n2 == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.d();
            this.setExecuteEnabled(false);
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 3) {
            this.myState = 0;
            this.d();
            this.c();
        }
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.e();
            this.f();
            this.g();
        }
    }

    private void f() {
        for (EditOperation editOperation : this.b()) {
            editOperation.showFeedback();
        }
        this.f = true;
    }

    private void d() {
        if (this.f) {
            this.f = false;
            for (EditOperation editOperation : this.b()) {
                editOperation.eraseFeedback();
            }
        }
    }

    private void c() {
        if (this.myExecuteEnabled) {
            ArrayList<EditOperation> arrayList = new ArrayList<EditOperation>();
            for (EditOperation editOperation : this.b()) {
                if (!editOperation.canExecute()) continue;
                arrayList.add(editOperation);
            }
            this.myToolProvider.execute(arrayList, DesignerBundle.message("command.tool_operation", new Object[0]));
        }
    }

    private void g() {
        for (EditOperation editOperation : this.b()) {
            if (!editOperation.canExecute()) continue;
            this.setExecuteEnabled(true);
            return;
        }
        this.setExecuteEnabled(false);
    }

    private void e() {
        this.g.setArea(this.myArea);
        this.g.setInputEvent(this.myInputEvent);
        this.g.setModifiers(this.myModifiers);
        Point point = new Point();
        Dimension dimension = new Dimension();
        int n2 = this.moveDeltaWidth();
        if ((this.h & 4) != 0) {
            point.x += n2;
            dimension.width -= n2;
        } else if ((this.h & 8) != 0) {
            dimension.width += n2;
        }
        int n3 = this.moveDeltaHeight();
        if ((this.h & 1) != 0) {
            point.y += n3;
            dimension.height -= n3;
        } else if ((this.h & 2) != 0) {
            dimension.height += n3;
        }
        this.g.setMoveDelta(point);
        this.g.setSizeDelta(dimension);
        this.g.setLocation(this.getLocation());
    }

    private List<EditOperation> b() {
        if (this.j == null) {
            this.g.setComponents(new ArrayList<RadComponent>(this.myArea.getSelection()));
            this.j = new ArrayList<EditOperation>();
            for (RadComponent radComponent : this.g.getComponents()) {
                RadComponent radComponent2 = radComponent.getParent();
                EditOperation editOperation = radComponent2 == null ? this.myArea.processRootOperation(this.g) : radComponent2.getLayout().processChildOperation(this.g);
                if (editOperation == null) continue;
                this.j.add(editOperation);
                editOperation.setComponent(radComponent);
            }
        }
        return this.j;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2 = keyEvent.getModifiers() != this.myModifiers;
        super.keyPressed(keyEvent, editableArea);
        if (keyEvent.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        } else if (bl2) {
            this.a();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2 = keyEvent.getModifiers() != this.myModifiers;
        super.keyReleased(keyEvent, editableArea);
        if (bl2) {
            this.a();
        }
    }

    private void a() {
        if (this.g != null) {
            this.e();
            this.f();
            this.g();
        }
    }
}

