/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomProvider;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.util.ThrowableRunnable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ToolProvider
implements ZoomProvider {
    private InputTool a;
    private EditableArea c;
    private MouseEvent b;

    public void processKeyEvent(KeyEvent keyEvent, EditableArea editableArea) {
        if (this.a != null) {
            try {
                switch (keyEvent.getID()) {
                    case 401: {
                        this.a.keyPressed(keyEvent, editableArea);
                        break;
                    }
                    case 400: {
                        this.a.keyTyped(keyEvent, editableArea);
                        break;
                    }
                    case 402: {
                        this.a.keyReleased(keyEvent, editableArea);
                    }
                }
            }
            catch (Throwable throwable) {
                this.showError("Edit operation", throwable);
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, EditableArea editableArea) {
        if (this.a != null) {
            try {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.a.mouseDown(mouseEvent, editableArea);
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.a.mousePopup(mouseEvent, editableArea);
                        break;
                    }
                    case 502: {
                        this.a.mouseUp(mouseEvent, editableArea);
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.a.mousePopup(mouseEvent, editableArea);
                        break;
                    }
                    case 504: {
                        this.a.mouseEntered(mouseEvent, editableArea);
                        break;
                    }
                    case 505: {
                        this.a.mouseExited(mouseEvent, editableArea);
                        break;
                    }
                    case 500: {
                        if (mouseEvent.getClickCount() == 2) {
                            this.a.mouseDoubleClick(mouseEvent, editableArea);
                        }
                        if (!mouseEvent.isPopupTrigger()) break;
                        this.a.mousePopup(mouseEvent, editableArea);
                        break;
                    }
                    case 503: {
                        this.a.mouseMove(mouseEvent, editableArea);
                        break;
                    }
                    case 506: {
                        this.a.mouseDrag(mouseEvent, editableArea);
                    }
                }
            }
            catch (Throwable throwable) {
                this.showError("Edit operation", throwable);
            }
        }
    }

    public void setEvent(MouseEvent mouseEvent) {
        this.b = mouseEvent;
    }

    public void setArea(@Nullable EditableArea editableArea) {
        this.c = editableArea;
    }

    public abstract void showError(@NonNls String var1, Throwable var2);

    public InputTool getActiveTool() {
        return this.a;
    }

    public void setActiveTool(InputTool inputTool) {
        if (this.a != null) {
            this.a.deactivate();
        }
        this.a = inputTool;
        if (this.a != null) {
            this.a.setToolProvider(this);
            this.a.activate();
            if (this.c != null) {
                this.a.setArea(this.c);
                this.a.refreshCursor();
                try {
                    this.a.mouseMove(this.b, this.c);
                }
                catch (Exception exception) {
                    this.showError("Edit operation", exception);
                }
            }
        }
    }

    public abstract void loadDefaultTool();

    public abstract boolean execute(ThrowableRunnable<Exception> var1, String var2, boolean var3);

    public abstract void executeWithReparse(ThrowableRunnable<Exception> var1, String var2);

    public abstract void execute(List<EditOperation> var1, String var2);

    public abstract void startInplaceEditing(@Nullable InplaceContext var1);

    public abstract void hideInspections();
}

