/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.QuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.impl.VisibilityWatcher;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.RowIcon;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuickFixManager {
    protected DesignerEditorPanel myDesigner;
    protected final JComponent myComponent;
    private final JViewport g;
    private final Alarm c = new Alarm();
    private final Runnable d;
    private LightweightHint b;
    private Rectangle a;
    private static final Border f = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private static final Border h = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.orange, 2), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    private static final Icon e = EmptyIcon.create((Icon)AllIcons.General.ArrowDown);

    public AbstractQuickFixManager(@Nullable DesignerEditorPanel designerEditorPanel, JComponent jComponent, JViewport jViewport) {
        this.myDesigner = designerEditorPanel;
        this.myComponent = jComponent;
        this.g = jViewport;
        this.d = () -> this.b();
        new VisibilityWatcher(){

            public void visibilityChanged() {
                if (AbstractQuickFixManager.this.myComponent.isShowing()) {
                    AbstractQuickFixManager.this.updateHintVisibility();
                } else {
                    AbstractQuickFixManager.this.hideHint();
                }
            }
        }.install((Component)jComponent);
        jComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    AbstractQuickFixManager.this.updateHintVisibility();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    AbstractQuickFixManager.this.hideHint();
                }
            }
        });
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent anActionEvent) {
                if (AbstractQuickFixManager.this.myDesigner != null) {
                    AbstractQuickFixManager.this.b();
                    AbstractQuickFixManager.this.c();
                }
            }

            public void update(AnActionEvent anActionEvent) {
                anActionEvent.getPresentation().setEnabled(anActionEvent.getData(CommonDataKeys.EDITOR) == null);
            }
        };
        anAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), jComponent);
        jViewport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AbstractQuickFixManager.this.a();
            }
        });
    }

    public void setDesigner(@Nullable DesignerEditorPanel designerEditorPanel) {
        this.myDesigner = designerEditorPanel;
    }

    public void update() {
        if (!this.myComponent.isShowing() || !IJSwingUtilities.hasFocus((Component)this.myComponent)) {
            this.hideHint();
        } else if (this.b == null || !this.b.isVisible()) {
            this.updateHintVisibility();
        } else {
            Rectangle rectangle = this.getErrorBounds();
            if (!ErrorInfo.haveFixes(this.getErrorInfos()) || rectangle == null || !rectangle.equals(this.a)) {
                this.hideHint();
                this.updateHintVisibility();
            }
        }
    }

    private void b() {
        if (!this.myComponent.isShowing() || !IJSwingUtilities.hasFocus((Component)this.myComponent)) {
            this.hideHint();
            return;
        }
        this.hideHint();
        List<ErrorInfo> list2 = this.getErrorInfos();
        if (!ErrorInfo.haveFixes(list2)) {
            this.hideHint();
            return;
        }
        boolean bl2 = false;
        Object object = list2.iterator();
        while (object.hasNext()) {
            ErrorInfo errorInfo = object.next();
            if (errorInfo.getLevel() != HighlightDisplayLevel.ERROR) continue;
            bl2 = true;
            break;
        }
        if ((object = this.getErrorBounds()) == null) {
            return;
        }
        this.b = new LightweightHint((JComponent)new InspectionHint(bl2 ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb));
        this.a = object;
        this.b.show(this.myComponent, ((Rectangle)object).x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, ((Rectangle)object).y, this.myComponent, new HintHint((Component)this.myComponent, ((Rectangle)object).getLocation()));
    }

    private void c() {
        if (this.b == null || !this.b.isVisible()) {
            return;
        }
        List<ErrorInfo> list2 = this.getErrorInfos();
        if (!ErrorInfo.haveFixes(list2)) {
            return;
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new FirstStep(list2));
        listPopup.showUnderneathOf((Component)this.b.getComponent());
    }

    public final void hideHint() {
        this.c.cancelAllRequests();
        if (this.b != null && this.b.isVisible()) {
            this.b.hide();
            this.b = null;
            this.myComponent.paintImmediately(this.myComponent.getVisibleRect());
        }
    }

    protected final void updateHintVisibility() {
        this.c.cancelAllRequests();
        this.c.addRequest(this.d, 500);
    }

    private void a() {
        Rectangle rectangle;
        if (this.b != null && this.b.isVisible() && (rectangle = this.getErrorBounds()) != null) {
            this.a = rectangle;
            Rectangle rectangle2 = new Rectangle(rectangle.x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, rectangle.y, AllIcons.Actions.IntentionBulb.getIconWidth() + 4, AllIcons.Actions.IntentionBulb.getIconHeight() + 4);
            if (this.getHintClipRect().contains(rectangle2)) {
                this.b.updateLocation(rectangle2.x, rectangle2.y);
            } else {
                this.b.hide();
            }
        }
    }

    protected Rectangle getHintClipRect() {
        return this.g.getViewRect();
    }

    @NotNull
    protected abstract List<ErrorInfo> getErrorInfos();

    @Nullable
    protected abstract Rectangle getErrorBounds();

    private Runnable c(QuickFix quickFix) {
        return () -> this.myDesigner.getToolProvider().executeWithReparse((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ApplicationManager.getApplication().runWriteAction((Runnable)quickFix)), "Run '" + quickFix.getName() + "' QuickFix");
    }

    private class InspectionHint
    extends JLabel {
        private final RowIcon a;
        private final RowIcon b;

        private InspectionHint(Icon icon) {
            this.setOpaque(false);
            this.setBorder(f);
            this.b = new RowIcon(2);
            this.b.setIcon(icon, 0);
            this.b.setIcon(AllIcons.General.ArrowDown, 1);
            this.a = new RowIcon(2);
            this.a.setIcon(icon, 0);
            this.a.setIcon(e, 1);
            this.setIcon((Icon)this.a);
            String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
            if (string.length() > 0) {
                this.setToolTipText(DesignerBundle.message("tooltip.press.accelerator", string));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    InspectionHint.this.setIcon((Icon)InspectionHint.this.b);
                    InspectionHint.this.setBorder(h);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    InspectionHint.this.setIcon((Icon)InspectionHint.this.a);
                    InspectionHint.this.setBorder(f);
                }
            });
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent mouseEvent, int n2) {
                    if (mouseEvent == null) {
                        2.a(0);
                    }
                    AbstractQuickFixManager.this.c();
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/designer/inspection/AbstractQuickFixManager$InspectionHint$2", "onClick"));
                }
            }.installOn((Component)this);
        }
    }

    private class SecondStep
    extends BaseListPopupStep<QuickFix> {
        public SecondStep(List<QuickFix> list2) {
            super(null, list2);
        }

        public Icon getIconFor(QuickFix quickFix) {
            return quickFix.getIcon();
        }

        @NotNull
        public String getTextFor(QuickFix quickFix) {
            String string = quickFix.getName();
            if (string == null) {
                SecondStep.a(0);
            }
            return string;
        }

        public PopupStep onChosen(QuickFix quickFix, boolean bl2) {
            return this.doFinalStep(AbstractQuickFixManager.this.c(quickFix));
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/inspection/AbstractQuickFixManager$SecondStep", "getTextFor"));
        }
    }

    private class FirstStep
    extends BaseListPopupStep<ErrorInfo> {
        public FirstStep(List<ErrorInfo> list2) {
            super(null, list2);
        }

        public Icon getIconFor(ErrorInfo errorInfo) {
            return AllIcons.Actions.RealIntentionBulb;
        }

        @NotNull
        public String getTextFor(ErrorInfo errorInfo) {
            String string = errorInfo.getName();
            if (string == null) {
                FirstStep.a(0);
            }
            return string;
        }

        public PopupStep onChosen(ErrorInfo errorInfo, boolean bl2) {
            List list2 = errorInfo.getQuickFixes();
            if (bl2) {
                return this.doFinalStep(AbstractQuickFixManager.this.c((QuickFix)list2.get(0)));
            }
            return new SecondStep(list2);
        }

        public boolean hasSubstep(ErrorInfo errorInfo) {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/inspection/AbstractQuickFixManager$FirstStep", "getTextFor"));
        }
    }
}

