/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.ModelLoader;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.VariationPaletteItem;
import com.intellij.designer.palette.DefaultPaletteItem;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaManager
extends ModelLoader {
    private static final String l = "meta";
    private static final String h = "palette";
    private static final String j = "group";
    private static final String k = "name";
    private static final String b = "item";
    private static final String i = "tag";
    private static final String e = "wrap-in";
    private final Map<String, MetaModel> f = new HashMap<String, MetaModel>();
    private final Map<String, MetaModel> d = new HashMap<String, MetaModel>();
    private final List<PaletteGroup> c = new ArrayList<PaletteGroup>();
    private final List<MetaModel> g = new ArrayList<MetaModel>();
    private final Map<Object, Object> a = new HashMap<Object, Object>();

    protected MetaManager(Project project2, String string) {
        super(project2);
        this.load(string);
    }

    @Override
    protected void loadDocument(Element element) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        HashMap<MetaModel, List<String>> hashMap = new HashMap<MetaModel, List<String>>();
        for (Object object : element.getChildren(l)) {
            this.loadModel(classLoader, (Element)object, hashMap);
        }
        for (Object object : element.getChild(h).getChildren(j)) {
            this.loadGroup((Element)object);
        }
        Element element2 = element.getChild(e);
        if (element2 != null) {
            for (Element entry : element2.getChildren(b)) {
                this.g.add(this.f.get(entry.getAttributeValue(i)));
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            MetaModel metaModel = (MetaModel)entry.getKey();
            ArrayList<MetaModel> arrayList = new ArrayList<MetaModel>();
            for (String string : (List)entry.getValue()) {
                MetaModel metaModel2 = this.f.get(string);
                if (metaModel2 == null) continue;
                arrayList.add(metaModel2);
            }
            if (arrayList.isEmpty()) continue;
            metaModel.setMorphingModels(arrayList);
        }
    }

    @NotNull
    protected MetaModel loadModel(ClassLoader classLoader, Element element, Map<MetaModel, List<String>> map) throws Exception {
        Element element2;
        Element element3;
        Element element4;
        Element element5;
        Element element6;
        String string;
        String string2 = element.getAttributeValue("model");
        Class<RadComponent> clazz = string2 == null ? null : classLoader.loadClass(string2);
        String string3 = element.getAttributeValue("class");
        String string4 = element.getAttributeValue(i);
        MetaModel metaModel = this.createModel(clazz, string3, string4);
        String string5 = element.getAttributeValue("layout");
        if (string5 != null) {
            metaModel.setLayout(classLoader.loadClass(string5));
        }
        if ((string = element.getAttributeValue("delete")) != null) {
            metaModel.setDelete(Boolean.parseBoolean(string));
        }
        if ((element6 = element.getChild("presentation")) != null) {
            metaModel.setPresentation(element6.getAttributeValue("title"), element6.getAttributeValue("icon"));
        }
        if ((element5 = element.getChild(h)) != null) {
            metaModel.setPaletteItem(this.createPaletteItem(element5));
        }
        if ((element4 = element.getChild("creation")) != null) {
            metaModel.setCreation(element4.getTextTrim());
        }
        if ((element3 = element.getChild("properties")) != null) {
            this.loadProperties(metaModel, element3);
        }
        if ((element2 = element.getChild("morphing")) != null) {
            map.put(metaModel, StringUtil.split((String)element2.getAttribute("to").getValue(), (String)" "));
        }
        this.loadOther(metaModel, element);
        if (string4 != null) {
            this.f.put(string4, metaModel);
        }
        if (string3 != null) {
            this.d.put(string3, metaModel);
        }
        MetaModel metaModel2 = metaModel;
        if (metaModel2 == null) {
            MetaManager.a(0);
        }
        return metaModel2;
    }

    @NotNull
    protected MetaModel createModel(Class<RadComponent> clazz, String string, String string2) throws Exception {
        MetaModel metaModel = new MetaModel(clazz, string, string2);
        if (metaModel == null) {
            MetaManager.a(1);
        }
        return metaModel;
    }

    @NotNull
    protected DefaultPaletteItem createPaletteItem(Element element) {
        DefaultPaletteItem defaultPaletteItem = new DefaultPaletteItem(element);
        if (defaultPaletteItem == null) {
            MetaManager.a(2);
        }
        return defaultPaletteItem;
    }

    @NotNull
    protected VariationPaletteItem createVariationPaletteItem(PaletteItem paletteItem, MetaModel metaModel, Element element) {
        VariationPaletteItem variationPaletteItem = new VariationPaletteItem(paletteItem, metaModel, element);
        if (variationPaletteItem == null) {
            MetaManager.a(3);
        }
        return variationPaletteItem;
    }

    @NotNull
    protected PaletteGroup createPaletteGroup(String string) {
        PaletteGroup paletteGroup = new PaletteGroup(string);
        if (paletteGroup == null) {
            MetaManager.a(4);
        }
        return paletteGroup;
    }

    protected void loadProperties(MetaModel metaModel, Element element) throws Exception {
        Attribute attribute;
        Attribute attribute2;
        Attribute attribute3;
        Attribute attribute4;
        Attribute attribute5;
        Attribute attribute6 = element.getAttribute("inplace");
        if (attribute6 != null) {
            metaModel.setInplaceProperties(StringUtil.split((String)attribute6.getValue(), (String)" "));
        }
        if ((attribute5 = element.getAttribute("top")) != null) {
            metaModel.setTopProperties(StringUtil.split((String)attribute5.getValue(), (String)" "));
        }
        if ((attribute4 = element.getAttribute("normal")) != null) {
            metaModel.setNormalProperties(StringUtil.split((String)attribute4.getValue(), (String)" "));
        }
        if ((attribute3 = element.getAttribute("important")) != null) {
            metaModel.setImportantProperties(StringUtil.split((String)attribute3.getValue(), (String)" "));
        }
        if ((attribute2 = element.getAttribute("expert")) != null) {
            metaModel.setExpertProperties(StringUtil.split((String)attribute2.getValue(), (String)" "));
        }
        if ((attribute = element.getAttribute("deprecated")) != null) {
            metaModel.setDeprecatedProperties(StringUtil.split((String)attribute.getValue(), (String)" "));
        }
    }

    protected void loadOther(MetaModel metaModel, Element element) throws Exception {
    }

    @NotNull
    protected PaletteGroup loadGroup(Element element) throws Exception {
        PaletteGroup paletteGroup = this.createPaletteGroup(element.getAttributeValue(k));
        for (Element element2 : element.getChildren(b)) {
            MetaModel metaModel = this.getModelByTag(element2.getAttributeValue(i));
            PaletteItem paletteItem = metaModel.getPaletteItem();
            if (!element2.getChildren().isEmpty()) {
                if (element2.getAttribute("title") != null) {
                    paletteItem = this.createVariationPaletteItem(paletteItem, metaModel, element2);
                }
                paletteGroup.addItem(paletteItem);
                for (Element element3 : element2.getChildren(b)) {
                    paletteGroup.addItem(this.createVariationPaletteItem(paletteItem, metaModel, element3));
                }
                continue;
            }
            paletteGroup.addItem(paletteItem);
        }
        this.c.add(paletteGroup);
        PaletteGroup paletteGroup2 = paletteGroup;
        if (paletteGroup2 == null) {
            MetaManager.a(5);
        }
        return paletteGroup2;
    }

    public <K, V> Map<K, V> getCache(Object object) {
        return (Map)this.a.get(object);
    }

    public void setCache(Object object, Object object2) {
        this.a.put(object, object2);
    }

    @Nullable
    public MetaModel getModelByTag(String string) {
        return this.f.get(string);
    }

    @Nullable
    public MetaModel getModelByTarget(String string) {
        return this.d.get(string);
    }

    public List<MetaModel> getWrapInModels() {
        return this.g;
    }

    public List<PaletteGroup> getPaletteGroups() {
        return this.c;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/designer/model/MetaManager";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaletteItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariationPaletteItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaletteGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadGroup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

