/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.designer.propertyTable.PropertyTablePanel;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.QuickFixManager;
import com.intellij.ide.CopyProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.TextTransferable;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadPropertyTable
extends PropertyTable
implements DataProvider,
ComponentSelectionListener {
    private final MyCopyProvider b;
    private final Project g;
    private EditableArea c;
    private DesignerEditorPanel a;
    private QuickFixManager f;
    private PropertyTablePanel e;
    private final ListSelectionListener d;

    public RadPropertyTable(@NotNull Project project2) {
        if (project2 == null) {
            RadPropertyTable.a(0);
        }
        this.b = new MyCopyProvider();
        this.d = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RadPropertyTable.this.a != null) {
                    RadPropertyTable.this.a.setSelectionProperty(RadPropertyTable.this.b(), RadPropertyTable.this.getSelectionProperty());
                }
            }
        };
        this.setShowVerticalLines(true);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.g = project2;
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (RadPropertyTable.this.e != null) {
                    RadPropertyTable.this.e.updateActions();
                }
            }
        });
    }

    private void c() {
        this.getSelectionModel().addListSelectionListener(this.d);
    }

    private void a() {
        this.getSelectionModel().removeListSelectionListener(this.d);
    }

    public void initQuickFixManager(JViewport jViewport) {
        this.f = new QuickFixManager(this, jViewport);
    }

    public void setPropertyTablePanel(PropertyTablePanel propertyTablePanel) {
        this.e = propertyTablePanel;
    }

    public Object getData(@NonNls String string) {
        if (this.a != null) {
            if (PlatformDataKeys.FILE_EDITOR.is(string)) {
                return this.a.getEditor();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(string) && !this.isEditing()) {
                return this.b;
            }
        }
        return null;
    }

    protected List<ErrorInfo> getErrors(@NotNull PropertiesContainer propertiesContainer) {
        if (propertiesContainer == null) {
            RadPropertyTable.a(1);
        }
        return propertiesContainer instanceof RadComponent ? RadComponent.getError((RadComponent)propertiesContainer) : Collections.emptyList();
    }

    @NotNull
    protected TextAttributesKey getErrorAttributes(@NotNull HighlightSeverity highlightSeverity) {
        if (highlightSeverity == null) {
            RadPropertyTable.a(2);
        }
        TextAttributesKey textAttributesKey = SeverityRegistrar.getSeverityRegistrar((Project)this.g).getHighlightInfoTypeBySeverity(highlightSeverity).getAttributesKey();
        if (textAttributesKey == null) {
            RadPropertyTable.a(3);
        }
        return textAttributesKey;
    }

    public void setArea(@Nullable DesignerEditorPanel designerEditorPanel, @Nullable EditableArea editableArea) {
        this.a = designerEditorPanel;
        this.f.setDesigner(designerEditorPanel);
        if (this.c != null) {
            this.c.removeSelectionListener(this);
        }
        this.c = editableArea;
        if (this.c != null) {
            this.c.addSelectionListener(this);
        }
        this.update();
    }

    @Override
    public void selectionChanged(EditableArea editableArea) {
        this.update();
    }

    public void updateInspections() {
        this.f.update();
    }

    public void update() {
        try {
            this.a();
            if (this.c == null) {
                this.update(Collections.emptyList(), null);
            } else {
                this.update(this.c.getSelection(), this.a.getSelectionProperty(this.b()));
            }
        }
        finally {
            this.c();
        }
    }

    @Nullable
    private String b() {
        PropertyTableTab propertyTableTab = this.e.getCurrentTab();
        return propertyTableTab == null ? null : propertyTableTab.getKey();
    }

    protected List<Property> getProperties(PropertiesContainer propertiesContainer) {
        PropertyTableTab propertyTableTab = this.e.getCurrentTab();
        if (propertyTableTab != null) {
            return ((RadComponent)propertiesContainer).getProperties(propertyTableTab.getKey());
        }
        return super.getProperties(propertiesContainer);
    }

    protected boolean doRestoreDefault(ThrowableRunnable<Exception> throwableRunnable) {
        return this.a.getToolProvider().execute(throwableRunnable, DesignerBundle.message("designer.properties.restore_default", new Object[0]), false);
    }

    protected boolean doSetValue(ThrowableRunnable<Exception> throwableRunnable) {
        return this.a.getToolProvider().execute(throwableRunnable, DesignerBundle.message("command.set.property.value", new Object[0]), false);
    }

    protected PropertyContext getPropertyContext() {
        return this.a;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/propertyTable/RadPropertyTable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/propertyTable/RadPropertyTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getErrors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorAttributes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCopyProvider
    implements CopyProvider {
        private MyCopyProvider() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCopyProvider.a(0);
            }
            try {
                Property property = RadPropertyTable.this.getSelectionProperty();
                Object object = RadPropertyTable.this.getValue(property);
                Object object2 = object == null ? new TextTransferable("") : property.doCopy((PropertiesContainer)RadPropertyTable.this.myContainers.get(0), object);
                CopyPasteManager.getInstance().setContents((Transferable)object2);
            }
            catch (Throwable throwable) {
                RadPropertyTable.this.a.showError("Copy property error", throwable);
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCopyProvider.a(1);
            }
            return RadPropertyTable.this.getSelectionProperty() != null;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCopyProvider.a(2);
            }
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/designer/propertyTable/RadPropertyTable$MyCopyProvider";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

