/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.LightPlatformTestCase;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EditorColorSchemeTestCase
extends LightPlatformTestCase {
    protected static EditorColorsScheme loadScheme(@NotNull String string) throws ParserConfigurationException, IOException, SAXException {
        if (string == null) {
            EditorColorSchemeTestCase.c(0);
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = documentBuilder.parse(inputSource);
        Element element = new DOMBuilder().build(document.getDocumentElement());
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsSchemeImpl editorColorsSchemeImpl = new EditorColorsSchemeImpl(editorColorsScheme);
        editorColorsSchemeImpl.readExternal(element);
        return editorColorsSchemeImpl;
    }

    @NotNull
    protected Pair<EditorColorsScheme, TextAttributes> doTestWriteRead(@NotNull TextAttributesKey textAttributesKey, @NotNull TextAttributes textAttributes) {
        if (textAttributesKey == null) {
            EditorColorSchemeTestCase.c(1);
        }
        if (textAttributes == null) {
            EditorColorSchemeTestCase.c(2);
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsScheme editorColorsScheme2 = (EditorColorsScheme)editorColorsScheme.clone();
        editorColorsScheme2.setName("test");
        editorColorsScheme2.setAttributes(textAttributesKey, textAttributes);
        Element element = new Element("scheme");
        ((AbstractColorsScheme)editorColorsScheme2).writeExternal(element);
        EditorColorsSchemeImpl editorColorsSchemeImpl = new EditorColorsSchemeImpl(editorColorsScheme);
        editorColorsSchemeImpl.readExternal(element);
        EditorColorSchemeTestCase.assertEquals((String)"test", (String)editorColorsSchemeImpl.getName());
        TextAttributes textAttributes2 = editorColorsSchemeImpl.getAttributes(textAttributesKey);
        Pair pair2 = Pair.create((Object)editorColorsSchemeImpl, (Object)textAttributes2);
        if (pair2 == null) {
            EditorColorSchemeTestCase.c(3);
        }
        return pair2;
    }

    protected static void assertXmlOutputEquals(String string, Element element) throws IOException {
        StringWriter stringWriter = new StringWriter();
        Format format = Format.getPrettyFormat();
        format.setLineSeparator("\n");
        new XMLOutputter(format).output(element, (Writer)stringWriter);
        String string2 = stringWriter.toString();
        EditorColorSchemeTestCase.assertEquals((String)string, (String)string2);
    }

    protected Element serialize(@NotNull EditorColorsScheme editorColorsScheme) {
        if (editorColorsScheme == null) {
            EditorColorSchemeTestCase.c(4);
        }
        Element element = new Element("scheme");
        ((AbstractColorsScheme)editorColorsScheme).writeExternal(element);
        EditorColorSchemeTestCase.a(element);
        element.removeChildren("metaInfo");
        return element;
    }

    protected Element serializeWithFixedMeta(@NotNull EditorColorsScheme editorColorsScheme) {
        if (editorColorsScheme == null) {
            EditorColorSchemeTestCase.c(5);
        }
        Element element2 = new Element("scheme");
        ((AbstractColorsScheme)editorColorsScheme).writeExternal(element2);
        EditorColorSchemeTestCase.a(element2);
        Element element3 = element2.getChild("metaInfo");
        if (element3 != null) {
            element3.getChildren().forEach(element -> {
                Attribute attribute = element.getAttribute("name");
                if (!element.getName().equals("property") || attribute == null || !RainbowHighlighter.isRainbowKey((Object)attribute.getValue())) {
                    element.removeContent();
                }
            });
        }
        return element2;
    }

    private static void a(@NotNull Element element) {
        if (element == null) {
            EditorColorSchemeTestCase.c(6);
        }
        ArrayList arrayList = new ArrayList(element.getChildren("option"));
        for (Element element2 : arrayList) {
            String string = element2.getAttributeValue("name");
            if (string == null) continue;
            if ("FONT_SCALE".equals(string) || "EDITOR_FONT_SIZE".equals(string) || "EDITOR_FONT_NAME".equals(string)) {
                element.removeContent((Content)element2);
                continue;
            }
            if (!"CONSOLE_FONT_NAME".equals(string)) continue;
            element2.setAttribute("value", "Test");
        }
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editor/EditorColorSchemeTestCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doTestWriteRead";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadScheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doTestWriteRead";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeWithFixedMeta";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixPlatformSpecificValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

