/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testDiscovery.JavaAutoRunManager;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public abstract class JavaTestFrameworkRunnableState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule> & ConfigurationWithCommandLineShortener>
extends JavaCommandLineState
implements RemoteConnectionCreator {
    private static final Logger d = Logger.getInstance(JavaTestFrameworkRunnableState.class);
    protected ServerSocket myServerSocket;
    protected File myTempFile;
    protected File myWorkingDirsFile = null;
    private RemoteConnectionCreator a;
    private final List<ArgumentFileFilter> c = new ArrayList<ArgumentFileFilter>();
    private ServerSocket b = null;

    public void setRemoteConnectionCreator(RemoteConnectionCreator remoteConnectionCreator) {
        this.a = remoteConnectionCreator;
    }

    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment executionEnvironment) {
        return this.a == null ? null : this.a.createRemoteConnection(executionEnvironment);
    }

    public boolean isPollConnection() {
        return this.a != null && this.a.isPollConnection();
    }

    public JavaTestFrameworkRunnableState(ExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    @NotNull
    protected abstract String getFrameworkName();

    @NotNull
    protected abstract String getFrameworkId();

    protected abstract void passTempFile(ParametersList var1, String var2);

    @NotNull
    protected abstract T getConfiguration();

    @Nullable
    protected abstract TestSearchScope getScope();

    @NotNull
    protected abstract String getForkMode();

    @NotNull
    protected abstract OSProcessHandler createHandler(Executor var1) throws ExecutionException;

    public SearchForTestsTask createSearchingForTestsTask() {
        return null;
    }

    protected boolean configureByModule(Module module2) {
        return module2 != null;
    }

    protected boolean isIdBasedTestTree() {
        return false;
    }

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        GeneralCommandLine generalCommandLine = super.createCommandLine();
        Map map = (Map)generalCommandLine.getUserData(JdkUtil.COMMAND_LINE_CONTENT);
        if (map != null) {
            map.forEach((string, string2) -> this.c.add(new ArgumentFileFilter(string, string2)));
        }
        return generalCommandLine;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner programRunner) throws ExecutionException {
        ArgumentFileFilter argumentFileFilter2;
        if (executor == null) {
            JavaTestFrameworkRunnableState.a(0);
        }
        if (programRunner == null) {
            JavaTestFrameworkRunnableState.a(1);
        }
        RunnerSettings runnerSettings = this.getRunnerSettings();
        SMTRunnerConsoleProperties sMTRunnerConsoleProperties = ((SMRunnerConsolePropertiesProvider)this.getConfiguration()).createTestConsoleProperties(executor);
        sMTRunnerConsoleProperties.setIdBasedTestTree(this.isIdBasedTestTree());
        sMTRunnerConsoleProperties.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)this.getFrameworkName(), (TestConsoleProperties)sMTRunnerConsoleProperties);
        SMTestRunnerResultsForm sMTestRunnerResultsForm = ((SMTRunnerConsoleView)baseTestsOutputConsoleView).getResultsViewer();
        Disposer.register((Disposable)this.getConfiguration().getProject(), (Disposable)baseTestsOutputConsoleView);
        final OSProcessHandler oSProcessHandler = this.createHandler(executor);
        for (ArgumentFileFilter argumentFileFilter2 : this.c) {
            baseTestsOutputConsoleView.addMessageFilter((Filter)argumentFileFilter2);
        }
        baseTestsOutputConsoleView.attachToProcess((ProcessHandler)oSProcessHandler);
        final AbstractTestProxy abstractTestProxy = sMTestRunnerResultsForm.getRoot();
        if (abstractTestProxy instanceof TestProxyRoot) {
            ((TestProxyRoot)abstractTestProxy).setHandler((ProcessHandler)oSProcessHandler);
        }
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent processEvent) {
                if (processEvent == null) {
                    1.a(0);
                }
                if (JavaTestFrameworkRunnableState.this.getConfiguration().isSaveOutputToFile()) {
                    File file = OutputFileUtil.getOutputFile(JavaTestFrameworkRunnableState.this.getConfiguration());
                    abstractTestProxy.setOutputFilePath(file != null ? file.getAbsolutePath() : null);
                }
            }

            public void processTerminated(@NotNull ProcessEvent processEvent) {
                if (processEvent == null) {
                    1.a(1);
                }
                Runnable runnable = () -> {
                    abstractTestProxy.flushOutputFile();
                    JavaTestFrameworkRunnableState.this.deleteTempFiles();
                    JavaTestFrameworkRunnableState.this.clear();
                };
                UIUtil.invokeLaterIfNeeded((Runnable)runnable);
                oSProcessHandler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        argumentFileFilter2 = sMTRunnerConsoleProperties.createRerunFailedTestsAction((ConsoleView)baseTestsOutputConsoleView);
        d.assertTrue(argumentFileFilter2 != null);
        argumentFileFilter2.setModelProvider(() -> sMTestRunnerResultsForm);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)baseTestsOutputConsoleView, (ProcessHandler)oSProcessHandler);
        defaultExecutionResult.setRestartActions(new AnAction[]{argumentFileFilter2, new ToggleAutoTestAction(){

            public boolean isDelayApplicable() {
                return false;
            }

            public AbstractAutoTestManager getAutoTestManager(Project project2) {
                return JavaAutoRunManager.getInstance(project2);
            }
        }});
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)oSProcessHandler, runnerSettings);
        DefaultExecutionResult defaultExecutionResult2 = defaultExecutionResult;
        if (defaultExecutionResult2 == null) {
            JavaTestFrameworkRunnableState.a(2);
        }
        return defaultExecutionResult2;
    }

    protected abstract void configureRTClasspath(JavaParameters var1) throws CantRunException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaParameters createJavaParameters() throws ExecutionException {
        Object[] objectArray;
        JavaParameters javaParameters = new JavaParameters();
        Project project2 = this.getConfiguration().getProject();
        javaParameters.setShortenCommandLine(((ConfigurationWithCommandLineShortener)this.getConfiguration()).getShortenCommandLine(), project2);
        Module module2 = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        Sdk sdk = module2 == null ? ProjectRootManager.getInstance((Project)project2).getProjectSdk() : ModuleRootManager.getInstance((Module)module2).getSdk();
        javaParameters.setJdk(sdk);
        String string = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getProgramParameters();
        ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(null);
        try {
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)javaParameters, (CommonJavaRunConfigurationParameters)this.getConfiguration());
        }
        finally {
            ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(string);
        }
        javaParameters.getClassPath().addFirst(JavaSdkUtil.getIdeaRtJarPath());
        this.configureClasspath(javaParameters);
        for (Object object : objectArray = Extensions.getExtensions((String)"com.intellij.junitPatcher")) {
            ((JUnitPatcher)object).patchJavaParameters(module2, javaParameters);
        }
        for (RunConfigurationExtension runConfigurationExtension : (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
            runConfigurationExtension.updateJavaParameters(this.getConfiguration(), javaParameters, this.getRunnerSettings());
        }
        if (!StringUtil.isEmptyOrSpaces((String)string)) {
            javaParameters.getProgramParametersList().addAll(this.getNamedParams(string));
        }
        if (ConsoleBuffer.useCycleBuffer()) {
            javaParameters.getVMParametersList().addProperty("idea.test.cyclic.buffer.size", String.valueOf(ConsoleBuffer.getCycleBufferSize()));
        }
        return javaParameters;
    }

    protected List<String> getNamedParams(String string) {
        return Collections.singletonList("@name" + string);
    }

    @Nullable
    public ServerSocket getForkSocket() {
        if (this.b == null && (!Comparing.strEqual((String)this.getForkMode(), (String)"none") || this.forkPerModule()) && this.getRunnerSettings() != null) {
            try {
                this.b = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            }
            catch (IOException iOException) {
                d.error((Throwable)iOException);
            }
        }
        return this.b;
    }

    private boolean a() {
        RunnerSettings runnerSettings = this.getRunnerSettings();
        return runnerSettings != null && !(runnerSettings instanceof GenericDebuggerRunnerSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendForkInfo(Executor executor) throws ExecutionException {
        JavaParameters javaParameters;
        Sdk sdk;
        String string = this.getForkMode();
        if (Comparing.strEqual((String)string, (String)"none")) {
            if (!this.forkPerModule()) return;
            if (this.a()) {
                String string2 = UIUtil.removeMnemonic((String)executor.getStartActionText());
                throw new CantRunException("'" + string2 + "' is disabled when per-module working directory is configured.<br/>Please specify single working directory, or change test scope to single module.");
            }
        } else if (this.a()) {
            String string3 = executor.getActionName();
            throw new CantRunException(string3 + " is disabled in fork mode.<br/>Please change fork mode to &lt;none&gt; to " + string3.toLowerCase(Locale.ENGLISH) + ".");
        }
        if ((sdk = (javaParameters = this.getJavaParameters()).getJdk()) == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
        }
        try {
            File file = FileUtil.createTempFile((String)"command.line", (String)"", (boolean)true);
            try (PrintWriter printWriter = new PrintWriter(file, "UTF-8");){
                if (JdkUtil.useDynamicClasspath((Project)this.getConfiguration().getProject()) && this.forkPerModule()) {
                    printWriter.println("use classpath jar");
                } else {
                    printWriter.println("");
                }
                printWriter.println(((JavaSdkType)sdk.getSdkType()).getVMExecutablePath(sdk));
                for (String string4 : javaParameters.getVMParametersList().getList()) {
                    printWriter.println(string4);
                }
            }
            this.passForkMode(this.getForkMode(), file, javaParameters);
            return;
        }
        catch (IOException iOException) {
            d.error((Throwable)iOException);
        }
    }

    protected abstract void passForkMode(String var1, File var2, JavaParameters var3) throws ExecutionException;

    protected void collectListeners(JavaParameters javaParameters, StringBuilder stringBuilder, String string, String string2) {
        Object[] objectArray;
        T t2 = this.getConfiguration();
        for (Object object : objectArray = Extensions.getExtensions((String)string)) {
            boolean bl2 = true;
            for (RunConfigurationExtension runConfigurationExtension : (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
                if (!runConfigurationExtension.isListenerDisabled((RunConfigurationBase)t2, object, this.getRunnerSettings())) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string2);
            }
            Class<?> clazz = object.getClass();
            stringBuilder.append(clazz.getName());
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass((Class)clazz));
        }
    }

    protected void configureClasspath(JavaParameters javaParameters) throws CantRunException {
        this.configureRTClasspath(javaParameters);
        RunConfigurationModule runConfigurationModule = this.getConfiguration().getConfigurationModule();
        String string = ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null;
        int n2 = 7;
        if (this.configureByModule(runConfigurationModule.getModule())) {
            JavaParametersUtil.configureModule(runConfigurationModule, javaParameters, 7, string);
        } else {
            JavaParametersUtil.configureProject(this.getConfiguration().getProject(), javaParameters, 7, string);
        }
    }

    protected void createServerSocket(JavaParameters javaParameters) {
        try {
            this.myServerSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            javaParameters.getProgramParametersList().add("-socket" + this.myServerSocket.getLocalPort());
        }
        catch (IOException iOException) {
            d.error((Throwable)iOException);
        }
    }

    protected boolean spansMultipleModules(String string) {
        SourceScope sourceScope;
        TestSearchScope testSearchScope;
        Project project2;
        PsiPackage psiPackage;
        if (string != null && (psiPackage = JavaPsiFacade.getInstance((Project)(project2 = this.getConfiguration().getProject())).findPackage(string)) != null && (testSearchScope = this.getScope()) != null && (sourceScope = testSearchScope.getSourceScope(this.getConfiguration())) != null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project2).intersectWith(sourceScope.getGlobalSearchScope());
            PsiDirectory[] psiDirectoryArray = psiPackage.getDirectories(globalSearchScope);
            return Arrays.stream(psiDirectoryArray).map(psiDirectory -> ModuleUtilCore.findModuleForFile((VirtualFile)psiDirectory.getVirtualFile(), (Project)project2)).filter(Objects::nonNull).distinct().count() > 1L;
        }
        return false;
    }

    protected boolean forkPerModule() {
        String string = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getWorkingDirectory();
        return this.getScope() != TestSearchScope.SINGLE_MODULE && ("$MODULE_DIR$".equals(string) || "%MODULE_WORKING_DIR%".equals(string)) && this.spansMultipleModules(((CommonJavaRunConfigurationParameters)this.getConfiguration()).getPackage());
    }

    protected void createTempFiles(JavaParameters javaParameters) {
        try {
            this.myWorkingDirsFile = FileUtil.createTempFile((String)("idea_working_dirs_" + this.getFrameworkId()), (String)".tmp", (boolean)true);
            javaParameters.getProgramParametersList().add("@w@" + this.myWorkingDirsFile.getAbsolutePath());
            this.myTempFile = FileUtil.createTempFile((String)("idea_" + this.getFrameworkId()), (String)".tmp", (boolean)true);
            this.passTempFile(javaParameters.getProgramParametersList(), this.myTempFile.getAbsolutePath());
        }
        catch (Exception exception) {
            d.error((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeClassesPerModule(String string, JavaParameters javaParameters, Map<Module, List<String>> map) throws FileNotFoundException, UnsupportedEncodingException, CantRunException {
        if (map != null) {
            String string2 = this.getScope() == TestSearchScope.WHOLE_PROJECT ? null : javaParameters.getClassPath().getPathsString();
            try (PrintWriter printWriter = new PrintWriter(this.myWorkingDirsFile, "UTF-8");){
                printWriter.println(string);
                for (Module module2 : map.keySet()) {
                    Object object;
                    printWriter.println(PathMacroUtil.getModuleDir((String)module2.getModuleFilePath()));
                    printWriter.println(module2.getName());
                    if (string2 == null) {
                        object = new JavaParameters();
                        object.getClassPath().add(JavaSdkUtil.getIdeaRtJarPath());
                        this.configureRTClasspath((JavaParameters)object);
                        JavaParametersUtil.configureModule(module2, (JavaParameters)object, 7, ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null);
                        printWriter.println(object.getClassPath().getPathsString());
                    } else {
                        printWriter.println(string2);
                    }
                    object = map.get(module2);
                    printWriter.println(object.size());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        printWriter.println(string3);
                    }
                }
            }
        }
    }

    protected void deleteTempFiles() {
        if (this.myTempFile != null) {
            FileUtil.delete((File)this.myTempFile);
        }
        if (this.myWorkingDirsFile != null) {
            FileUtil.delete((File)this.myWorkingDirsFile);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/JavaTestFrameworkRunnableState";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

