/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.ProjectTopics;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.jshell.DropJShellStateAction;
import com.intellij.execution.jshell.ExecuteJShellAction;
import com.intellij.execution.jshell.JShellRootType;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnippetEditorDecorator
extends EditorNotifications.Provider<ConfigurationPane> {
    public static final Key<ConfigurationPane> CONTEXT_KEY = Key.create((String)"jshell.editor.toolbar");
    private final Project a;

    public SnippetEditorDecorator(Project project2) {
        this.a = project2;
    }

    @NotNull
    public Key<ConfigurationPane> getKey() {
        Key<ConfigurationPane> key = CONTEXT_KEY;
        if (key == null) {
            SnippetEditorDecorator.a(0);
        }
        return key;
    }

    @Nullable
    public ConfigurationPane createNotificationPanel(@NotNull VirtualFile virtualFile, @NotNull FileEditor fileEditor) {
        RootType rootType;
        if (virtualFile == null) {
            SnippetEditorDecorator.a(1);
        }
        if (fileEditor == null) {
            SnippetEditorDecorator.a(2);
        }
        if (!((rootType = ScratchFileService.getInstance().getRootType(virtualFile)) instanceof JShellRootType)) {
            return null;
        }
        return new ConfigurationPane(this.a);
    }

    @Nullable
    public static ConfigurationPane getJShellConfiguration(DataContext dataContext) {
        return SnippetEditorDecorator.getJShellConfiguration((FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext));
    }

    @Nullable
    public static ConfigurationPane getJShellConfiguration(FileEditor fileEditor) {
        return (ConfigurationPane)((Object)CONTEXT_KEY.get((UserDataHolder)fileEditor));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jshell/SnippetEditorDecorator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jshell/SnippetEditorDecorator";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigurationPane
    extends EditorHeaderComponent {
        private final Alarm d = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final JrePathEditor c;
        private final ConfigurationModuleSelector b;
        private MessageBusConnection a;

        ConfigurationPane(Project project2) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{ExecuteJShellAction.getSharedInstance(), DropJShellStateAction.getSharedInstance()});
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JShellSnippetEditor", (ActionGroup)defaultActionGroup, true);
            this.c = new JrePathEditor(DefaultJreSelector.projectSdk(project2));
            this.c.setToolTipText("Alternative JRE to run JShell");
            this.c.setPathOrName(null, true);
            LabeledComponent labeledComponent = new LabeledComponent();
            ModulesComboBox modulesComboBox = new ModulesComboBox();
            labeledComponent.setComponent((JComponent)modulesComboBox);
            labeledComponent.setLabelLocation("West");
            labeledComponent.setText("Use classpath of:");
            this.b = new ConfigurationModuleSelector(project2, modulesComboBox, "<whole project>");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)actionToolbar.getComponent(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)3, (int)0, (int)0), 0, 0));
            jPanel.add((Component)labeledComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)3, (int)0, (int)0), 0, 0));
            jPanel.add((Component)((Object)this.c), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)15, (int)0, (int)0), 0, 0));
            this.add(jPanel, "Center");
        }

        public void addNotify() {
            super.addNotify();
            this.a = this.b.getProject().getMessageBus().connect();
            this.a.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                    if (project2 == null) {
                        1.a(0);
                    }
                    if (module2 == null) {
                        1.a(1);
                    }
                    this.a();
                }

                public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                    if (project2 == null) {
                        1.a(2);
                    }
                    if (module2 == null) {
                        1.a(3);
                    }
                    this.a();
                }

                public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> list2, @NotNull Function<Module, String> function) {
                    if (project2 == null) {
                        1.a(4);
                    }
                    if (list2 == null) {
                        1.a(5);
                    }
                    if (function == null) {
                        1.a(6);
                    }
                    this.a();
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "modules";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldNameProvider";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/jshell/SnippetEditorDecorator$ConfigurationPane$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleRemoved";
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modulesRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.a();
        }

        public void removeNotify() {
            super.removeNotify();
            MessageBusConnection messageBusConnection = this.a;
            if (messageBusConnection != null) {
                this.a = null;
                messageBusConnection.disconnect();
                this.d.cancelAllRequests();
            }
        }

        private void a() {
            this.d.cancelAllRequests();
            this.d.addRequest(() -> this.b.reset(), 300L);
        }

        @Nullable
        public Module getContextModule() {
            return this.b.getModule();
        }

        @Nullable
        public Sdk getRuntimeSdk() {
            String string = this.c.getJrePathOrName();
            if (string != null) {
                JavaSdk javaSdk = JavaSdk.getInstance();
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                Sdk sdk = projectJdkTable.findJdk(string, javaSdk.getName());
                if (sdk != null) {
                    return sdk;
                }
                for (Sdk sdk2 : projectJdkTable.getSdksOfType((SdkTypeId)javaSdk)) {
                    if (!FileUtil.pathsEqual((String)string, (String)sdk2.getHomePath())) continue;
                    return sdk2;
                }
            }
            return null;
        }
    }
}

