/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchCompilationSupport;
import com.intellij.execution.scratch.JavaScratchConfigurable;
import com.intellij.execution.scratch.JavaScratchPositionManager;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchConfiguration
extends ApplicationConfiguration {
    public int SCRATCH_FILE_ID;

    protected JavaScratchConfiguration(String string, Project project2, ConfigurationFactory configurationFactory) {
        super(string, project2, configurationFactory);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        String string = this.getMainClassName();
        if (string == null || string.length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        }
        if (this.SCRATCH_FILE_ID <= 0) {
            throw new RuntimeConfigurationError("No scratch file associated with configuration");
        }
        if (this.getScratchVirtualFile() == null) {
            throw new RuntimeConfigurationError("Associated scratch file not found");
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            JavaScratchConfiguration.b(0);
        }
        if (executionEnvironment == null) {
            JavaScratchConfiguration.b(1);
        }
        ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration> javaApplicationCommandLineState = new ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration>(this, executionEnvironment){

            @Override
            protected void setupJavaParameters(JavaParameters javaParameters) throws ExecutionException {
                super.setupJavaParameters(javaParameters);
                File file = JavaScratchCompilationSupport.getScratchOutputDirectory(JavaScratchConfiguration.this.getProject());
                if (file != null) {
                    javaParameters.getClassPath().addFirst(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
                }
            }

            @Override
            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                VirtualFile virtualFile;
                OSProcessHandler oSProcessHandler = super.startProcess();
                if (this.getRunnerSettings() instanceof DebuggingRunnerData && (virtualFile = ((JavaScratchConfiguration)this.getConfiguration()).getScratchVirtualFile()) != null) {
                    DebuggerManager.getInstance((Project)JavaScratchConfiguration.this.getProject()).addDebugProcessListener((ProcessHandler)oSProcessHandler, new DebugProcessListener(){

                        public void processAttached(DebugProcess debugProcess) {
                            if (virtualFile.isValid()) {
                                debugProcess.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)debugProcess, virtualFile));
                            }
                            debugProcess.removeDebugProcessListener((DebugProcessListener)this);
                        }
                    });
                }
                OSProcessHandler oSProcessHandler2 = oSProcessHandler;
                if (oSProcessHandler2 == null) {
                    1.c(0);
                }
                return oSProcessHandler2;
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/scratch/JavaScratchConfiguration$1", "startProcess"));
            }
        };
        javaApplicationCommandLineState.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope()));
        return javaApplicationCommandLineState;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        JavaScratchConfigurable javaScratchConfigurable = new JavaScratchConfigurable(this.getProject());
        if (javaScratchConfigurable == null) {
            JavaScratchConfiguration.b(2);
        }
        return javaScratchConfigurable;
    }

    @Nullable
    public String getScratchFileUrl() {
        VirtualFile virtualFile = this.getScratchVirtualFile();
        return virtualFile != null ? virtualFile.getUrl() : null;
    }

    @Nullable
    public VirtualFile getScratchVirtualFile() {
        int n2 = this.SCRATCH_FILE_ID;
        if (n2 <= 0) {
            return null;
        }
        return ManagingFS.getInstance().findFileById(n2);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

