/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class TestDiscoveryConfigurationProducer
extends JavaRunConfigurationProducerBase<JavaTestConfigurationBase> {
    protected TestDiscoveryConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected abstract void setPosition(JavaTestConfigurationBase var1, PsiLocation<PsiMethod> var2);

    protected abstract Pair<String, String> getPosition(JavaTestConfigurationBase var1);

    protected boolean setupConfigurationFromContext(JavaTestConfigurationBase javaTestConfigurationBase, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        if (!Registry.is((String)"testDiscovery.enabled")) {
            return false;
        }
        Location location = configurationContext.getLocation();
        assert (location != null);
        Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (location2 == null) {
            return false;
        }
        PsiMethod psiMethod = TestDiscoveryConfigurationProducer.a(location2);
        Pair<String, String> pair2 = TestDiscoveryConfigurationProducer.a(psiMethod);
        if (psiMethod != null && pair2 != null) {
            try {
                Collection<String> collection;
                Project project2 = javaTestConfigurationBase.getProject();
                TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
                Collection<String> collection2 = testDiscoveryIndex.getTestsByMethodName((String)pair2.first, (String)pair2.second);
                if (collection2 == null || ContainerUtil.filter(collection2, string -> string.startsWith(javaTestConfigurationBase.getFrameworkPrefix())).isEmpty()) {
                    return false;
                }
                this.setPosition(javaTestConfigurationBase, (PsiLocation<PsiMethod>)new PsiLocation((PsiElement)psiMethod));
                javaTestConfigurationBase.setName("Tests for " + StringUtil.getShortName((String)((String)pair2.first)) + "." + (String)pair2.second);
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
                Module module3 = ((ModuleBasedConfiguration)runnerAndConfigurationSettings.getConfiguration()).getConfigurationModule().getModule();
                if (module3 != null) {
                    javaTestConfigurationBase.setModule(module3);
                }
                if ((collection = testDiscoveryIndex.getTestModulesByMethodName((String)pair2.first, (String)pair2.second, javaTestConfigurationBase.getFrameworkPrefix())).isEmpty()) {
                    return true;
                }
                ArrayList<Module> arrayList = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
                for (String string2 : collection) {
                    Module module4 = moduleManager.findModuleByName(string2);
                    if (module4 == null) continue;
                    arrayList.add(module4);
                }
                if (arrayList.isEmpty()) {
                    return true;
                }
                HashSet<Module> hashSet = new HashSet<Module>(Arrays.asList(moduleManager.getModules()));
                arrayList.forEach(module2 -> {
                    List list2 = ModuleUtilCore.getAllDependentModules((Module)module2);
                    list2.add(module2);
                    hashSet.retainAll(list2);
                });
                if (!hashSet.isEmpty()) {
                    String string2;
                    string2 = (Module)hashSet.iterator().next();
                    for (Module module5 : arrayList) {
                        if (!hashSet.contains(module5)) continue;
                        string2 = module5;
                    }
                    javaTestConfigurationBase.setModule((Module)string2);
                }
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected Module findModule(JavaTestConfigurationBase javaTestConfigurationBase, Module module2) {
        return null;
    }

    private static PsiMethod a(Location location) {
        PsiClass psiClass;
        PsiElement psiElement = location.getPsiElement();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (psiMethod != null && (psiClass = psiMethod.getContainingClass()) != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
            if (testFramework != null) {
                return null;
            }
            return psiMethod;
        }
        return null;
    }

    private static Pair<String, String> a(PsiMethod psiMethod) {
        if (psiMethod == null) {
            return null;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        String string = psiClass.getQualifiedName();
        if (string != null) {
            return Pair.create((Object)string, (Object)psiMethod.getName());
        }
        return null;
    }

    public boolean isConfigurationFromContext(JavaTestConfigurationBase javaTestConfigurationBase, ConfigurationContext configurationContext) {
        Pair<String, String> pair2 = TestDiscoveryConfigurationProducer.a(TestDiscoveryConfigurationProducer.a(configurationContext.getLocation()));
        return pair2 != null && pair2.equals(this.getPosition(javaTestConfigurationBase));
    }
}

