/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JreVersionDetector {
    private String a;
    private boolean b;

    public boolean isModuleJre50Configured(ModuleBasedConfiguration moduleBasedConfiguration) {
        Module module2 = moduleBasedConfiguration.getConfigurationModule().getModule();
        Sdk sdk = module2 != null && !module2.isDisposed() ? ModuleRootManager.getInstance((Module)module2).getSdk() : ProjectRootManager.getInstance((Project)moduleBasedConfiguration.getProject()).getProjectSdk();
        return JavaSdkUtil.isJdkAtLeast((Sdk)sdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_5);
    }

    public boolean isJre50Configured(CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters) {
        String string;
        if (commonJavaRunConfigurationParameters.isAlternativeJrePathEnabled() && !StringUtil.isEmptyOrSpaces((String)(string = commonJavaRunConfigurationParameters.getAlternativeJrePath()))) {
            if (Comparing.equal((String)string, (String)this.a)) {
                return this.b;
            }
            this.a = string;
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo = SdkVersionUtil.getJdkVersionInfo((String)this.a);
            this.b = jdkVersionInfo != null && jdkVersionInfo.version.feature >= 5;
            return this.b;
        }
        return false;
    }
}

