/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectUtil {
    private static final Logger a = Logger.getInstance(NewProjectUtil.class);

    private NewProjectUtil() {
    }

    public static void createNewProject(Project project2, AbstractProjectWizard abstractProjectWizard) {
        boolean bl2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ProjectManager.getInstance().getDefaultProject(), ProjectBundle.message((String)"project.new.wizard.progress.title", (Object[])new Object[0]), true, null);
        if (!bl2) {
            return;
        }
        if (!abstractProjectWizard.showAndGet()) {
            return;
        }
        NewProjectUtil.createFromWizard(abstractProjectWizard, project2);
    }

    public static Project createFromWizard(AbstractProjectWizard abstractProjectWizard, Project project2) {
        try {
            return NewProjectUtil.a(abstractProjectWizard, project2);
        }
        catch (IOException iOException) {
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)iOException.getMessage(), (String)"Project Initialization Failed"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Project a(AbstractProjectWizard abstractProjectWizard, @Nullable Project project2) throws IOException {
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        String string = abstractProjectWizard.getNewProjectFilePath();
        for (Object object : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)string, (Project)object)) continue;
            ProjectUtil.focusProjectWindow((Project)object, (boolean)false);
            return null;
        }
        ProjectBuilder projectBuilder = abstractProjectWizard.getProjectBuilder();
        a.debug("builder " + projectBuilder);
        try {
            Project project3;
            Project project4;
            Object object;
            File file = new File(string).getParentFile();
            a.assertTrue(file != null, (Object)("Cannot create project in '" + string + "': no parent file exists"));
            FileUtil.ensureExists((File)file);
            if (StorageScheme.DIRECTORY_BASED == abstractProjectWizard.getStorageScheme()) {
                FileUtil.ensureExists((File)new File(string, ".idea"));
            }
            if (projectBuilder == null || !projectBuilder.isUpdate()) {
                object = abstractProjectWizard.getProjectName();
                project4 = projectBuilder == null ? projectManagerEx.newProject((String)object, string, true, false) : projectBuilder.createProject((String)object, string);
            } else {
                project4 = project2;
            }
            if (project4 == null) {
                object = project2;
                return object;
            }
            object = abstractProjectWizard.getNewProjectJdk();
            if (object != null) {
                CommandProcessor.getInstance().executeCommand(project4, () -> NewProjectUtil.b(project4, (Sdk)object), null, null);
            }
            String string2 = abstractProjectWizard.getNewCompileOutput();
            CommandProcessor.getInstance().executeCommand(project4, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                String string2 = string2;
                try {
                    string2 = FileUtil.resolveShortWindowsName((String)string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string2 = FileUtil.toSystemIndependentName((String)string2);
                CompilerProjectExtension.getInstance((Project)project4).setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)string2));
            }), null, null);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                project4.save();
            }
            if (projectBuilder != null && !projectBuilder.validate(project2, project4)) {
                Project project5 = project2;
                return project5;
            }
            if (project4 != project2 && !ApplicationManager.getApplication().isUnitTestMode()) {
                NewProjectUtil.closePreviousProject(project2);
            }
            if (projectBuilder != null) {
                projectBuilder.commit(project4, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            boolean bl2 = projectBuilder == null || projectBuilder.isOpenProjectSettingsAfter();
            StartupManager.getInstance((Project)project4).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(() -> {
                if (project4.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                if (bl2) {
                    ModulesConfigurator.showDialog(project4, null, null);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project4.isDisposed()) {
                        return;
                    }
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project4).getToolWindow(ToolWindowId.PROJECT_VIEW);
                    if (toolWindow != null) {
                        toolWindow.activate(null);
                    }
                }, ModalityState.NON_MODAL);
            }, ModalityState.NON_MODAL));
            if (project4 != project2) {
                boolean bl3;
                IdeFrame ideFrame;
                ProjectUtil.updateLastProjectLocation((String)string);
                if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (ideFrame = (project3 = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (bl3 = ((IdeFrameEx)ideFrame).isInFullScreen())) {
                    project4.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
                }
                projectManagerEx.openProject(project4);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                project4.save();
            }
            project3 = project4;
            return project3;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    public static void applyJdkToProject(@NotNull Project project2, @NotNull Sdk sdk) {
        if (project2 == null) {
            NewProjectUtil.a(0);
        }
        if (sdk == null) {
            NewProjectUtil.a(1);
        }
        ProjectRootManagerEx projectRootManagerEx = ProjectRootManagerEx.getInstanceEx((Project)project2);
        projectRootManagerEx.setProjectSdk(sdk);
        JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
        if (javaSdkVersion != null) {
            LanguageLevel languageLevel = javaSdkVersion.getMaxLanguageLevel();
            LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            LanguageLevelProjectExtension languageLevelProjectExtension2 = LanguageLevelProjectExtension.getInstance((Project)project2);
            if (languageLevelProjectExtension.isDefault() || languageLevel.compareTo((Enum)languageLevelProjectExtension2.getLanguageLevel()) < 0) {
                languageLevelProjectExtension2.setLanguageLevel(languageLevel);
            }
        }
    }

    public static void closePreviousProject(Project project2) {
        int n2;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        if (projectArray.length > 0 && (n2 = ProjectUtil.confirmOpenNewProject((boolean)true)) == 1) {
            ProjectUtil.closeAndDispose((Project)(project2 != null ? project2 : projectArray[projectArray.length - 1]));
        }
    }

    private static /* synthetic */ void b(Project project2, Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> NewProjectUtil.applyJdkToProject(project2, sdk));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "jdk";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/impl/NewProjectUtil";
        objectArray[2] = "applyJdkToProject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

