/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.profiler.dtrace;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.profiler.dtrace.SudoAuthDialog;
import com.intellij.ide.profiler.dtrace.SudoProcessAdapter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DTraceAction
extends AnAction
implements DumbAware {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.internal.performance.profiler.dtrace");

    public void actionPerformed(AnActionEvent anActionEvent) {
        if (SystemInfo.isMac) {
            new DTraceWindow().setVisible(true);
        }
    }

    public static class DTraceWindow
    extends JDialog {
        private final JTextArea b;
        private final JTextField c;
        private volatile boolean d = false;
        private OSProcessHandler a;
        File tmpDir;
        String lwawtScr;
        Process p;
        volatile boolean outputData;
        String myPasswd;
        final SpeedSearchFilter<ProcessInfo> filter = new SpeedSearchFilter<ProcessInfo>(){

            public boolean canBeHidden(ProcessInfo processInfo) {
                return true;
            }

            public String getIndexedString(ProcessInfo processInfo) {
                return processInfo.getPid() + " " + (processInfo.getExecutableCannonicalPath().isPresent() ? (String)processInfo.getExecutableCannonicalPath().get() : processInfo.getExecutableDisplayName());
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DTraceWindow() {
            super((Frame)null);
            this.setDefaultCloseOperation(2);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.c = new JTextField(4);
            this.c.setText(ApplicationManager.getApplicationPid());
            this.add((Component)this.c, gridBagConstraints);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            JButton jButton = new JButton(AllIcons.Actions.FindPlain);
            jButton.addActionListener(actionEvent -> this.b());
            jPanel.add(jButton);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 3;
            JButton jButton2 = new JButton(AllIcons.General.Run);
            jButton2.addActionListener(actionEvent -> {
                if (this.d) {
                    jButton2.setIcon(AllIcons.General.Run);
                    this.d = false;
                    this.a();
                } else {
                    jButton2.setIcon(AllIcons.Actions.Suspend);
                    this.d = true;
                    this.c();
                }
            });
            jPanel.add(jButton2);
            this.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            JButton jButton3 = new JButton(AllIcons.General.Gear);
            jButton3.addActionListener(actionEvent -> SudoAuthDialog.authorize(true));
            this.add((Component)jButton3, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            this.b = new JTextArea(30, 120);
            this.add((Component)new JBScrollPane((Component)this.b), gridBagConstraints);
            try {
                this.tmpDir = FileUtil.createTempDirectory((String)"jtr", (String)"scr", (boolean)true);
                File file = new File(this.tmpDir, "lwawt.d");
                if (!file.createNewFile()) {
                    this.b.setText(file.getAbsolutePath() + " not created");
                } else {
                    InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/intellij/profiler/dtrace/lwawt.d");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    try {
                        FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                    }
                    finally {
                        StreamUtil.closeStream((Closeable)inputStream);
                        StreamUtil.closeStream((Closeable)fileOutputStream);
                    }
                }
                this.lwawtScr = file.getAbsolutePath();
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
            }
            this.pack();
        }

        private void c() {
            try {
                this.outputData = false;
                if (SudoAuthDialog.authorize(false) == null) {
                    return;
                }
                PtyCommandLine ptyCommandLine = new PtyCommandLine();
                ptyCommandLine.setExePath("sudo");
                ptyCommandLine.addParameter("--reset-timestamp");
                ptyCommandLine.addParameter("dtrace");
                ptyCommandLine.addParameter("-q");
                ptyCommandLine.addParameter("-p");
                ptyCommandLine.addParameter(this.c.getText());
                ptyCommandLine.addParameter("-s");
                ptyCommandLine.addParameter(this.lwawtScr);
                this.p = ptyCommandLine.startProcessWithPty(CommandLineUtil.toCommandLine((String)ptyCommandLine.getExePath(), (List)ptyCommandLine.getParametersList().getList()), false);
                this.a = new OSProcessHandler(this.p, ptyCommandLine.toString());
                this.a.setHasPty(true);
                this.a.addProcessListener((ProcessListener)new SudoProcessAdapter((ProcessHandler)this.a, bl2 -> SudoAuthDialog.authorize(bl2)){

                    @Override
                    public void onStdoutAvailable(@NotNull String string) {
                        if (string == null) {
                            1.a(0);
                        }
                        if (string.contains("<data>")) {
                            outputData = true;
                            b.setText("");
                        } else if (string.contains("</data>")) {
                            outputData = false;
                        } else if (outputData) {
                            b.setText(b.getText() + string);
                        }
                    }

                    @Override
                    public void onStderrAvailable(@NotNull String string) {
                        if (string == null) {
                            1.a(1);
                        }
                        a.info("STDERR: " + string);
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "text";
                        objectArray2[1] = "com/intellij/ide/profiler/dtrace/DTraceAction$DTraceWindow$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStdoutAvailable";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStderrAvailable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
            }
            this.a.startNotify();
        }

        private void b() {
            final ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
            ListPopupStep<ProcessInfo> listPopupStep = new ListPopupStep<ProcessInfo>(){

                @NotNull
                public List<ProcessInfo> getValues() {
                    List<ProcessInfo> list2 = Arrays.asList(processInfoArray);
                    if (list2 == null) {
                        3.a(0);
                    }
                    return list2;
                }

                public boolean isSelectable(ProcessInfo processInfo) {
                    return true;
                }

                @Nullable
                public Icon getIconFor(ProcessInfo processInfo) {
                    return null;
                }

                @NotNull
                public String getTextFor(ProcessInfo processInfo) {
                    String string = processInfo.getPid() + " " + (processInfo.getExecutableCannonicalPath().isPresent() ? (String)processInfo.getExecutableCannonicalPath().get() : processInfo.getExecutableDisplayName());
                    if (string == null) {
                        3.a(1);
                    }
                    return string;
                }

                @Nullable
                public ListSeparator getSeparatorAbove(ProcessInfo processInfo) {
                    return null;
                }

                public int getDefaultOptionIndex() {
                    return 0;
                }

                @Nullable
                public String getTitle() {
                    return null;
                }

                @Nullable
                public PopupStep onChosen(ProcessInfo processInfo, boolean bl2) {
                    return null;
                }

                public boolean hasSubstep(ProcessInfo processInfo) {
                    return false;
                }

                public void canceled() {
                }

                public boolean isMnemonicsNavigationEnabled() {
                    return false;
                }

                @Nullable
                public MnemonicNavigationFilter<ProcessInfo> getMnemonicNavigationFilter() {
                    return null;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @Nullable
                public SpeedSearchFilter<ProcessInfo> getSpeedSearchFilter() {
                    return filter;
                }

                public boolean isAutoSelectionEnabled() {
                    return false;
                }

                @Nullable
                public Runnable getFinalRunnable() {
                    return null;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/ide/profiler/dtrace/DTraceAction$DTraceWindow$3";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValues";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTextFor";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)listPopupStep);
            JList jList = ((ListPopupImpl)listPopup).getList();
            ListSelectionListener listSelectionListener = listSelectionEvent -> {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                Object e2 = ((JList)listSelectionEvent.getSource()).getSelectedValue();
                this.c.setText(Integer.toString(((ProcessInfo)e2).getPid()));
            };
            listPopup.addListSelectionListener(listSelectionListener);
            listSelectionListener.valueChanged(new ListSelectionEvent(jList, jList.getMinSelectionIndex(), jList.getMaxSelectionIndex(), false));
            listPopup.showInFocusCenter();
        }

        private void a() {
            try {
                this.a.getProcessInput().write(3);
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
            }
        }

        public void setPassword(String string) {
            this.myPasswd = string;
        }
    }
}

