/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.profiler.ui;

import com.intellij.ide.profiler.ui.UtilsKt;
import com.intellij.ide.profiler.ui.model.WithRenderableArea;
import com.intellij.ide.profiler.ui.model.WithRenderableText;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\u00020\u00032\u00020\u0004B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/profiler/ui/ChartNodeRenderer;", "T", "Lcom/intellij/ide/profiler/ui/model/WithRenderableText;", "Lcom/intellij/ide/profiler/ui/model/WithRenderableArea;", "", "font", "Ljava/awt/Font;", "(Ljava/awt/Font;)V", "getFont", "()Ljava/awt/Font;", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "render", "", "g", "Ljava/awt/Graphics2D;", "node", "drawingArea", "Ljava/awt/geom/Rectangle2D;", "(Ljava/awt/Graphics2D;Lcom/intellij/ide/profiler/ui/model/WithRenderableText;Ljava/awt/geom/Rectangle2D;)V", "intellij.platform.commercial"})
public final class ChartNodeRenderer<T extends WithRenderableText> {
    private Rectangle2D.Double a;
    @NotNull
    private final Font b;

    public final void render(@NotNull Graphics2D graphics2D, @NotNull T t2, @NotNull Rectangle2D rectangle2D) {
        FontMetrics fontMetrics;
        Intrinsics.checkParameterIsNotNull((Object)graphics2D, (String)"g");
        Intrinsics.checkParameterIsNotNull(t2, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)rectangle2D, (String)"drawingArea");
        this.a = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.setPaint((Paint)((WithRenderableArea)t2).getFillColor());
        graphics2D.fill(this.a);
        graphics2D.setPaint((Paint)((WithRenderableArea)t2).getBorderColor());
        graphics2D.draw(this.a);
        FontMetrics fontMetrics2 = fontMetrics = graphics2D.getFontMetrics(this.b);
        Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics2, (String)"fontMetrics");
        String string = ((WithRenderableText)t2).renderText(rectangle2D, fontMetrics2);
        float f2 = (float)((long)WithRenderableText.Companion.getLEFT_MARGIN_PX() + (long)rectangle2D.getCenterX()) - (float)fontMetrics.stringWidth(string) / (float)2;
        float f3 = (float)(rectangle2D.getY() + (double)fontMetrics.getAscent());
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.b);
        graphics2D.setPaint(UtilsKt.getDEFAULT_FONT_COLOR());
        graphics2D.drawString(string, f2, f3);
        graphics2D.setFont(font);
    }

    @NotNull
    public final Font getFont() {
        return this.b;
    }

    public ChartNodeRenderer(@NotNull Font font) {
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        this.b = font;
        this.a = new Rectangle2D.Double();
    }

    public /* synthetic */ ChartNodeRenderer(Font font, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            font = (Font)UtilsKt.getDEFAULT_FONT();
        }
        this(font);
    }

    public ChartNodeRenderer() {
        this(null, 1, null);
    }
}

