/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.FormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesDialog
extends DialogWrapper {
    private final LibraryNameAndLevelPanel e;
    private final ModulesComboBox b;
    private final Project c;
    private final List<OrderRoot> a;
    private final JPanel f;
    private final String d;

    public CreateLibraryFromFilesDialog(@NotNull Project project2, @NotNull List<OrderRoot> list2) {
        if (project2 == null) {
            CreateLibraryFromFilesDialog.a(0);
        }
        if (list2 == null) {
            CreateLibraryFromFilesDialog.a(1);
        }
        super(project2, true);
        this.setTitle("Create Library");
        this.c = project2;
        this.a = list2;
        FormBuilder formBuilder = LibraryNameAndLevelPanel.createFormBuilder();
        this.d = LibrariesContainerFactory.createContainer(project2).suggestUniqueLibraryName(LibraryTypeServiceImpl.suggestLibraryName(list2));
        this.e = new LibraryNameAndLevelPanel(formBuilder, this.d, Arrays.asList(LibrariesContainer.LibraryLevel.values()), LibrariesContainer.LibraryLevel.PROJECT);
        this.e.setDefaultName(this.d);
        this.b = new ModulesComboBox();
        this.b.fillModules(this.c);
        this.b.setSelectedModule(this.a(list2));
        formBuilder.addLabeledComponent("&Add to module:", (JComponent)this.b);
        this.f = formBuilder.getPanel();
        this.e.getLibraryNameField().selectAll();
        this.e.getLevelComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateLibraryFromFilesDialog.this.c();
            }
        });
        this.e.getLibraryNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                CreateLibraryFromFilesDialog.this.b();
            }
        });
        this.init();
    }

    private void b() {
        this.setOKActionEnabled(!this.e.getLibraryName().isEmpty() || this.e.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE && this.a.size() == 1);
    }

    private void c() {
        if (this.e.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE) {
            this.e.setDefaultName(this.a.size() == 1 ? "" : this.d);
        } else {
            this.e.setDefaultName(this.d);
            if (this.e.getLibraryName().isEmpty()) {
                this.e.getLibraryNameField().setText(this.d);
            }
        }
        this.b();
    }

    @Nullable
    private Module a(List<OrderRoot> list2) {
        for (OrderRoot orderRoot : list2) {
            Module module2 = null;
            VirtualFile virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(orderRoot.getFile());
            if (virtualFile != null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)this.c);
            }
            if (module2 == null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)orderRoot.getFile(), (Project)this.c);
            }
            if (module2 == null) continue;
            return module2;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.e.getLibraryNameField();
    }

    protected void doOKAction() {
        this.a();
        super.doOKAction();
    }

    private void a() {
        LibrariesContainer.LibraryLevel libraryLevel = this.e.getLibraryLevel();
        WriteAction.run(() -> {
            Module module2 = this.b.getSelectedModule();
            String string = this.e.getLibraryName();
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE) {
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                LibrariesContainerFactory.createContainer(modifiableRootModel).createLibrary(string, libraryLevel, this.a);
                modifiableRootModel.commit();
            } else {
                Library library = LibrariesContainerFactory.createContainer(this.c).createLibrary(string, libraryLevel, this.a);
                if (module2 != null) {
                    ModuleRootModificationUtil.addDependency((Module)module2, (Library)library);
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.f;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "roots";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/projectView/actions/CreateLibraryFromFilesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

