/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.Couple;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil");

    private FrameworkSupportUtil() {
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleType moduleType, @NotNull FacetsProvider facetsProvider) {
        if (moduleType == null) {
            FrameworkSupportUtil.a(0);
        }
        if (facetsProvider == null) {
            FrameworkSupportUtil.a(1);
        }
        return FrameworkSupportUtil.a(moduleType, null, facetsProvider);
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        if (module2 == null) {
            FrameworkSupportUtil.a(2);
        }
        if (facetsProvider == null) {
            FrameworkSupportUtil.a(3);
        }
        return FrameworkSupportUtil.a(ModuleType.get((Module)module2), module2, facetsProvider);
    }

    private static List<FrameworkSupportInModuleProvider> a(@NotNull ModuleType moduleType, @Nullable Module module2, @NotNull FacetsProvider facetsProvider) {
        if (moduleType == null) {
            FrameworkSupportUtil.a(4);
        }
        if (facetsProvider == null) {
            FrameworkSupportUtil.a(5);
        }
        List<FrameworkSupportInModuleProvider> list2 = FrameworkSupportUtil.getAllProviders();
        ArrayList<FrameworkSupportInModuleProvider> arrayList = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportInModuleProvider frameworkSupportInModuleProvider : list2) {
            if (!frameworkSupportInModuleProvider.isEnabledForModuleType(moduleType) || module2 != null && !frameworkSupportInModuleProvider.canAddSupport(module2, facetsProvider)) continue;
            arrayList.add(frameworkSupportInModuleProvider);
        }
        return arrayList;
    }

    public static List<FrameworkSupportInModuleProvider> getAllProviders() {
        ArrayList<FrameworkSupportInModuleProvider> arrayList = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportProvider frameworkSupportProvider : (FrameworkSupportProvider[])FrameworkSupportProvider.EXTENSION_POINT.getExtensions()) {
            arrayList.add(new OldFrameworkSupportProviderWrapper(frameworkSupportProvider));
        }
        for (FrameworkTypeEx frameworkTypeEx : (FrameworkTypeEx[])FrameworkTypeEx.EP_NAME.getExtensions()) {
            arrayList.add(frameworkTypeEx.createProvider());
        }
        return arrayList;
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleBuilder moduleBuilder) {
        if (moduleBuilder == null) {
            FrameworkSupportUtil.a(6);
        }
        ArrayList<FrameworkSupportInModuleProvider> arrayList = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportInModuleProvider frameworkSupportInModuleProvider : FrameworkSupportUtil.getAllProviders()) {
            if (!frameworkSupportInModuleProvider.isEnabledForModuleBuilder(moduleBuilder)) continue;
            arrayList.add(frameworkSupportInModuleProvider);
        }
        return arrayList;
    }

    public static boolean hasProviders(Module module2, @NotNull FacetsProvider facetsProvider) {
        if (facetsProvider == null) {
            FrameworkSupportUtil.a(7);
        }
        List<FrameworkSupportInModuleProvider> list2 = FrameworkSupportUtil.getProviders(module2, facetsProvider);
        for (FrameworkSupportInModuleProvider frameworkSupportInModuleProvider : list2) {
            if (frameworkSupportInModuleProvider.getFrameworkType().getUnderlyingFrameworkTypeId() != null) continue;
            return true;
        }
        return false;
    }

    public static Comparator<FrameworkSupportInModuleProvider> getFrameworkSupportProvidersComparator(List<FrameworkSupportInModuleProvider> list2) {
        DFSTBuilder dFSTBuilder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new ProvidersGraph(list2))));
        if (!dFSTBuilder.isAcyclic()) {
            Couple couple = dFSTBuilder.getCircularDependency();
            a.error("Circular dependency between types '" + ((FrameworkSupportInModuleProvider)couple.getFirst()).getFrameworkType().getId() + "' and '" + ((FrameworkSupportInModuleProvider)couple.getSecond()).getFrameworkType().getId() + "' was found.");
        }
        return dFSTBuilder.comparator();
    }

    public static FrameworkSupportInModuleProvider findProvider(@NotNull String string) {
        if (string == null) {
            FrameworkSupportUtil.a(8);
        }
        return FrameworkSupportUtil.findProvider(string, FrameworkSupportUtil.getAllProviders());
    }

    @Nullable
    public static FrameworkSupportInModuleProvider findProvider(@NotNull String string, List<FrameworkSupportInModuleProvider> list2) {
        if (string == null) {
            FrameworkSupportUtil.a(9);
        }
        for (FrameworkSupportInModuleProvider frameworkSupportInModuleProvider : list2) {
            String string2 = frameworkSupportInModuleProvider.getFrameworkType().getId();
            if (!string.equals(string2) && !string.equals("facet:" + string2)) continue;
            return frameworkSupportInModuleProvider;
        }
        a.info("Cannot find framework support provider '" + string + "'");
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProviders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProviders";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProvidersGraph
    implements InboundSemiGraph<FrameworkSupportInModuleProvider> {
        private final List<FrameworkSupportInModuleProvider> a;

        public ProvidersGraph(List<FrameworkSupportInModuleProvider> list2) {
            this.a = new ArrayList<FrameworkSupportInModuleProvider>(list2);
        }

        public Collection<FrameworkSupportInModuleProvider> getNodes() {
            return this.a;
        }

        public Iterator<FrameworkSupportInModuleProvider> getIn(FrameworkSupportInModuleProvider frameworkSupportInModuleProvider) {
            String[] stringArray;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string = frameworkSupportInModuleProvider.getFrameworkType().getUnderlyingFrameworkTypeId();
            if (string != null && (stringArray = FrameworkSupportUtil.findProvider(string, this.a)) != null) {
                arrayList.add(stringArray);
            }
            stringArray = frameworkSupportInModuleProvider.getDependenciesFrameworkIds().iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = (String[])stringArray.next();
                FrameworkSupportInModuleProvider frameworkSupportInModuleProvider2 = FrameworkSupportUtil.findProvider(stringArray2.getFrameworkId(), this.a);
                if (frameworkSupportInModuleProvider2 == null) continue;
                arrayList.add(frameworkSupportInModuleProvider2);
            }
            if (frameworkSupportInModuleProvider instanceof OldFrameworkSupportProviderWrapper) {
                for (String string2 : stringArray = ((OldFrameworkSupportProviderWrapper)frameworkSupportInModuleProvider).getProvider().getPrecedingFrameworkProviderIds()) {
                    FrameworkSupportInModuleProvider frameworkSupportInModuleProvider3 = FrameworkSupportUtil.findProvider(string2, this.a);
                    if (frameworkSupportInModuleProvider3 == null) continue;
                    arrayList.add(frameworkSupportInModuleProvider3);
                }
            }
            return arrayList.iterator();
        }
    }
}

