/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibrariesLayoutPanel;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class LibrariesDetectionStep
extends AbstractStepWithProgress<List<LibraryDescriptor>> {
    private final ProjectFromSourcesBuilder n;
    private final ProjectDescriptor l;
    private final ModuleInsight m;
    private final Icon j;
    private final String k;
    private LibrariesLayoutPanel i;
    int myPreviousStateHashCode = -1;

    public LibrariesDetectionStep(ProjectFromSourcesBuilder projectFromSourcesBuilder, ProjectDescriptor projectDescriptor, ModuleInsight moduleInsight, Icon icon, @NonNls String string) {
        super("Stop library analysis?");
        this.n = projectFromSourcesBuilder;
        this.l = projectDescriptor;
        this.m = moduleInsight;
        this.j = icon;
        this.k = string;
    }

    public void updateDataModel() {
        this.l.setLibraries(this.i.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.i = new LibrariesLayoutPanel(this.m);
        return this.i;
    }

    @Override
    protected String getProgressText() {
        return "Searching for libraries. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int n2 = this.a();
        try {
            boolean bl2 = n2 != this.myPreviousStateHashCode;
            return bl2;
        }
        finally {
            this.myPreviousStateHashCode = n2;
        }
    }

    private int a() {
        int n2 = this.n.getBaseProjectPath().hashCode();
        for (DetectedSourceRoot detectedSourceRoot : this.b()) {
            n2 = 31 * n2 + detectedSourceRoot.getDirectory().hashCode();
        }
        return n2;
    }

    @Override
    protected List<LibraryDescriptor> calculate() {
        List<DetectedSourceRoot> list2 = this.b();
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(FileTypeManager.getInstance().getIgnoredFilesList(), ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        this.m.setRoots(Collections.singletonList(new File(this.n.getBaseProjectPath())), list2, hashSet);
        this.m.scanLibraries();
        return this.m.getSuggestedLibraries();
    }

    private List<DetectedSourceRoot> b() {
        ArrayList<DetectedSourceRoot> arrayList = new ArrayList<DetectedSourceRoot>();
        for (ProjectStructureDetector projectStructureDetector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            for (DetectedProjectRoot detectedProjectRoot : this.n.getProjectRoots(projectStructureDetector)) {
                if (!this.m.isApplicableRoot(detectedProjectRoot)) continue;
                arrayList.add((DetectedSourceRoot)detectedProjectRoot);
            }
        }
        return arrayList;
    }

    @Override
    protected void onFinished(List<LibraryDescriptor> list2, boolean bl2) {
        this.i.rebuild();
    }

    public Icon getIcon() {
        return this.j;
    }

    public String getHelpId() {
        return this.k;
    }
}

