/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModulesLayoutPanel
extends ProjectLayoutPanel<ModuleDescriptor> {
    private final LibraryFilter e;

    public ModulesLayoutPanel(ModuleInsight moduleInsight, LibraryFilter libraryFilter) {
        super(moduleInsight);
        this.e = libraryFilter;
    }

    @Override
    protected String getElementName(ModuleDescriptor moduleDescriptor) {
        return moduleDescriptor.getName();
    }

    @Override
    protected void setElementName(ModuleDescriptor moduleDescriptor, String string) {
        moduleDescriptor.setName(string);
    }

    @Override
    protected List<ModuleDescriptor> getEntries() {
        List<ModuleDescriptor> list2 = this.getInsight().getSuggestedModules();
        return list2 != null ? list2 : Collections.emptyList();
    }

    @Override
    protected Collection getDependencies(ModuleDescriptor moduleDescriptor) {
        ArrayList<ModuleDescriptor> arrayList = new ArrayList<ModuleDescriptor>(moduleDescriptor.getDependencies());
        Collection<LibraryDescriptor> collection = this.getInsight().getLibraryDependencies(moduleDescriptor);
        for (LibraryDescriptor libraryDescriptor : collection) {
            if (!this.e.isLibraryChosen(libraryDescriptor)) continue;
            arrayList.add((ModuleDescriptor)((Object)libraryDescriptor));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected ModuleDescriptor merge(List<ModuleDescriptor> list2) {
        ModuleInsight moduleInsight = this.getInsight();
        ModuleDescriptor moduleDescriptor = null;
        for (ModuleDescriptor moduleDescriptor2 : list2) {
            if (moduleDescriptor == null) {
                moduleDescriptor = moduleDescriptor2;
                continue;
            }
            moduleInsight.merge(moduleDescriptor, moduleDescriptor2);
        }
        return moduleDescriptor;
    }

    @Override
    protected ModuleDescriptor split(ModuleDescriptor moduleDescriptor, String string, Collection<File> collection) {
        return this.getInsight().splitModule(moduleDescriptor, string, collection);
    }

    @Override
    protected Collection<File> getContent(ModuleDescriptor moduleDescriptor) {
        return moduleDescriptor.getContentRoots();
    }

    @Override
    protected String getEntriesChooserTitle() {
        return "Modules";
    }

    @Override
    protected String getDependenciesTitle() {
        return "Module dependencies";
    }

    @Override
    protected String getElementTypeName() {
        return "module";
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        return "&Select content roots to extract to the new module:";
    }

    @Override
    protected String getNameAlreadyUsedMessage(String string) {
        return "Module with name " + string + " already exists";
    }

    @Override
    protected String getStepDescriptionText() {
        return "Please review suggested module structure for the project. At this stage you can set module names,\nexclude particular modules from the project, merge or split individual modules.\nAll dependencies between the modules as well as dependencies on the libraries will be automatically updated.";
    }

    public static interface LibraryFilter {
        public boolean isLibraryChosen(LibraryDescriptor var1);
    }
}

