/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.StepWithSubSteps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectWizard
extends AbstractWizard<ModuleWizardStep> {
    protected final WizardContext myWizardContext;
    @Nullable
    private WizardDelegate a;

    public AbstractProjectWizard(String string, Project project2, String string2) {
        super(string, project2);
        this.myWizardContext = AbstractProjectWizard.a(project2, string2, this.getDisposable());
        this.myWizardContext.setWizard((AbstractWizard)this);
    }

    public AbstractProjectWizard(String string, Project project2, Component component) {
        super(string, component);
        this.myWizardContext = AbstractProjectWizard.a(project2, null, this.getDisposable());
        this.myWizardContext.setWizard((AbstractWizard)this);
    }

    protected String addStepComponent(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder((Border)JBUI.Borders.empty());
        }
        return super.addStepComponent(component);
    }

    public abstract StepSequence getSequence();

    private static WizardContext a(@Nullable Project project2, @Nullable String string, Disposable disposable) {
        WizardContext wizardContext = new WizardContext(project2, disposable);
        if (string != null) {
            wizardContext.setProjectFileDirectory(string, true);
            wizardContext.setProjectName(string.substring(FileUtil.toSystemIndependentName((String)string).lastIndexOf("/") + 1));
        }
        return wizardContext;
    }

    @Nullable
    public static Sdk getNewProjectJdk(WizardContext wizardContext) {
        if (wizardContext.getProjectJdk() != null) {
            return wizardContext.getProjectJdk();
        }
        return AbstractProjectWizard.getProjectSdkByDefault(wizardContext);
    }

    public static Sdk getProjectSdkByDefault(WizardContext wizardContext) {
        Project project2 = wizardContext.getProject() == null ? ProjectManager.getInstance().getDefaultProject() : wizardContext.getProject();
        Sdk sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (sdk != null) {
            return sdk;
        }
        return null;
    }

    @NotNull
    public String getNewProjectFilePath() {
        if (this.myWizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
            String string = this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".ipr";
            if (string == null) {
                AbstractProjectWizard.b(0);
            }
            return string;
        }
        String string = this.myWizardContext.getProjectFileDirectory();
        if (string == null) {
            AbstractProjectWizard.b(1);
        }
        return string;
    }

    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myWizardContext.getProjectStorageFormat();
        if (storageScheme == null) {
            AbstractProjectWizard.b(2);
        }
        return storageScheme;
    }

    public ProjectBuilder getProjectBuilder() {
        return this.myWizardContext.getProjectBuilder();
    }

    public String getProjectName() {
        return this.myWizardContext.getProjectName();
    }

    @Nullable
    public Sdk getNewProjectJdk() {
        return AbstractProjectWizard.getNewProjectJdk(this.myWizardContext);
    }

    @NotNull
    public String getNewCompileOutput() {
        String string = this.myWizardContext.getProjectFileDirectory();
        String string2 = this.myWizardContext.getCompilerOutputDirectory();
        if (string2 == null) {
            string2 = StringUtil.endsWithChar((CharSequence)string, (char)'/') ? string + "out" : string + "/out";
        }
        String string3 = string2;
        if (string3 == null) {
            AbstractProjectWizard.b(3);
        }
        return string3;
    }

    @Nullable
    public ProjectBuilder getBuilder(Project project2) {
        ProjectBuilder projectBuilder = this.getProjectBuilder();
        if (projectBuilder instanceof ModuleBuilder) {
            ModuleBuilder moduleBuilder = (ModuleBuilder)projectBuilder;
            if (moduleBuilder.getName() == null) {
                moduleBuilder.setName(this.getProjectName());
            }
            if (moduleBuilder.getModuleFilePath() == null) {
                moduleBuilder.setModuleFilePath(this.getModuleFilePath());
            }
        }
        if (projectBuilder == null || !projectBuilder.validate(project2, project2)) {
            return null;
        }
        return projectBuilder;
    }

    protected void updateStep() {
        if (!this.mySteps.isEmpty()) {
            ((ModuleWizardStep)this.getCurrentStepObject()).updateStep();
        }
        super.updateStep();
        this.myIcon.setIcon(null);
    }

    protected void dispose() {
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            for (ModuleWizardStep moduleWizardStep : stepSequence.getAllSteps()) {
                moduleWizardStep.disposeUIResources();
            }
        }
        super.dispose();
    }

    protected final void doOKAction() {
        if (!this.doFinishAction()) {
            return;
        }
        super.doOKAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean doFinishAction() {
        if (this.a != null) {
            this.a.doFinishAction();
            return true;
        }
        int n2 = this.getCurrentStep();
        try {
            while (true) {
                ModuleWizardStep moduleWizardStep;
                if ((moduleWizardStep = (ModuleWizardStep)this.mySteps.get(n2)) != this.getCurrentStepObject()) {
                    moduleWizardStep.updateStep();
                }
                if (!this.commitStepData(moduleWizardStep)) {
                    boolean bl2 = false;
                    return bl2;
                }
                moduleWizardStep.onStepLeaving();
                try {
                    moduleWizardStep._commit(true);
                }
                catch (CommitStepException commitStepException) {
                    this.a(commitStepException);
                    boolean bl3 = false;
                    this.myCurrentStep = n2;
                    this.updateStep();
                    return bl3;
                }
                if (this.a(n2)) break;
                n2 = this.getNextStep(n2);
            }
            for (ModuleWizardStep moduleWizardStep : this.mySteps) {
                try {
                    moduleWizardStep.onWizardFinished();
                }
                catch (CommitStepException commitStepException) {
                    this.a(commitStepException);
                    boolean bl4 = false;
                    this.myCurrentStep = n2;
                    this.updateStep();
                    return bl4;
                }
            }
        }
        finally {
            this.myCurrentStep = n2;
            this.updateStep();
        }
        return true;
    }

    private void a(CommitStepException commitStepException) {
        String string = commitStepException.getMessage();
        if (string != null) {
            Messages.showErrorDialog((Component)this.getCurrentStepComponent(), (String)string);
        }
    }

    protected boolean commitStepData(ModuleWizardStep moduleWizardStep) {
        try {
            if (!moduleWizardStep.validate()) {
                return false;
            }
        }
        catch (ConfigurationException configurationException) {
            Messages.showErrorDialog((Component)this.myContentPanel, (String)configurationException.getMessage(), (String)configurationException.getTitle());
            return false;
        }
        moduleWizardStep.updateDataModel();
        return true;
    }

    public void doNextAction() {
        if (this.a != null) {
            this.a.doNextAction();
            return;
        }
        ModuleWizardStep moduleWizardStep = (ModuleWizardStep)this.getCurrentStepObject();
        if (!this.commitStepData(moduleWizardStep)) {
            return;
        }
        moduleWizardStep.onStepLeaving();
        super.doNextAction();
    }

    protected String getHelpID() {
        ModuleWizardStep moduleWizardStep = (ModuleWizardStep)this.getCurrentStepObject();
        if (moduleWizardStep != null) {
            return moduleWizardStep.getHelpId();
        }
        return null;
    }

    public boolean isLast() {
        return this.isLastStep();
    }

    @NonNls
    public String getModuleFilePath() {
        return this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".iml";
    }

    protected void doPreviousAction() {
        if (this.a != null) {
            this.a.doPreviousAction();
            return;
        }
        ModuleWizardStep moduleWizardStep = (ModuleWizardStep)this.getCurrentStepObject();
        moduleWizardStep.onStepLeaving();
        if (moduleWizardStep instanceof StepWithSubSteps) {
            ((StepWithSubSteps)moduleWizardStep).doPreviousAction();
        }
        super.doPreviousAction();
    }

    protected boolean canGoNext() {
        return this.a != null ? this.a.canProceed() : super.canGoNext();
    }

    public void doCancelAction() {
        ModuleWizardStep moduleWizardStep = (ModuleWizardStep)this.getCurrentStepObject();
        moduleWizardStep.onStepLeaving();
        super.doCancelAction();
    }

    protected boolean isLastStep() {
        return this.a(this.getCurrentStep());
    }

    private boolean a(int n2) {
        return this.getNextStep(n2) == n2 && !AbstractProjectWizard.a((ModuleWizardStep)this.mySteps.get(n2));
    }

    protected final int getNextStep(int n2) {
        ModuleWizardStep moduleWizardStep = null;
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            ModuleWizardStep moduleWizardStep2 = (ModuleWizardStep)this.mySteps.get(n2);
            if (AbstractProjectWizard.a(moduleWizardStep2)) {
                return n2;
            }
            moduleWizardStep = stepSequence.getNextStep(moduleWizardStep2);
            while (moduleWizardStep != null && !moduleWizardStep.isStepVisible()) {
                moduleWizardStep = stepSequence.getNextStep(moduleWizardStep);
            }
        }
        return moduleWizardStep == null ? n2 : this.mySteps.indexOf(moduleWizardStep);
    }

    protected final int getPreviousStep(int n2) {
        ModuleWizardStep moduleWizardStep = null;
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            ModuleWizardStep moduleWizardStep2 = (ModuleWizardStep)this.mySteps.get(n2);
            if (AbstractProjectWizard.b(moduleWizardStep2)) {
                return n2;
            }
            moduleWizardStep = stepSequence.getPreviousStep(moduleWizardStep2);
            while (moduleWizardStep != null && !moduleWizardStep.isStepVisible()) {
                moduleWizardStep = stepSequence.getPreviousStep(moduleWizardStep);
            }
        }
        return moduleWizardStep == null ? 0 : this.mySteps.indexOf(moduleWizardStep);
    }

    private static boolean a(ModuleWizardStep moduleWizardStep) {
        return moduleWizardStep instanceof StepWithSubSteps && !((StepWithSubSteps)moduleWizardStep).isLast();
    }

    private static boolean b(ModuleWizardStep moduleWizardStep) {
        return moduleWizardStep instanceof StepWithSubSteps && !((StepWithSubSteps)moduleWizardStep).isFirst();
    }

    public void setDelegate(@Nullable WizardDelegate wizardDelegate) {
        this.a = wizardDelegate;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/newProjectWizard/AbstractProjectWizard";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewProjectFilePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewCompileOutput";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

