/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourcePathsStep
extends AbstractStepWithProgress<List<JavaModuleSourceRoot>> {
    private static final Logger o = Logger.getInstance((String)"#com.intellij.ide.util.newProjectWizard.SourcePathsStep");
    private String n;
    @NonNls
    private static final String u = "create_source";
    @NonNls
    private static final String l = "choose_source";
    private final SourcePathsBuilder j;
    private final Icon m;
    private final String t;
    private ElementsChooser<JavaModuleSourceRoot> k;
    private String v = null;
    private JRadioButton q;
    private JRadioButton s;
    private JTextField p;
    private JTextField r;
    private JPanel i;

    public SourcePathsStep(SourcePathsBuilder sourcePathsBuilder, Icon icon, @NonNls String string) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.j = sourcePathsBuilder;
        this.m = icon;
        this.t = string;
    }

    @Override
    protected JComponent createResultsPanel() {
        this.i = new JPanel(new CardLayout());
        this.i.add((Component)this.d(), u);
        this.i.add((Component)this.b(), l);
        return this.i;
    }

    private JComponent d() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = IdeBundle.message((String)"prompt.please.specify.java.sources.directory", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.q = new JRadioButton(IdeBundle.message((String)"radio.create.source.directory", (Object[])new Object[0]), true);
        jPanel.add((Component)this.q, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.p = new JTextField(this.suggestSourceDirectoryName());
        final JLabel jLabel2 = new JLabel(IdeBundle.message((String)"prompt.enter.relative.path.to.module.content.root", (Object[])new Object[]{File.separator}));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)0), 0, 0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.withTreeRootVisible(true);
        final FieldPanel fieldPanel = SourcePathsStep.createFieldPanel((JTextField)this.p, null, (BrowseFilesListener)new BrowsePathListener(this.p, fileChooserDescriptor));
        jPanel.add((Component)fieldPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)10), 0, 0));
        this.s = new JRadioButton(IdeBundle.message((String)"radio.do.not.create.source.directory", (Object[])new Object[0]), true);
        jPanel.add((Component)this.s, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        final JLabel jLabel3 = new JLabel(IdeBundle.message((String)"label.source.directory", (Object[])new Object[0]));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.r = new JTextField();
        this.r.setEditable(false);
        this.r.setOpaque(false);
        Insets insets = this.r.getBorder().getBorderInsets(this.r);
        this.r.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        jPanel.add((Component)this.r, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.q);
        buttonGroup.add(this.s);
        this.p.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent documentEvent) {
                SourcePathsStep.this.c();
            }
        });
        this.q.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl2 = itemEvent.getStateChange() == 1;
                jLabel2.setEnabled(bl2);
                fieldPanel.setEnabled(bl2);
                jLabel3.setVisible(bl2);
                SourcePathsStep.this.r.setVisible(bl2);
                if (bl2) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)SourcePathsStep.this.p, true));
                }
            }
        });
        return jPanel;
    }

    @NonNls
    protected String suggestSourceDirectoryName() {
        return "src";
    }

    private void c() {
        String string = this.e();
        if (string != null) {
            this.r.setText(string.replace('/', File.separatorChar));
        } else {
            this.r.setText("");
        }
    }

    private JComponent b() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.k = new ElementsChooser<JavaModuleSourceRoot>(true){

            public String getItemText(@NotNull JavaModuleSourceRoot javaModuleSourceRoot) {
                if (javaModuleSourceRoot == null) {
                    3.a(0);
                }
                String string = javaModuleSourceRoot.getPackagePrefix();
                return javaModuleSourceRoot.getDirectory().getAbsolutePath() + (string.isEmpty() ? "" : " (" + string + ")") + " [" + javaModuleSourceRoot.getRootTypeName() + "]";
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/ide/util/newProjectWizard/SourcePathsStep$3", "getItemText"));
            }
        };
        String string = IdeBundle.message((String)"label.java.source.files.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.k, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourcePathsStep.this.k.setAllElementsMarked(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourcePathsStep.this.k.setAllElementsMarked(false);
            }
        });
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.q.isSelected() ? this.p : this.k.getComponent();
    }

    public void updateDataModel() {
        String string;
        List<Object> list2 = null;
        if (l.equals(this.n)) {
            List list3 = this.k.getMarkedElements();
            if (list3.size() > 0) {
                list2 = new ArrayList(list3.size());
                for (JavaModuleSourceRoot javaModuleSourceRoot : list3) {
                    list2.add(Pair.create((Object)FileUtil.toSystemIndependentName((String)javaModuleSourceRoot.getDirectory().getAbsolutePath()), (Object)javaModuleSourceRoot.getPackagePrefix()));
                }
            }
        } else if (this.q.isSelected() && (string = this.e()) != null) {
            list2 = Collections.singletonList(Pair.create((Object)string, (Object)""));
        }
        this.j.setContentEntryPath(this.a());
        if (list2 != null) {
            this.j.setSourcePaths(list2);
        } else {
            this.j.setSourcePaths(new ArrayList());
        }
    }

    @Override
    public boolean validate() throws ConfigurationException {
        if (!super.validate()) {
            return false;
        }
        if (u.equals(this.n) && this.q.isSelected()) {
            Object object;
            String string = this.e();
            String string2 = this.p.getText().trim();
            if (string2.length() == 0) {
                object = IdeBundle.message((String)"prompt.relative.path.to.sources.empty", (Object[])new Object[]{FileUtil.toSystemDependentName((String)string)});
                int n2 = Messages.showYesNoCancelDialog((Component)this.p, (String)object, (String)IdeBundle.message((String)"title.mark.source.directory", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.mark", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.do.not.mark", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (n2 == 2) {
                    return false;
                }
                if (n2 == 1) {
                    this.s.doClick();
                }
            }
            if (string != null) {
                File file;
                object = new File(this.a());
                if (!FileUtil.isAncestor((File)object, (File)(file = new File(string)), (boolean)false)) {
                    Messages.showErrorDialog((Component)this.p, (String)IdeBundle.message((String)"error.source.directory.should.be.under.module.content.root.directory", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
                    return false;
                }
                try {
                    VfsUtil.createDirectories((String)file.getPath());
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(iOException.getMessage());
                }
            }
        }
        return true;
    }

    @Nullable
    private String e() {
        String string = this.a();
        if (string != null) {
            String string2 = this.p.getText().trim().replace(File.separatorChar, '/');
            return string2.length() > 0 ? string + "/" + string2 : string;
        }
        return null;
    }

    @Override
    protected boolean shouldRunProgress() {
        return this.isContentEntryChanged();
    }

    @Override
    protected void onFinished(List<JavaModuleSourceRoot> list2, boolean bl2) {
        if (list2.size() > 0) {
            this.n = l;
            this.k.setElements(list2, true);
        } else {
            this.n = u;
            this.c();
        }
        this.b(bl2 ? null : this.a());
        if (l.equals(this.n)) {
            this.k.selectElements(list2.subList(0, 1));
        } else if (u.equals(this.n)) {
            this.p.selectAll();
        }
    }

    private void b(String string) {
        this.v = string;
        ((CardLayout)this.i.getLayout()).show(this.i, this.n);
        this.i.revalidate();
    }

    protected boolean isContentEntryChanged() {
        String string = this.a();
        return this.v == null ? string != null : !this.v.equals(string);
    }

    @Override
    protected List<JavaModuleSourceRoot> calculate() {
        return new ArrayList<JavaModuleSourceRoot>(SourcePathsStep.calculateSourceRoots(this.a()));
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> calculateSourceRoots(String string) {
        if (string == null) {
            List<JavaModuleSourceRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                SourcePathsStep.a(0);
            }
            return list2;
        }
        Collection<JavaModuleSourceRoot> collection = JavaSourceRootDetectionUtil.suggestRoots(new File(string));
        if (collection == null) {
            SourcePathsStep.a(1);
        }
        return collection;
    }

    @Nullable
    private String a() {
        return this.j.getContentEntryPath();
    }

    protected void setSourceDirectoryName(String string) {
        string = string == null ? "" : string.trim();
        this.p.setText(string);
    }

    @Override
    protected String getProgressText() {
        String string = this.a();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{string != null ? string.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.m;
    }

    public String getHelpId() {
        return this.t;
    }

    public String getName() {
        return "Path to Sources";
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SourcePathsStep", "calculateSourceRoots"));
    }

    private class BrowsePathListener
    extends BrowseFilesListener {
        private final FileChooserDescriptor b;
        private final JTextField a;

        public BrowsePathListener(JTextField jTextField, FileChooserDescriptor fileChooserDescriptor) {
            super(jTextField, IdeBundle.message((String)"prompt.select.source.directory", (Object[])new Object[0]), "", fileChooserDescriptor);
            this.b = fileChooserDescriptor;
            this.a = jTextField;
        }

        @Nullable
        private VirtualFile a() {
            String string = SourcePathsStep.this.a();
            if (string != null) {
                return (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(string));
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VirtualFile virtualFile = this.a();
            if (virtualFile != null) {
                this.b.setRoots(new VirtualFile[]{virtualFile});
                String string = this.a.getText().trim();
                super.actionPerformed(actionEvent);
                if (!string.equals(this.a.getText().trim())) {
                    String string2 = this.a.getText().trim().replace(File.separatorChar, '/');
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string2);
                    o.assertTrue(virtualFile2 != null);
                    this.a.setText(VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (char)File.separatorChar));
                }
            }
        }
    }
}

