/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractStepWithProgress<Result>
extends ModuleWizardStep {
    @NonNls
    private static final String a = "progress_panel";
    @NonNls
    private static final String g = "results_panel";
    private JPanel h;
    private JLabel f;
    private JLabel c;
    private JLabel e;
    private ProgressIndicator d = null;
    private final String b;

    public AbstractStepWithProgress(String string) {
        this.b = string;
    }

    public final JComponent getComponent() {
        if (this.h == null) {
            this.h = new JPanel(new CardLayout());
            this.h.setBorder(BorderFactory.createEtchedBorder());
            this.h.add((Component)this.a(), a);
            this.h.add((Component)this.createResultsPanel(), g);
        }
        return this.h;
    }

    protected abstract JComponent createResultsPanel();

    protected abstract String getProgressText();

    protected abstract boolean shouldRunProgress();

    protected abstract Result calculate();

    protected abstract void onFinished(Result var1, boolean var2);

    private JPanel a() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.f = new JLabel();
        this.f.setFont(UIUtil.getLabelFont().deriveFont(1));
        jPanel.add((Component)this.f, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)5, (int)10), 0, 0));
        this.c = new JLabel();
        jPanel.add((Component)this.c, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.e = new JLabel(){

            @Override
            public void setText(String string) {
                super.setText(StringUtil.trimMiddle((String)string, (int)80));
            }
        };
        jPanel.add((Component)this.e, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.stop.searching", (Object[])new Object[0]));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStepWithProgress.this.d();
            }
        });
        jPanel.add((Component)jButton, new GridBagConstraints(1, -1, 1, 2, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)10), 0, 0));
        return jPanel;
    }

    public void performStep() {
        Result Result2 = this.calculate();
        this.createResultsPanel();
        this.onFinished(Result2, false);
        this.updateDataModel();
    }

    private void d() {
        if (this.d != null) {
            this.d.cancel();
        }
    }

    private synchronized boolean c() {
        return this.d != null && this.d.isRunning();
    }

    public void updateStep() {
        if (this.shouldRunProgress()) {
            this.runProgress();
        } else {
            this.a(g);
        }
    }

    protected void runProgress() {
        final MyProgressIndicator myProgressIndicator = new MyProgressIndicator();
        myProgressIndicator.setModalityProgress(null);
        String string = this.getProgressText();
        if (string != null) {
            this.f.setText(string);
        }
        this.a(a);
        this.d = myProgressIndicator;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Object object = ProgressManager.getInstance().runProcess(() -> this.calculate(), (ProgressIndicator)myProgressIndicator);
            this.onFinished(object, false);
            return;
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this.h, () -> new SwingWorker(){

            public Object construct() {
                Ref ref = Ref.create(null);
                ProgressManager.getInstance().runProcess(() -> ref.set(AbstractStepWithProgress.this.calculate()), (ProgressIndicator)myProgressIndicator);
                return ref.get();
            }

            public void finished() {
                AbstractStepWithProgress.this.d = null;
                ApplicationManager.getApplication().invokeLater(() -> {
                    Object object = this.get();
                    AbstractStepWithProgress.this.onFinished(object, myProgressIndicator.isCanceled());
                    AbstractStepWithProgress.this.a(AbstractStepWithProgress.g);
                });
            }
        }.start());
    }

    private void a(String string) {
        ((CardLayout)this.h.getLayout()).show(this.h, string);
        this.h.revalidate();
    }

    public boolean validate() throws ConfigurationException {
        if (this.c()) {
            int n2 = Messages.showOkCancelDialog((Component)this.getComponent(), (String)this.b, (String)IdeBundle.message((String)"title.question", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.continue.searching", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.stop.searching", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (n2 != 0) {
                this.d();
            }
            return false;
        }
        return true;
    }

    public void onStepLeaving() {
        if (this.c()) {
            this.d();
        }
    }

    protected class MyProgressIndicator
    extends ProgressIndicatorBase {
        protected MyProgressIndicator() {
        }

        public void setText(String string) {
            this.b(AbstractStepWithProgress.this.c, string);
            super.setText(string);
        }

        public void setText2(String string) {
            this.b(AbstractStepWithProgress.this.e, string);
            super.setText2(string);
        }

        private void b(JLabel jLabel, String string) {
            UIUtil.invokeLaterIfNeeded(() -> jLabel.setText(string));
        }
    }
}

