/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ProjectJdkListRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkChooserPanel
extends JPanel {
    private JList c = null;
    private DefaultListModel b = null;
    private Sdk a;
    @Nullable
    private final Project d;
    private SdkType[] e = null;

    public JdkChooserPanel(@Nullable Project project2) {
        super(new BorderLayout());
        this.d = project2;
        this.b = new DefaultListModel();
        this.c = new JBList((ListModel)this.b);
        this.c.setSelectionMode(0);
        this.c.setCellRenderer(new ProjectJdkListRenderer());
        this.c.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JdkChooserPanel.this.a = (Sdk)JdkChooserPanel.this.c.getSelectedValue();
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent mouseEvent, int n2) {
                if (mouseEvent == null) {
                    2.a(0);
                }
                if (JdkChooserPanel.this.d == null) {
                    JdkChooserPanel.this.editJdkTable();
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/JdkChooserPanel$2", "onClick"));
            }
        }.installOn((Component)this.c);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.c), "Center");
        this.add((Component)jPanel, "Center");
        if (this.b.getSize() > 0) {
            this.c.setSelectedIndex(0);
        }
    }

    public void setAllowedJdkTypes(@Nullable SdkType[] sdkTypeArray) {
        this.e = sdkTypeArray;
    }

    public Sdk getChosenJdk() {
        return this.a;
    }

    public Object[] getAllJdks() {
        return this.b.toArray();
    }

    public void editJdkTable() {
        ProjectJdksEditor projectJdksEditor = new ProjectJdksEditor((Sdk)this.c.getSelectedValue(), this.d != null ? this.d : ProjectManager.getInstance().getDefaultProject(), this.c);
        if (projectJdksEditor.showAndGet()) {
            Sdk sdk = projectJdksEditor.getSelectedJdk();
            this.updateList(sdk, null);
        }
    }

    public void updateList(Sdk sdk, @Nullable SdkType sdkType) {
        this.updateList(sdk, sdkType, null);
    }

    public void updateList(Sdk sdk, @Nullable SdkType sdkType, @Nullable Sdk[] sdkArray) {
        int[] nArray = this.c.getSelectedIndices();
        this.fillList(sdkType, sdkArray);
        if (sdk != null) {
            TIntArrayList tIntArrayList = new TIntArrayList();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                Sdk sdk2 = (Sdk)this.b.getElementAt(i2);
                if (!Comparing.strEqual((String)sdk2.getName(), (String)sdk.getName())) continue;
                tIntArrayList.add(i2);
            }
            int[] nArray2 = tIntArrayList.toNativeArray();
            if (nArray2.length > 0) {
                this.c.setSelectedIndices(nArray2);
            } else if (this.c.getModel().getSize() > 0) {
                this.c.setSelectedIndex(0);
            }
        } else if (nArray.length > 0) {
            this.c.setSelectedIndices(nArray);
        } else {
            this.c.setSelectedIndex(0);
        }
        this.a = (Sdk)this.c.getSelectedValue();
    }

    public JList getPreferredFocusedComponent() {
        return this.c;
    }

    public void fillList(@Nullable SdkType sdkType, @Nullable Sdk[] sdkArray) {
        Sdk[] sdkArray2;
        Sdk[] sdkArray3;
        this.b.clear();
        if (this.d == null || this.d.isDefault()) {
            sdkArray3 = sdkArray != null ? sdkArray : ProjectJdkTable.getInstance().getAllJdks();
            sdkArray2 = this.a(sdkType, Arrays.asList(sdkArray3));
        } else {
            sdkArray3 = ProjectStructureConfigurable.getInstance(this.d).getProjectJdksModel();
            if (!sdkArray3.isInitialized()) {
                sdkArray3.reset(this.d);
            }
            Collection<Sdk> collection = sdkArray3.getProjectSdks().values();
            sdkArray2 = this.a(sdkType, collection);
        }
        Arrays.sort(sdkArray2, (sdk, sdk2) -> sdk.getName().compareToIgnoreCase(sdk2.getName()));
        for (Sdk sdk3 : sdkArray2) {
            this.b.addElement(sdk3);
        }
    }

    private Sdk[] a(@Nullable SdkType sdkType, Collection<Sdk> collection) {
        HashSet<Sdk> hashSet = new HashSet<Sdk>();
        for (Sdk sdk : collection) {
            if (!this.a(sdk, sdkType)) continue;
            hashSet.add(sdk);
        }
        return hashSet.toArray(new Sdk[0]);
    }

    private boolean a(Sdk sdk, @Nullable SdkType sdkType) {
        if (sdkType != null) {
            return sdk.getSdkType() == sdkType;
        }
        if (this.e != null) {
            return ArrayUtil.indexOf((Object[])this.e, (Object)sdk.getSdkType()) >= 0;
        }
        return true;
    }

    public JComponent getDefaultFocusedComponent() {
        return this.c;
    }

    public void selectJdk(Sdk sdk) {
        int n2 = this.b.indexOf(sdk);
        if (n2 >= 0) {
            this.c.setSelectedIndex(n2);
        }
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.c.addListSelectionListener(listSelectionListener);
    }

    private static Sdk a(Project project2, String string, Component component, Sdk sdk) {
        JdkChooserPanel jdkChooserPanel = new JdkChooserPanel(project2);
        jdkChooserPanel.fillList(null, null);
        JdkChooserPanel jdkChooserPanel2 = jdkChooserPanel;
        jdkChooserPanel2.getClass();
        final MyDialog myDialog = jdkChooserPanel2.new MyDialog(component);
        if (string != null) {
            myDialog.setTitle(string);
        }
        if (sdk != null) {
            jdkChooserPanel.selectJdk(sdk);
        } else {
            ScrollingUtil.ensureSelectionExists((JList)jdkChooserPanel.c);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent mouseEvent) {
                myDialog.clickDefaultButton();
                return true;
            }
        }.installOn((Component)jdkChooserPanel.c);
        return myDialog.showAndGet() ? jdkChooserPanel.getChosenJdk() : null;
    }

    public static Sdk chooseAndSetJDK(Project project2) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        Sdk sdk2 = JdkChooserPanel.a(project2, ProjectBundle.message((String)"module.libraries.target.jdk.select.title", (Object[])new Object[0]), (Component)WindowManagerEx.getInstanceEx().getFrame(project2), sdk);
        if (sdk2 == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)project2).setProjectSdk(sdk2));
        return sdk2;
    }

    public class MyDialog
    extends DialogWrapper
    implements ListSelectionListener {
        public MyDialog(Component component) {
            super(component, true);
            this.setTitle(IdeBundle.message((String)"title.select.jdk", (Object[])new Object[0]));
            this.init();
            JdkChooserPanel.this.c.addListSelectionListener(this);
            this.a();
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.util.projectWizard.JdkChooserPanel.MyDialog";
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.a();
        }

        private void a() {
            this.setOKActionEnabled(JdkChooserPanel.this.c.getSelectedValue() != null);
        }

        public void dispose() {
            JdkChooserPanel.this.c.removeListSelectionListener(this);
            super.dispose();
        }

        protected JComponent createCenterPanel() {
            return JdkChooserPanel.this;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{new ConfigureAction(), this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                MyDialog.a(0);
            }
            return actionArray;
        }

        public JComponent getPreferredFocusedComponent() {
            return JdkChooserPanel.this.c;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/JdkChooserPanel$MyDialog", "createActions"));
        }

        private final class ConfigureAction
        extends AbstractAction {
            public ConfigureAction() {
                super(IdeBundle.message((String)"button.configure.e", (Object[])new Object[0]));
                this.putValue("MnemonicKey", new Integer(69));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JdkChooserPanel.this.editJdkTable();
            }
        }
    }
}

