/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSettingsStep
extends ModuleWizardStep {
    protected final JdkComboBox myJdkComboBox;
    protected final WizardContext myWizardContext;
    protected final ProjectSdksModel myModel;
    private final ModuleBuilder b;
    private final JPanel a;

    public SdkSettingsStep(SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> condition) {
        if (moduleBuilder == null) {
            SdkSettingsStep.a(0);
        }
        if (condition == null) {
            SdkSettingsStep.a(1);
        }
        this(settingsStep, moduleBuilder, condition, null);
    }

    public SdkSettingsStep(SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> condition, @Nullable Condition<Sdk> condition2) {
        if (moduleBuilder == null) {
            SdkSettingsStep.a(2);
        }
        if (condition == null) {
            SdkSettingsStep.a(3);
        }
        this(settingsStep.getContext(), moduleBuilder, condition, condition2);
        if (!this.isEmpty()) {
            settingsStep.addSettingsField(this.getSdkFieldLabel(settingsStep.getContext().getProject()), (JComponent)this.a);
        }
    }

    public SdkSettingsStep(WizardContext wizardContext, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> condition, @Nullable Condition<Sdk> condition2) {
        SdkType sdkType;
        if (moduleBuilder == null) {
            SdkSettingsStep.a(4);
        }
        if (condition == null) {
            SdkSettingsStep.a(5);
        }
        this.b = moduleBuilder;
        this.myWizardContext = wizardContext;
        this.myModel = new ProjectSdksModel();
        Project project2 = this.myWizardContext.getProject();
        this.myModel.reset(project2);
        if (condition2 == null) {
            condition2 = JdkComboBox.getSdkFilter(condition);
        }
        this.myJdkComboBox = new JdkComboBox(this.myModel, condition, condition2, condition, true);
        this.a = new JPanel(new GridBagLayout());
        final PropertiesComponent propertiesComponent = project2 == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project2);
        ModuleType moduleType = moduleBuilder.getModuleType();
        final String string = "jdk.selected." + (moduleType == null ? "" : moduleType.getId());
        this.myJdkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Sdk sdk = SdkSettingsStep.this.myJdkComboBox.getSelectedJdk();
                if (sdk != null) {
                    propertiesComponent.setValue(string, sdk.getName());
                }
                SdkSettingsStep.this.onSdkSelected(sdk);
            }
        });
        Sdk sdk = this.a(project2, propertiesComponent.getValue(string), condition);
        this.myJdkComboBox.setSelectedJdk(sdk);
        JButton jButton = new JButton("Ne\u001bw...");
        this.myJdkComboBox.setSetupButton(jButton, project2, this.myModel, project2 == null ? new JdkComboBox.NoneJdkComboBoxItem() : new JdkComboBox.ProjectJdkComboBoxItem(), null, false);
        this.a.add((Component)((Object)this.myJdkComboBox), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.a.add((Component)this.myJdkComboBox.getSetUpButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
        if (this.myJdkComboBox.getItemCount() == 0 && (sdkType = (SdkType)ContainerUtil.find((Object[])SdkType.getAllTypes(), condition)) != null && sdkType.getDownloadSdkUrl() != null) {
            HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("Download " + sdkType.getPresentableName());
            hyperlinkLabel.setHyperlinkTarget(sdkType.getDownloadSdkUrl());
            this.a.add((Component)hyperlinkLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        }
    }

    private Sdk a(Project project2, String string, Condition<SdkTypeId> condition) {
        Sdk sdk;
        if (project2 != null && (sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk()) != null && this.b.isSuitableSdkType(sdk.getSdkType())) {
            this.myJdkComboBox.insertItemAt(new JdkComboBox.ProjectJdkComboBoxItem(), 0);
            return null;
        }
        if (string != null && (sdk = ProjectJdkTable.getInstance().findJdk(string)) != null && this.b.isSuitableSdkType(sdk.getSdkType())) {
            return sdk;
        }
        sdk = ProjectManager.getInstance().getDefaultProject();
        Sdk sdk2 = ProjectRootManager.getInstance((Project)sdk).getProjectSdk();
        if (sdk2 != null && condition.value((Object)sdk2.getSdkType())) {
            return sdk2;
        }
        return this.myJdkComboBox.getSelectedJdk();
    }

    protected void onSdkSelected(Sdk sdk) {
    }

    public boolean isEmpty() {
        return this.a.getComponentCount() == 0;
    }

    @NotNull
    protected String getSdkFieldLabel(@Nullable Project project2) {
        String string = (project2 == null ? "Project" : "Module") + " \u001bSDK:";
        if (string == null) {
            SdkSettingsStep.a(6);
        }
        return string;
    }

    public JComponent getComponent() {
        return this.a;
    }

    public void updateDataModel() {
        Project project2 = this.myWizardContext.getProject();
        Sdk sdk = this.myJdkComboBox.getSelectedJdk();
        if (project2 == null) {
            this.myWizardContext.setProjectJdk(sdk);
        } else {
            this.b.setModuleJdk(sdk);
        }
    }

    public boolean validate() throws ConfigurationException {
        block4: {
            JdkComboBox.JdkComboBoxItem jdkComboBoxItem = this.myJdkComboBox.getSelectedItem();
            if (this.myJdkComboBox.getSelectedJdk() == null && !(jdkComboBoxItem instanceof JdkComboBox.ProjectJdkComboBoxItem) && !(jdkComboBoxItem instanceof JdkComboBox.SuggestedJdkItem) && Messages.showDialog((String)this.getNoSdkMessage(), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            try {
                if (jdkComboBoxItem instanceof JdkComboBox.SuggestedJdkItem) {
                    SdkType sdkType = ((JdkComboBox.SuggestedJdkItem)jdkComboBoxItem).getSdkType();
                    String string = ((JdkComboBox.SuggestedJdkItem)jdkComboBoxItem).getPath();
                    this.myModel.addSdk(sdkType, string, sdk -> {
                        this.myJdkComboBox.reloadModel(new JdkComboBox.ActualJdkComboBoxItem((Sdk)sdk), this.myWizardContext.getProject());
                        this.myJdkComboBox.setSelectedJdk((Sdk)sdk);
                    });
                }
                this.myModel.apply(null, true);
            }
            catch (ConfigurationException configurationException) {
                if (Messages.showDialog((String)(configurationException.getMessage() + "/nDo you want to proceed?"), (String)configurationException.getTitle(), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) == 0) break block4;
                return false;
            }
        }
        return true;
    }

    protected String getNoSdkMessage() {
        return IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuilder";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeIdFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/SdkSettingsStep";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/SdkSettingsStep";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkFieldLabel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

