/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IvyAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger b = Logger.getInstance(IvyAttachSourceProvider.class);

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> list2, PsiFile psiFile) {
        Object object;
        String string;
        VirtualFile virtualFile = IvyAttachSourceProvider.getJarByPsiFile(psiFile);
        if (virtualFile == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list3 = Collections.emptyList();
            if (list3 == null) {
                IvyAttachSourceProvider.b(0);
            }
            return list3;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        if (virtualFile2 == null || !virtualFile2.getName().equals("jars")) {
            List<AttachSourcesProvider.AttachSourcesAction> list4 = Collections.emptyList();
            if (list4 == null) {
                IvyAttachSourceProvider.b(1);
            }
            return list4;
        }
        final VirtualFile virtualFile3 = virtualFile2.getParent();
        if (virtualFile3 == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list5 = Collections.emptyList();
            if (list5 == null) {
                IvyAttachSourceProvider.b(2);
            }
            return list5;
        }
        String string2 = virtualFile.getNameWithoutExtension();
        if (!string2.startsWith(string = virtualFile3.getName()) || !string2.substring(string.length()).startsWith("-")) {
            List<AttachSourcesProvider.AttachSourcesAction> list6 = Collections.emptyList();
            if (list6 == null) {
                IvyAttachSourceProvider.b(3);
            }
            return list6;
        }
        String string3 = string2.substring(string.length() + 1);
        VirtualFile virtualFile4 = virtualFile3.findChild("ivydata-" + string3 + ".properties");
        if (virtualFile4 == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list7 = Collections.emptyList();
            if (list7 == null) {
                IvyAttachSourceProvider.b(4);
            }
            return list7;
        }
        final Library library = IvyAttachSourceProvider.getLibraryFromOrderEntriesList(list2);
        if (library == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list8 = Collections.emptyList();
            if (list8 == null) {
                IvyAttachSourceProvider.b(5);
            }
            return list8;
        }
        final String string4 = string + '-' + string3 + "-sources.jar";
        final VirtualFile virtualFile5 = virtualFile3.findChild("sources");
        if (virtualFile5 != null && (object = virtualFile5.findChild(string4)) != null) {
            VirtualFile virtualFile6 = JarFileSystem.getInstance().getJarRootForLocalFile(object);
            if (virtualFile6 == null || ArrayUtil.contains((Object)virtualFile6, (Object[])library.getFiles(OrderRootType.SOURCES))) {
                List<AttachSourcesProvider.AttachSourcesAction> list9 = Collections.emptyList();
                if (list9 == null) {
                    IvyAttachSourceProvider.b(6);
                }
                return list9;
            }
            Set<AttachSourcesProvider.AttachSourcesAction> set = Collections.singleton(new AbstractAttachSourceProvider.AttachExistingSourceAction(virtualFile6, library, "Attache sources from Ivy repository"));
            if (set == null) {
                IvyAttachSourceProvider.b(7);
            }
            return set;
        }
        object = IvyAttachSourceProvider.a(virtualFile4, string);
        if (StringUtil.isEmptyOrSpaces((String)object)) {
            List<AttachSourcesProvider.AttachSourcesAction> list10 = Collections.emptyList();
            if (list10 == null) {
                IvyAttachSourceProvider.b(8);
            }
            return list10;
        }
        Set<AttachSourcesProvider.AttachSourcesAction> set = Collections.singleton(new AbstractAttachSourceProvider.DownloadSourcesAction(psiFile.getProject(), "Downloading Ivy Sources", (String)object){

            @Override
            protected void storeFile(byte[] byArray) {
                try {
                    VirtualFile virtualFile = virtualFile5;
                    if (virtualFile == null) {
                        virtualFile = virtualFile3.createChildDirectory((Object)this, "sources");
                    }
                    VirtualFile virtualFile2 = virtualFile.createChildData((Object)this, string4);
                    virtualFile2.setBinaryContent(byArray);
                    IvyAttachSourceProvider.this.addSourceFile(JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile2), library);
                }
                catch (IOException iOException) {
                    String string = "Failed to save " + virtualFile3.getPath() + "/sources/" + string4;
                    new Notification(this.myMessageGroupId, "IO Error", string, NotificationType.ERROR).notify(this.myProject);
                    b.warn((Throwable)iOException);
                }
            }
        });
        if (set == null) {
            IvyAttachSourceProvider.b(9);
        }
        return set;
    }

    @Nullable
    private static String a(VirtualFile virtualFile, String string) {
        String string2 = "artifact:" + string + "#source#jar#";
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(VfsUtilCore.loadText((VirtualFile)virtualFile)));
            for (Object object : properties.keySet()) {
                String string3 = object.toString();
                if (string3 == null || !string3.startsWith(string2) || !string3.endsWith(".location")) continue;
                return properties.getProperty(string3);
            }
        }
        catch (Exception exception) {
            b.debug(virtualFile.getPath(), (Throwable)exception);
        }
        return null;
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/IvyAttachSourceProvider", "getActions"));
    }
}

