/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoriesConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel c;
    private JBList<String> b;
    private JButton m;
    private JButton o;
    private JButton j;
    private JButton a;
    private JBList<RemoteRepositoryDescription> n;
    private JButton h;
    private JButton d;
    private JButton f;
    private JButton l;
    private JButton e;
    private final Project k;
    private final CollectionListModel<String> g;
    private final CollectionListModel<RemoteRepositoryDescription> i;

    public RemoteRepositoriesConfigurable(Project project2) {
        Object[] objectArray = new String[]{};
        this.a();
        this.g = new CollectionListModel(objectArray);
        this.i = new CollectionListModel((Object[])new RemoteRepositoryDescription[0]);
        this.k = project2;
        this.b();
    }

    public boolean isModified() {
        return this.d() || this.c();
    }

    private boolean d() {
        return !this.g.getItems().equals(MavenRepositoryServicesManager.getInstance((Project)this.k).getUrls());
    }

    private boolean c() {
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)this.k).getRepositories();
        return !this.i.getItems().equals(list2);
    }

    private void b() {
        RemoteRepositoriesConfigurable.a(this.b, this.g, this.m, this.o, this.j, "Artifactory or Nexus Service URL", "Service URL", "No services", DataAdapter.STRING_ADAPTER);
        RemoteRepositoriesConfigurable.a(this.n, this.i, this.h, this.d, this.f, "Maven Repository URL", "maven Repository URL", "No remote repositories", DataAdapter.REPOSITORY_DESCRIPTION_ADAPTER);
        ListUtil.disableWhenNoSelection((JButton)this.a, this.b);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)RemoteRepositoriesConfigurable.this.b.getSelectedValue();
                if (!StringUtil.isEmpty((String)string)) {
                    RemoteRepositoriesConfigurable.this.a.setEnabled(false);
                    JarRepositoryManager.searchRepositories(RemoteRepositoriesConfigurable.this.k, Collections.singletonList(string), (Processor<Collection<RemoteRepositoryDescription>>)((Processor)collection -> {
                        RemoteRepositoriesConfigurable.this.a.setEnabled(true);
                        if (collection.isEmpty()) {
                            Messages.showMessageDialog((String)"No repositories found", (String)"Service Connection Failed", (Icon)Messages.getWarningIcon());
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(collection.size()).append(collection.size() == 1 ? "repository" : " repositories").append(" found");
                            Messages.showMessageDialog((String)stringBuilder.toString(), (String)"Service Connection Successful", (Icon)Messages.getInformationIcon());
                        }
                        return true;
                    }));
                }
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteRepositoriesConfigurable.this.b(RemoteRepositoryDescription.DEFAULT_REPOSITORIES);
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteRepositoriesConfigurable.this.a(MavenRepositoryServicesManager.DEFAULT_SERVICES);
            }
        });
    }

    private static <T> void a(final JBList<T> jBList, final CollectionListModel<T> collectionListModel, JButton jButton, JButton jButton2, JButton jButton3, final String string, final String string2, String string3, final DataAdapter<T, String> dataAdapter) {
        jBList.setModel(collectionListModel);
        jBList.setSelectionMode(0);
        jBList.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper<T>(){

            public void customize(JList jList, T t2, int n2, boolean bl2, boolean bl3) {
                this.setText((String)dataAdapter.toPresentation(t2));
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jBList.getSelectedValue();
                String string3 = Messages.showInputDialog((String)string, (String)("Add " + string2), (Icon)Messages.getQuestionIcon(), (String)(object == null ? "https://" : (String)dataAdapter.toPresentation(object)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)string3)) {
                    collectionListModel.add(dataAdapter.create(string3));
                    jBList.setSelectedValue((Object)string3, true);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = jBList.getSelectedIndex();
                Object object = collectionListModel.getElementAt(n2);
                String string3 = Messages.showInputDialog((String)string, (String)("Edit " + string2), (Icon)Messages.getQuestionIcon(), (String)((String)dataAdapter.toPresentation(object)), (InputValidator)new URLInputVaslidator());
                if (StringUtil.isNotEmpty((String)string3)) {
                    collectionListModel.setElementAt(dataAdapter.change(object, string3), n2);
                }
            }
        });
        ListUtil.addRemoveListener((JButton)jButton3, jBList);
        ListUtil.disableWhenNoSelection((JButton)jButton2, jBList);
        jBList.getEmptyText().setText(string3);
    }

    public String getDisplayName() {
        return "Remote Jar Repositories";
    }

    public String getHelpTopic() {
        return "reference.jar.repositories";
    }

    @NotNull
    public String getId() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            RemoteRepositoriesConfigurable.a(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.c;
    }

    public void apply() throws ConfigurationException {
        MavenRepositoryServicesManager.getInstance((Project)this.k).setUrls(this.g.getItems());
        RemoteRepositoriesConfiguration.getInstance((Project)this.k).setRepositories(this.i.getItems());
    }

    public void reset() {
        this.a(MavenRepositoryServicesManager.getInstance((Project)this.k).getUrls());
        this.b(RemoteRepositoriesConfiguration.getInstance((Project)this.k).getRepositories());
    }

    private void a(List<String> list2) {
        this.g.removeAll();
        this.g.add(list2);
    }

    private void b(List<RemoteRepositoryDescription> list2) {
        this.i.replaceAll(list2);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/settings/RemoteRepositoriesConfigurable", "getId"));
    }

    private /* synthetic */ void a() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JBList jBList;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JBList jBList2;
        JPanel jPanel;
        this.c = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Maven Jar Repositories", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.n = jBList2 = new JBList();
        jBScrollPane.setViewportView((Component)jBList2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.h = jButton9 = new JButton();
        jButton9.setFocusable(false);
        jButton9.setText("Add");
        jButton9.setMnemonic('D');
        jButton9.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jButton9, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.d = jButton8 = new JButton();
        jButton8.setText("Edit");
        jPanel3.add((Component)jButton8, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.f = jButton7 = new JButton();
        jButton7.setText("Remove");
        jPanel3.add((Component)jButton7, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.l = jButton6 = new JButton();
        jButton6.setText("Reset Defaults");
        jPanel3.add((Component)jButton6, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Artifactory or Nexus Service URLs:", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 0, null, new Dimension(406, 128), null));
        this.b = jBList = new JBList();
        jBList.setLayoutOrientation(0);
        jBScrollPane2.setViewportView((Component)jBList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.m = jButton5 = new JButton();
        jButton5.setFocusable(false);
        jButton5.setText("Add");
        jButton5.setMnemonic('A');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.j = jButton4 = new JButton();
        jButton4.setText("Remove");
        jButton4.setMnemonic('R');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.a = jButton3 = new JButton();
        jButton3.setText("Test");
        jButton3.setMnemonic('T');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton3, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.o = jButton2 = new JButton();
        jButton2.setText("Edit");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.e = jButton = new JButton();
        jButton.setText("Reset Defaults");
        jPanel5.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.c;
    }

    private static final class URLInputVaslidator
    implements InputValidator {
        private URLInputVaslidator() {
        }

        public boolean checkInput(String string) {
            try {
                return StringUtil.isNotEmpty((String)new URL(string).getHost());
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        public boolean canClose(String string) {
            return this.checkInput(string);
        }
    }

    private static interface DataAdapter<Data, Presentation> {
        public static final DataAdapter<String, String> STRING_ADAPTER = new DataAdapter<String, String>(){

            @Override
            public String toPresentation(String string) {
                return string;
            }

            @Override
            public String create(String string) {
                return string;
            }

            @Override
            public String change(String string, String string2) {
                return string2;
            }
        };
        public static final DataAdapter<RemoteRepositoryDescription, String> REPOSITORY_DESCRIPTION_ADAPTER = new DataAdapter<RemoteRepositoryDescription, String>(){

            @Override
            public String toPresentation(RemoteRepositoryDescription remoteRepositoryDescription) {
                return remoteRepositoryDescription.getUrl();
            }

            @Override
            public RemoteRepositoryDescription create(String string) {
                UUID uUID = UUID.randomUUID();
                return new RemoteRepositoryDescription(uUID.toString(), uUID.toString(), string);
            }

            @Override
            public RemoteRepositoryDescription change(RemoteRepositoryDescription remoteRepositoryDescription, String string) {
                return new RemoteRepositoryDescription(remoteRepositoryDescription.getId(), remoteRepositoryDescription.getName(), string);
            }
        };

        public Presentation toPresentation(Data var1);

        public Data create(Presentation var1);

        public Data change(Data var1, Presentation var2);
    }
}

