/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.google.common.base.Strings;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryPropertiesEditor {
    @NotNull
    private final Project n;
    State currentState;
    List<String> versions;
    @Nullable
    private VersionKind c;
    private final RepositoryLibraryPropertiesModel b;
    private final RepositoryLibraryPropertiesModel d;
    private final RepositoryLibraryDescription i;
    private ComboBox l;
    private ComboBox o;
    private JPanel j;
    private JButton m;
    private JBCheckBox g;
    private JBCheckBox a;
    private JBLabel h;
    private JBCheckBox f;
    private JPanel k;
    @NotNull
    private final ModelChangeListener e;

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, RepositoryLibraryPropertiesModel repositoryLibraryPropertiesModel, RepositoryLibraryDescription repositoryLibraryDescription) {
        this(project2, repositoryLibraryPropertiesModel, repositoryLibraryDescription, true, new ModelChangeListener(){

            @Override
            public void onChange(RepositoryLibraryPropertiesEditor repositoryLibraryPropertiesEditor) {
            }
        });
    }

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, final RepositoryLibraryPropertiesModel repositoryLibraryPropertiesModel, RepositoryLibraryDescription repositoryLibraryDescription, boolean bl2, final @NotNull ModelChangeListener modelChangeListener) {
        if (modelChangeListener == null) {
            RepositoryLibraryPropertiesEditor.a(0);
        }
        this.g();
        this.b = repositoryLibraryPropertiesModel.clone();
        this.d = repositoryLibraryPropertiesModel;
        this.n = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
        this.i = repositoryLibraryDescription;
        this.h.setCopyable(true);
        this.f.setVisible(bl2);
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryLibraryPropertiesEditor.this.c();
            }
        });
        this.e = new ModelChangeListener(){

            @Override
            public void onChange(RepositoryLibraryPropertiesEditor repositoryLibraryPropertiesEditor) {
                modelChangeListener.onChange(repositoryLibraryPropertiesEditor);
                RepositoryLibraryPropertiesEditor.this.h.setText(RepositoryLibraryPropertiesEditor.this.i.getMavenCoordinates(repositoryLibraryPropertiesModel.getVersion()));
            }
        };
        this.c();
    }

    private static VersionKind b(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return VersionKind.Unselected;
        }
        if (string.equals("RELEASE")) {
            return VersionKind.Release;
        }
        if (string.equals("LATEST")) {
            return VersionKind.Latest;
        }
        return VersionKind.Select;
    }

    private static int a(String string2, List<String> list2) {
        VersionKind versionKind = RepositoryLibraryPropertiesEditor.b(string2);
        int n2 = JBIterable.from(list2).takeWhile(string -> string.endsWith("-SNAPSHOT")).size();
        switch (versionKind) {
            case Unselected: {
                return -1;
            }
            case Release: {
                return n2 == list2.size() ? -1 : n2;
            }
            case Latest: {
                return 0;
            }
            case Select: {
                if (list2.indexOf(string2) == -1) {
                    list2.add(0, string2);
                }
                return list2.indexOf(string2);
            }
        }
        return -1;
    }

    private void e() {
        List<String> list2 = Arrays.asList("Release", "Latest", "Select...");
        CollectionComboBoxModel collectionComboBoxModel = new CollectionComboBoxModel(list2);
        this.l.setModel((ComboBoxModel)collectionComboBoxModel);
        this.l.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                VersionKind versionKind = RepositoryLibraryPropertiesEditor.this.d();
                if (versionKind != RepositoryLibraryPropertiesEditor.this.c) {
                    RepositoryLibraryPropertiesEditor.this.c = versionKind;
                    RepositoryLibraryPropertiesEditor.this.f();
                }
            }
        });
        this.a(RepositoryLibraryPropertiesEditor.b(this.d.getVersion()));
    }

    private void f() {
        this.o.setEnabled(this.c == VersionKind.Select);
        this.d.setVersion(this.getSelectedVersion());
        int n2 = RepositoryLibraryPropertiesEditor.a(this.d.getVersion(), this.versions);
        this.o.setSelectedIndex(n2);
        this.e.onChange(this);
    }

    private VersionKind d() {
        switch (this.l.getSelectedIndex()) {
            case 0: {
                return VersionKind.Release;
            }
            case 1: {
                return VersionKind.Latest;
            }
            case 2: {
                return VersionKind.Select;
            }
        }
        return VersionKind.Unselected;
    }

    private void a(VersionKind versionKind) {
        this.o.setEnabled(versionKind == VersionKind.Select);
        switch (versionKind) {
            case Unselected: {
                this.l.setSelectedIndex(-1);
                break;
            }
            case Release: {
                this.l.setSelectedItem((Object)0);
                break;
            }
            case Latest: {
                this.l.setSelectedIndex(1);
                break;
            }
            case Select: {
                this.l.setSelectedIndex(2);
            }
        }
    }

    private void a(State state) {
        this.currentState = state;
        ((CardLayout)this.k.getLayout()).show(this.k, state.name());
        this.e.onChange(this);
    }

    private void c() {
        this.a(State.Loading);
        JarRepositoryManager.getAvailableVersionsAsync(this.n, this.i, collection -> this.a(new ArrayList<String>((Collection<String>)collection)));
    }

    private void h() {
        int n2 = RepositoryLibraryPropertiesEditor.a(this.d.getVersion(), this.versions);
        CollectionComboBoxModel collectionComboBoxModel = new CollectionComboBoxModel(this.versions);
        this.o.setModel((ComboBoxModel)collectionComboBoxModel);
        this.o.setSelectedIndex(n2);
        this.a(State.Loaded);
        this.e();
        this.o.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RepositoryLibraryPropertiesEditor.this.d.setVersion(RepositoryLibraryPropertiesEditor.this.getSelectedVersion());
                RepositoryLibraryPropertiesEditor.this.e.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.g.setSelected(this.d.isDownloadSources());
        this.g.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RepositoryLibraryPropertiesEditor.this.d.setDownloadSources(RepositoryLibraryPropertiesEditor.this.g.isSelected());
                RepositoryLibraryPropertiesEditor.this.e.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.a.setSelected(this.d.isDownloadJavaDocs());
        this.a.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RepositoryLibraryPropertiesEditor.this.d.setDownloadJavaDocs(RepositoryLibraryPropertiesEditor.this.a.isSelected());
                RepositoryLibraryPropertiesEditor.this.e.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.f.setSelected(this.d.isIncludeTransitiveDependencies());
        this.f.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RepositoryLibraryPropertiesEditor.this.d.setIncludeTransitiveDependencies(RepositoryLibraryPropertiesEditor.this.f.isSelected());
                RepositoryLibraryPropertiesEditor.this.e.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
    }

    private void a(@Nullable List<String> list2) {
        this.versions = list2;
        if (list2 == null || list2.isEmpty()) {
            this.b();
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::h, ModalityState.any());
    }

    private void b() {
        ApplicationManager.getApplication().invokeLater(() -> this.a(State.FailedToLoad), ModalityState.any());
    }

    @Nullable
    public String getSelectedVersion() {
        if (this.c == null) {
            return null;
        }
        switch (this.c) {
            case Unselected: {
                return null;
            }
            case Release: {
                return "RELEASE";
            }
            case Latest: {
                return "LATEST";
            }
            case Select: {
                return (String)this.o.getSelectedItem();
            }
        }
        return null;
    }

    public JPanel getMainPanel() {
        return this.j;
    }

    public boolean isValid() {
        return this.currentState == State.Loaded;
    }

    public boolean hasChanges() {
        return !this.d.equals(this.b);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChangeListener", "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor", "<init>"));
    }

    private /* synthetic */ void g() {
        JButton jButton;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.j = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setMinimumSize(new Dimension(400, 128));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Maven:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.h = jBLabel = new JBLabel();
        jBLabel.setOpaque(false);
        jBLabel.setRequestFocusEnabled(true);
        jBLabel.setText("");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.k = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "Loaded");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Version:");
        jBLabel3.setDisplayedMnemonic('V');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.o = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        this.l = comboBox = new ComboBox();
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.g = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setLabel("Download Sources");
        jBCheckBox3.setText("Download Sources");
        jBCheckBox3.setMnemonic('S');
        jBCheckBox3.setDisplayedMnemonicIndex(9);
        jPanel6.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.a = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setLabel("Download JavaDocs");
        jBCheckBox2.setText("Download JavaDocs");
        jBCheckBox2.setMnemonic('J');
        jBCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.f = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Include transitive dependencies");
        jBCheckBox.setMnemonic('T');
        jBCheckBox.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "Loading");
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setInheritsPopupMenu(true);
        jBLabel4.setText("Loading available versions...");
        jBLabel4.setDisplayedMnemonic('L');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel7.add((Component)spacer7, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, "FailedToLoad");
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Failed to load versions");
        jPanel8.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel8.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.m = jButton = new JButton();
        jButton.setText("Reload");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel8.add((Component)spacer9, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel3.setLabelFor((Component)comboBox);
        jBLabel4.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.j;
    }

    private static enum State {
        Loading,
        FailedToLoad,
        Loaded;

    }

    private static enum VersionKind {
        Unselected,
        Release,
        Latest,
        Select;

    }

    public static interface ModelChangeListener {
        public void onChange(RepositoryLibraryPropertiesEditor var1);
    }
}

