/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class PathManagerEx {
    private static final ConcurrentMap<Class, TestDataLookupStrategy> d = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, Class> b = ContainerUtil.newConcurrentMap();
    private static Set<String> a;
    private static final Map<TestDataLookupStrategy, List<String>> c;

    private PathManagerEx() {
    }

    @NonNls
    public static String getTestDataPath() throws IllegalStateException {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.guessTestDataLookupStrategy();
        return PathManagerEx.getTestDataPath(testDataLookupStrategy);
    }

    public static String getTestDataPath(String string) throws IllegalStateException {
        return PathManagerEx.getTestDataPath() + string.replace('/', File.separatorChar);
    }

    public static String getTestDataPath(Class<?> clazz) throws IllegalStateException {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.c() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.a(clazz);
        return PathManagerEx.getTestDataPath(testDataLookupStrategy);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String string = PathManager.getHomePath();
        String string2 = PathManagerEx.c() ? string : string + File.separator + "community";
        if (string2 == null) {
            PathManagerEx.a(0);
        }
        return string2;
    }

    public static String getHomePath(Class<?> clazz) {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.c() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.a(clazz);
        return testDataLookupStrategy == TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE ? PathManagerEx.getCommunityHomePath() : PathManager.getHomePath();
    }

    public static File findFileUnderCommunityHome(String string) {
        File file = new File(PathManagerEx.getCommunityHomePath(), FileUtil.toSystemDependentName((String)string));
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find file '" + string + "' under '" + PathManagerEx.getCommunityHomePath() + "' directory");
        }
        return file;
    }

    public static File findFileUnderProjectHome(String string, Class<? extends TestCase> clazz) {
        String string2 = PathManagerEx.getHomePath(clazz);
        File file = new File(string2, FileUtil.toSystemDependentName((String)string));
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find file '" + string + "' under '" + string2 + "' directory");
        }
        return file;
    }

    private static boolean c() {
        FileSystemLocation fileSystemLocation = PathManagerEx.b();
        return fileSystemLocation == FileSystemLocation.COMMUNITY;
    }

    @NonNls
    public static String getTestDataPath(TestDataLookupStrategy testDataLookupStrategy) throws IllegalStateException {
        String string = PathManager.getHomePath();
        List<String> list2 = c.get((Object)testDataLookupStrategy);
        if (list2.isEmpty()) {
            throw new IllegalStateException(String.format("Can't determine test data path. Reason: no predefined relative paths are configured for test data lookup strategy %s. Configured mappings: %s", new Object[]{testDataLookupStrategy, c}));
        }
        File file = null;
        for (String string2 : list2) {
            file = new File(string, string2);
            if (!file.isDirectory()) continue;
            return file.getPath();
        }
        if (file == null) {
            throw new IllegalStateException("Can't determine test data path. Looks like programming error - reached 'if' block that was never expected to be executed");
        }
        return file.getPath();
    }

    public static TestDataLookupStrategy guessTestDataLookupStrategy() {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.d();
        if (testDataLookupStrategy == null) {
            testDataLookupStrategy = PathManagerEx.a();
        }
        return testDataLookupStrategy;
    }

    @Nullable
    private static TestDataLookupStrategy d() {
        StackTraceElement[] stackTraceElementArray;
        if (PathManagerEx.c()) {
            return TestDataLookupStrategy.COMMUNITY;
        }
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Exception().getStackTrace()) {
            String string = stackTraceElement.getClassName();
            Class<?> clazz3 = PathManagerEx.a(string);
            if (clazz3 == null || TestCase.class == clazz3 || !PathManagerEx.c(clazz3)) continue;
            if (PathManagerEx.a(clazz3) == TestDataLookupStrategy.ULTIMATE) {
                return TestDataLookupStrategy.ULTIMATE;
            }
            if ((clazz3.getModifiers() & 0x400) == 0) {
                clazz = clazz3;
                continue;
            }
            clazz2 = clazz3;
        }
        StackTraceElement[] stackTraceElementArray2 = clazz == null ? clazz2 : clazz;
        return stackTraceElementArray2 == null ? null : PathManagerEx.a(stackTraceElementArray2);
    }

    @Nullable
    private static Class<?> a(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = (Class<?>)b.get(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = PathManagerEx.class.getClassLoader();
        ClassLoader classLoader3 = ClassLoader.getSystemClassLoader();
        for (ClassLoader classLoader4 : Arrays.asList(classLoader, classLoader2, classLoader3)) {
            clazz = PathManagerEx.a(string, classLoader4);
            if (clazz == null) continue;
            b.put(string, clazz);
            return clazz;
        }
        b.put(string, TestCase.class);
        return null;
    }

    @Nullable
    private static Class<?> a(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    private static boolean c(Class<?> clazz) {
        return TestCase.class.isAssignableFrom(clazz) || TestFrameworkUtil.isJUnit4TestClass(clazz) || Parameterized.class.isAssignableFrom(clazz);
    }

    @Nullable
    private static TestDataLookupStrategy a(Class<?> clazz) {
        TestDataLookupStrategy testDataLookupStrategy = (TestDataLookupStrategy)((Object)d.get(clazz));
        if (testDataLookupStrategy != null) {
            return testDataLookupStrategy;
        }
        FileSystemLocation fileSystemLocation = PathManagerEx.b(clazz);
        testDataLookupStrategy = fileSystemLocation == FileSystemLocation.COMMUNITY ? TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE : TestDataLookupStrategy.ULTIMATE;
        d.put(clazz, testDataLookupStrategy);
        return testDataLookupStrategy;
    }

    public static void replaceLookupStrategy(Class<?> clazz, Class<?> ... classArray) {
        d.clear();
        for (Class<?> clazz2 : classArray) {
            d.put(clazz2, PathManagerEx.a(clazz));
        }
    }

    private static FileSystemLocation b(Class<?> clazz) {
        String string;
        String string2 = PathManager.getJarPathForClass(clazz);
        if (string2 == null) {
            throw new IllegalStateException("Cannot find root directory for " + clazz);
        }
        File file = new File(string2);
        if (!file.exists()) {
            throw new IllegalStateException("Classes root " + file + " doesn't exist");
        }
        if (!file.isDirectory()) {
            return FileSystemLocation.ULTIMATE;
        }
        String string3 = file.getName();
        if (string3.startsWith(string = "ModuleChunk(")) {
            string3 = StringUtil.trimStart((String)string3, (String)string);
            string3 = string3.substring(0, string3.indexOf(44));
        }
        return PathManagerEx.e().contains(string3) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
    }

    private static synchronized Set<String> e() {
        if (a != null) {
            return a;
        }
        a = new THashSet();
        File file = PathManagerEx.findFileUnderCommunityHome(".idea/modules.xml");
        if (!file.exists()) {
            throw new IllegalStateException("Cannot obtain test data path: " + file.getAbsolutePath() + " not found");
        }
        try {
            Element element = JDomSerializationUtil.findComponent((Element)JDOMUtil.load((File)file), (String)"ProjectModuleManager");
            assert (element != null);
            for (ModulePath modulePath : ModuleManagerImpl.getPathsToModuleFiles((Element)element)) {
                a.add(modulePath.getModuleName());
            }
            return a;
        }
        catch (IOException | JDOMException throwable) {
            throw new RuntimeException("Cannot read modules from " + file.getAbsolutePath(), throwable);
        }
    }

    private static FileSystemLocation b() {
        return new File(PathManager.getHomePath(), "community/.idea").isDirectory() ? FileSystemLocation.ULTIMATE : FileSystemLocation.COMMUNITY;
    }

    private static TestDataLookupStrategy a() {
        String string = PathManager.getHomePath();
        for (Map.Entry<TestDataLookupStrategy, List<String>> entry : c.entrySet()) {
            for (String string2 : entry.getValue()) {
                if (!new File(string, string2).isDirectory()) continue;
                return entry.getKey();
            }
        }
        return TestDataLookupStrategy.ULTIMATE;
    }

    static {
        c = new EnumMap<TestDataLookupStrategy, List<String>>(TestDataLookupStrategy.class);
        c.put(TestDataLookupStrategy.ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"testData")));
        c.put(TestDataLookupStrategy.COMMUNITY, Collections.singletonList(FileUtil.toSystemDependentName((String)"java/java-tests/testData")));
        c.put(TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"community/java/java-tests/testData")));
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ex/PathManagerEx", "getCommunityHomePath"));
    }

    public static enum TestDataLookupStrategy {
        ULTIMATE,
        COMMUNITY,
        COMMUNITY_FROM_ULTIMATE;

    }

    private static enum FileSystemLocation {
        ULTIMATE,
        COMMUNITY;

    }
}

