/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ShowExternalSystemSettingsAction
extends ExternalSystemAction {
    public ShowExternalSystemSettingsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.open.settings.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.open.settings.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        if (!super.isEnabled(anActionEvent)) {
            return false;
        }
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        if (projectSystemId == null) {
            return false;
        }
        anActionEvent.getPresentation().setText(ExternalSystemBundle.message((String)"action.open.settings.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        anActionEvent.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.open.settings.description", (Object[])new Object[]{projectSystemId.getReadableName()}));
        return true;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        ProjectSystemId projectSystemId = this.getSystemId(anActionEvent);
        if (projectSystemId != null) {
            ShowExternalSystemSettingsAction.showSettingsFor(this.getProject(anActionEvent), projectSystemId);
        }
    }

    protected static void showSettingsFor(Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ShowExternalSystemSettingsAction.b(0);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project2, projectSystemId.getReadableName());
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/action/ShowExternalSystemSettingsAction", "showSettingsFor"));
    }
}

