/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.TaskCompletionProvider;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskSettingsControl
implements ExternalSystemSettingsControl<ExternalSystemTaskExecutionSettings> {
    @NotNull
    private final ProjectSystemId a;
    @NotNull
    private final Project b;
    private JBLabel e;
    private ExternalProjectPathField c;
    private JBLabel g;
    private EditorTextField i;
    private JBLabel l;
    private RawCommandLineEditor f;
    private JBLabel h;
    private RawCommandLineEditor k;
    private EnvironmentVariablesComponent d;
    @Nullable
    private ExternalSystemTaskExecutionSettings j;

    public ExternalSystemTaskSettingsControl(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalSystemTaskSettingsControl.a(0);
        }
        if (projectSystemId == null) {
            ExternalSystemTaskSettingsControl.a(1);
        }
        this.b = project2;
        this.a = projectSystemId;
    }

    public void setOriginalSettings(@Nullable ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) {
        this.j = externalSystemTaskExecutionSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel paintAwarePanel, int n2) {
        if (paintAwarePanel == null) {
            ExternalSystemTaskSettingsControl.a(2);
        }
        this.e = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.project", (Object[])new Object[]{this.a.getReadableName()}));
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.a);
        FileChooserDescriptor fileChooserDescriptor = null;
        if (externalSystemManager instanceof ExternalSystemUiAware) {
            fileChooserDescriptor = ((ExternalSystemUiAware)externalSystemManager).getExternalProjectConfigDescriptor();
        }
        if (fileChooserDescriptor == null) {
            fileChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        }
        String string = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.a.getReadableName()});
        this.c = new ExternalProjectPathField(this.b, this.a, fileChooserDescriptor, string){

            public Dimension getPreferredSize() {
                return ExternalSystemTaskSettingsControl.this.f == null ? super.getPreferredSize() : ExternalSystemTaskSettingsControl.this.f.getTextField().getPreferredSize();
            }
        };
        paintAwarePanel.add((Component)this.e, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)((Object)this.c), ExternalSystemUiUtil.getFillLineConstraints(0));
        this.g = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.tasks", (Object[])new Object[0]));
        this.i = new EditorTextField("", this.b, (FileType)PlainTextFileType.INSTANCE);
        paintAwarePanel.add((Component)this.g, ExternalSystemUiUtil.getLabelConstraints(0));
        GridBag gridBag = ExternalSystemUiUtil.getFillLineConstraints(0);
        gridBag.insets.right = this.c.getButton().getPreferredSize().width + 8;
        paintAwarePanel.add((Component)this.i, gridBag);
        new TaskCompletionProvider(this.b, this.a, this.c).apply(this.i);
        this.l = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        this.f = new RawCommandLineEditor();
        this.f.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        paintAwarePanel.add((Component)this.l, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.f, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.h = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        this.k = new RawCommandLineEditor();
        this.k.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        paintAwarePanel.add((Component)this.h, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.k, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.d = new EnvironmentVariablesComponent();
        JBLabel jBLabel = this.d.getLabel();
        jBLabel.remove((Component)jBLabel);
        paintAwarePanel.add((Component)jBLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        paintAwarePanel.add((Component)this.d, ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @Override
    public void reset() {
        this.c.setText("");
        this.i.setText("");
        this.f.setText("");
        this.k.setText("");
        this.d.setEnvData(EnvironmentVariablesData.DEFAULT);
        this.showUi(true);
        if (this.j == null) {
            return;
        }
        String string = this.j.getExternalProjectPath();
        if (StringUtil.isEmpty((String)string)) {
            string = "";
        }
        this.c.setText(string);
        this.i.setText(StringUtil.join((Collection)this.j.getTaskNames(), (String)" "));
        this.f.setText(this.j.getVmOptions());
        this.k.setText(this.j.getScriptParameters());
        this.d.setEnvData(EnvironmentVariablesData.create((Map)this.j.getEnv(), (boolean)this.j.isPassParentEnvs()));
    }

    @Override
    public boolean isModified() {
        if (this.j == null) {
            return false;
        }
        return !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.c.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.j.getExternalProjectPath())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.i.getText()), (String)ExternalSystemApiUtil.normalizePath((String)StringUtil.join((Collection)this.j.getTaskNames(), (String)" "))) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.f.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.j.getVmOptions())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.k.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.j.getScriptParameters())) || this.d.isPassParentEnvs() != this.j.isPassParentEnvs() || !this.d.getEnvs().equals(this.j.getEnv());
    }

    @Override
    public void apply(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemTaskSettingsControl.a(3);
        }
        String string = this.c.getText();
        externalSystemTaskExecutionSettings.setExternalProjectPath(string);
        externalSystemTaskExecutionSettings.setTaskNames(StringUtil.split((String)this.i.getText(), (String)" "));
        externalSystemTaskExecutionSettings.setVmOptions(this.f.getText());
        externalSystemTaskExecutionSettings.setScriptParameters(this.k.getText());
        externalSystemTaskExecutionSettings.setPassParentEnvs(this.d.isPassParentEnvs());
        externalSystemTaskExecutionSettings.setEnv((Map)ContainerUtil.newHashMap((Map)this.d.getEnvs()));
    }

    @Override
    public boolean validate(@NotNull ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings) throws ConfigurationException {
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemTaskSettingsControl.a(4);
        }
        String string = this.c.getText();
        if (this.j == null) {
            throw new ConfigurationException(String.format("Can't store external task settings into run configuration. Reason: target run configuration is undefined. Tasks: '%s', external project: '%s', vm options: '%s', arguments: '%s'", this.i.getText(), string, this.f.getText(), this.k.getText()));
        }
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean bl2) {
        ExternalSystemUiUtil.showUi(this, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

