/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    private static final Key<Set<Path>> d = Key.create((String)"ORPHAN_FILES");
    private static final Key<AtomicInteger> c = Key.create((String)"ORPHAN_MODULE_HANDLERS_COUNTER");
    private static final NotificationGroup b = NotificationGroup.toolWindowGroup((String)"Build sync orphan modules", (String)ToolWindowId.BUILD);
    private static final Logger a = Logger.getInstance(AbstractModuleDataService.class);

    public void importData(@NotNull Collection<DataNode<E>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        String string;
        String[] stringArray;
        Module module2;
        if (collection == null) {
            AbstractModuleDataService.a(0);
        }
        if (project2 == null) {
            AbstractModuleDataService.a(1);
        }
        if (ideModifiableModelsProvider == null) {
            AbstractModuleDataService.a(2);
        }
        if (collection.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> collection2 = this.a(collection, ideModifiableModelsProvider);
        if (!collection2.isEmpty()) {
            this.b(collection2, ideModifiableModelsProvider);
        }
        for (DataNode<E> dataNode : collection) {
            module2 = (Module)dataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            stringArray = ((ModuleData)dataNode.getData()).getPublication();
            if (stringArray != null) {
                ideModifiableModelsProvider.registerModulePublication(module2, (ProjectCoordinate)stringArray);
            }
            string = ((ModuleData)dataNode.getData()).getProductionModuleId();
            ideModifiableModelsProvider.setTestModuleProperties(module2, string);
            this.setModuleOptions(module2, dataNode);
            ModifiableRootModel modifiableRootModel = ideModifiableModelsProvider.getModifiableRootModel(module2);
            AbstractModuleDataService.a(module2, modifiableRootModel, (ModuleData)dataNode.getData());
            this.b(modifiableRootModel, (ModuleData)dataNode.getData());
            this.a(modifiableRootModel, (ModuleData)dataNode.getData());
        }
        for (DataNode<E> dataNode : collection) {
            module2 = (Module)dataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            stringArray = ((ModuleData)dataNode.getData()).getIdeModuleGroup();
            string = ideModifiableModelsProvider.getModifiableModuleModel();
            string.setModuleGroupPath(module2, stringArray);
        }
    }

    private void b(@NotNull Collection<DataNode<E>> collection, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            AbstractModuleDataService.a(3);
        }
        if (ideModifiableModelsProvider == null) {
            AbstractModuleDataService.a(4);
        }
        for (DataNode<E> dataNode : collection) {
            ModuleData moduleData = (ModuleData)dataNode.getData();
            Module module2 = ideModifiableModelsProvider.newModule(moduleData);
            dataNode.putUserData(MODULE_KEY, (Object)module2);
            final ModifiableRootModel modifiableRootModel = ideModifiableModelsProvider.getModifiableRootModel(module2);
            modifiableRootModel.inheritSdk();
            RootPolicy<Object> rootPolicy = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Object object) {
                    if (libraryOrderEntry == null) {
                        1.a(0);
                    }
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return object;
                }

                public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Object object) {
                    if (moduleOrderEntry == null) {
                        1.a(1);
                    }
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return object;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "libraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "moduleOrderEntry";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLibraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitModuleOrderEntry";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)rootPolicy, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> a(@NotNull Collection<DataNode<E>> collection, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            AbstractModuleDataService.a(5);
        }
        if (ideModifiableModelsProvider == null) {
            AbstractModuleDataService.a(6);
        }
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        for (DataNode<E> dataNode : collection) {
            ModuleData moduleData = (ModuleData)dataNode.getData();
            Module module2 = ideModifiableModelsProvider.findIdeModule(moduleData);
            if (module2 == null) {
                UnloadedModuleDescription unloadedModuleDescription = ideModifiableModelsProvider.getUnloadedModuleDescription(moduleData);
                if (unloadedModuleDescription != null) continue;
                arrayList.add(dataNode);
                continue;
            }
            dataNode.putUserData(MODULE_KEY, (Object)module2);
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            AbstractModuleDataService.a(7);
        }
        return arrayList2;
    }

    private static void a(@NotNull Module module2, @NotNull ModifiableRootModel modifiableRootModel, @NotNull ModuleData moduleData) {
        CompilerModuleExtension compilerModuleExtension;
        if (module2 == null) {
            AbstractModuleDataService.a(8);
        }
        if (modifiableRootModel == null) {
            AbstractModuleDataService.a(9);
        }
        if (moduleData == null) {
            AbstractModuleDataService.a(10);
        }
        if ((compilerModuleExtension = (CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class)) == null) {
            a.warn(String.format("Can't sync paths for module '%s'. Reason: no compiler extension is found for it", module2.getName()));
            return;
        }
        String string = moduleData.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        compilerModuleExtension.setCompilerOutputPath(string != null ? VfsUtilCore.pathToUrl((String)string) : null);
        String string2 = moduleData.getCompileOutputPath(ExternalSystemSourceType.TEST);
        compilerModuleExtension.setCompilerOutputPathForTests(string2 != null ? VfsUtilCore.pathToUrl((String)string2) : null);
        compilerModuleExtension.inheritCompilerOutputPath(moduleData.isInheritProjectCompileOutputPath());
    }

    public void removeData(@NotNull Computable<Collection<Module>> computable, @NotNull Collection<DataNode<E>> collection, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (computable == null) {
            AbstractModuleDataService.a(11);
        }
        if (collection == null) {
            AbstractModuleDataService.a(12);
        }
        if (projectData == null) {
            AbstractModuleDataService.a(13);
        }
        if (project2 == null) {
            AbstractModuleDataService.a(14);
        }
        if (ideModifiableModelsProvider == null) {
            AbstractModuleDataService.a(15);
        }
        Collection collection2 = (Collection)computable.compute();
        SmartList smartList = new SmartList(collection2);
        for (DataNode<E> module2 : collection) {
            Module module3 = ideModifiableModelsProvider.findIdeModule((ModuleData)module2.getData());
            ContainerUtil.addIfNotNull((Collection)smartList, (Object)module3);
        }
        if (smartList.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)smartList);
        for (Module module4 : smartList) {
            if (module4.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module4);
        }
        ExternalSystemApiUtil.executeOnEdt((boolean)true, () -> AbstractModuleDataService.a(project2, projectData, (List)smartList, ideModifiableModelsProvider));
    }

    public void onSuccessImport(@NotNull Collection<DataNode<E>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModelsProvider ideModelsProvider) {
        Set set;
        if (collection == null) {
            AbstractModuleDataService.a(16);
        }
        if (project2 == null) {
            AbstractModuleDataService.a(17);
        }
        if (ideModelsProvider == null) {
            AbstractModuleDataService.a(18);
        }
        if ((set = (Set)project2.getUserData(d)) == null || set.isEmpty()) {
            return;
        }
        AtomicInteger atomicInteger = (AtomicInteger)project2.getUserData(c);
        if (atomicInteger == null) {
            return;
        }
        if (atomicInteger.decrementAndGet() == 0) {
            String string;
            Object object2;
            project2.putUserData(d, null);
            project2.putUserData(c, null);
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList arrayList = ContainerUtil.newArrayList();
            for (Object object2 : set) {
                try {
                    string = FileUtil.loadFile((File)object2.resolveSibling(object2.getFileName() + ".path").toFile());
                    stringBuilder.append(FileUtil.getNameWithoutExtension((File)new File(string))).append("\n");
                    arrayList.add(Pair.create((Object)string, (Object)object2));
                }
                catch (IOException iOException) {
                    a.warn((Throwable)iOException);
                }
            }
            String string2 = projectData != null ? projectData.getOwner().getReadableName() : "build system";
            object2 = ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{string2, StringUtil.shortenTextWithEllipsis((String)stringBuilder.toString(), (int)100, (int)0)});
            string = b.createNotification((String)object2, NotificationType.INFORMATION).setListener((notification, hyperlinkEvent) -> {
                if (project2 == null) {
                    AbstractModuleDataService.a(35);
                }
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (AbstractModuleDataService.a((List<Pair<String, Path>>)arrayList, project2, string2)) {
                    notification.expire();
                }
            }).whenExpired(() -> {
                List list2 = set.stream().map(Path::toFile).collect(Collectors.toList());
                list2.addAll(set.stream().map(path -> path.resolveSibling(path.getFileName() + ".path").toFile()).collect(Collectors.toList()));
                FileUtil.asyncDelete(list2);
            });
            Disposer.register((Disposable)project2, () -> ((Notification)string).expire());
            string.notify(project2);
        }
    }

    public void onFailureImport(Project project2) {
        project2.putUserData(d, null);
        project2.putUserData(c, null);
    }

    private static boolean a(@NotNull List<Pair<String, Path>> list2, @NotNull Project project2, @NotNull String string) {
        CheckBoxList checkBoxList;
        DialogWrapper dialogWrapper;
        if (list2 == null) {
            AbstractModuleDataService.a(19);
        }
        if (project2 == null) {
            AbstractModuleDataService.a(20);
        }
        if (string == null) {
            AbstractModuleDataService.a(21);
        }
        if ((dialogWrapper = new DialogWrapper(project2, checkBoxList = new CheckBoxList(), list2, string){
            final /* synthetic */ CheckBoxList val$orphanModulesList;
            final /* synthetic */ List val$orphanModules;
            final /* synthetic */ String val$buildSystem;
            {
                this.val$orphanModulesList = checkBoxList;
                this.val$orphanModules = list2;
                this.val$buildSystem = string;
                super(project2);
                this.setTitle(ExternalSystemBundle.message((String)"orphan.modules.dialog.title", (Object[])new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                this.val$orphanModulesList.setSelectionMode(2);
                this.val$orphanModulesList.setItems(this.val$orphanModules, pair2 -> FileUtil.getNameWithoutExtension((File)new File((String)pair2.getFirst())));
                this.val$orphanModulesList.setBorder(JBUI.Borders.empty((int)5));
                JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.val$orphanModulesList, (int)20, (int)30);
                jScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
                jScrollPane.setMaximumSize(new Dimension(-1, 300));
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jScrollPane, "Center");
                return jPanel;
            }

            @NotNull
            protected JComponent createNorthPanel() {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                JPanel jPanel = new JPanel(new GridBagLayout());
                gridBagConstraints.insets = JBUI.insets((int)4, (int)0, (int)10, (int)8);
                jPanel.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.dialog.text", (Object[])new Object[]{this.val$buildSystem})), gridBagConstraints);
                JPanel jPanel2 = jPanel;
                if (jPanel2 == null) {
                    2.a(0);
                }
                return jPanel2;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$2", "createNorthPanel"));
            }
        }).showAndGet()) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                if (list2 == null) {
                    AbstractModuleDataService.a(33);
                }
                if (project2 == null) {
                    AbstractModuleDataService.a(34);
                }
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    Pair pair2 = (Pair)list2.get(i2);
                    String string = (String)pair2.first;
                    Path path = (Path)pair2.second;
                    if (!checkBoxList.isItemSelected(i2) || !path.toFile().isFile()) continue;
                    try {
                        FileUtil.copy((File)path.toFile(), (File)new File(string));
                        ModuleManager.getInstance((Project)project2).loadModule(string);
                        continue;
                    }
                    catch (ModuleWithNameAlreadyExists | IOException | JDOMException throwable) {
                        a.warn(throwable);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module2) {
        if (module2 == null) {
            AbstractModuleDataService.a(22);
        }
        ExternalSystemModulePropertyManager.getInstance((Module)module2).unlinkExternalOptions();
    }

    protected void setModuleOptions(Module module2, DataNode<E> dataNode) {
        ModuleData moduleData = (ModuleData)dataNode.getData();
        module2.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        ExternalSystemModulePropertyManager.getInstance((Module)module2).setExternalOptions(moduleData.getOwner(), moduleData, (ProjectData)dataNode.getData(ProjectKeys.PROJECT));
    }

    public void postProcess(@NotNull Collection<DataNode<E>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            AbstractModuleDataService.a(23);
        }
        if (project2 == null) {
            AbstractModuleDataService.a(24);
        }
        if (ideModifiableModelsProvider == null) {
            AbstractModuleDataService.a(25);
        }
        for (DataNode<E> dataNode : collection) {
            Module module2 = (Module)dataNode.getUserData(MODULE_KEY);
            if (module2 == null) continue;
            Object object = (Map)dataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (object != null) {
                this.rearrangeOrderEntries((Map<OrderEntry, OrderAware>)object, ideModifiableModelsProvider.getModifiableRootModel(module2));
            }
            this.a(project2, module2, (ModuleData)dataNode.getData());
            dataNode.putUserData(MODULE_KEY, null);
            dataNode.putUserData(ORDERED_DATA_MAP_KEY, null);
        }
        for (Object object : ideModifiableModelsProvider.getModules()) {
            object.putUserData(MODULE_DATA_KEY, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> map, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair4;
        OrderAware orderAware;
        OrderEntry orderEntry;
        if (map == null) {
            AbstractModuleDataService.a(26);
        }
        if (modifiableRootModel == null) {
            AbstractModuleDataService.a(27);
        }
        Object[] objectArray = modifiableRootModel.getOrderEntries();
        int n2 = objectArray.length;
        Object[] objectArray2 = new OrderEntry[n2];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(11, (pair2, pair3) -> {
            int n2;
            int n3 = ((OrderAware)pair2.second).getOrder();
            return n3 != (n2 = ((OrderAware)pair3.second).getOrder()) ? (n3 < n2 ? -1 : 1) : 0;
        });
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            orderEntry = objectArray[i2];
            orderAware = map.get(orderEntry);
            if (orderAware == null) {
                objectArray2[i2] = orderEntry;
                ++n3;
                continue;
            }
            priorityQueue.add(Pair.create((Object)orderEntry, (Object)orderAware));
        }
        while ((pair4 = (Pair)priorityQueue.poll()) != null) {
            orderEntry = (OrderEntry)pair4.first;
            orderAware = (OrderAware)pair4.second;
            int n4 = orderAware.getOrder() != -1 ? orderAware.getOrder() : n2 - 1;
            int n5 = AbstractModuleDataService.a((OrderEntry[])objectArray2, n4 - n3);
            assert (n5 != -1);
            objectArray2[n5] = orderEntry;
        }
        if (a.isDebugEnabled()) {
            boolean bl2 = !ArrayUtil.equals((Object[])objectArray, (Object[])objectArray2, Comparator.naturalOrder());
            a.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), bl2 ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])objectArray2);
    }

    private static int a(OrderEntry[] orderEntryArray, int n2) {
        int n3;
        for (n3 = n2; n3 < 0 || n3 < orderEntryArray.length && orderEntryArray[n3] != null; ++n3) {
        }
        if (n3 >= orderEntryArray.length) {
            for (n3 = n2 - 1; n3 >= 0 && (n3 >= orderEntryArray.length || orderEntryArray[n3] != null); --n3) {
            }
        }
        return n3;
    }

    private void b(@NotNull ModifiableRootModel modifiableRootModel, E e2) {
        LanguageLevel languageLevel;
        if (modifiableRootModel == null) {
            AbstractModuleDataService.a(28);
        }
        if ((languageLevel = LanguageLevel.parse((String)e2.getSourceCompatibility())) != null) {
            try {
                ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(languageLevel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                a.debug((Throwable)illegalArgumentException);
            }
        }
    }

    private void a(@NotNull ModifiableRootModel modifiableRootModel, E e2) {
        String string;
        if (modifiableRootModel == null) {
            AbstractModuleDataService.a(29);
        }
        if ((string = e2.getSdkName()) != null) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Sdk sdk = projectJdkTable.findJdk(string);
            if (sdk != null) {
                modifiableRootModel.setSdk(sdk);
            } else {
                modifiableRootModel.setInvalidSdk(string, JavaSdk.getInstance().getName());
            }
        }
    }

    private void a(@NotNull Project project2, @NotNull Module module2, @NotNull E e2) {
        String string;
        if (project2 == null) {
            AbstractModuleDataService.a(30);
        }
        if (module2 == null) {
            AbstractModuleDataService.a(31);
        }
        if (e2 == null) {
            AbstractModuleDataService.a(32);
        }
        if ((string = e2.getTargetCompatibility()) != null) {
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
            compilerConfiguration.setBytecodeTargetLevel(module2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void a(@NotNull Project project2, @NotNull ProjectData projectData, List list2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        AtomicInteger atomicInteger;
        if (project2 == null) {
            AbstractModuleDataService.a(36);
        }
        if (projectData == null) {
            AbstractModuleDataService.a(37);
        }
        if (ideModifiableModelsProvider == null) {
            AbstractModuleDataService.a(38);
        }
        if ((atomicInteger = (AtomicInteger)project2.getUserData(c)) == null) {
            atomicInteger = new AtomicInteger();
            project2.putUserData(c, (Object)atomicInteger);
        }
        atomicInteger.incrementAndGet();
        Set set = (Set)project2.getUserData(d);
        if (set == null) {
            set = ContainerUtil.newLinkedHashSet();
            project2.putUserData(d, (Object)set);
        }
        LocalHistoryAction localHistoryAction = LocalHistory.getInstance().startAction(ExternalSystemBundle.message((String)"local.history.remove.orphan.modules", (Object[])new Object[0]));
        try {
            String string = String.valueOf(projectData.getLinkedExternalProjectPath().hashCode());
            Path path = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve("orphanModules").resolve(string);
            if (!FileUtil.createDirectory((File)path.toFile())) {
                a.warn("Unable to create " + path);
                return;
            }
            AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)projectData.getOwner());
            AbstractExternalSystemLocalSettings.SyncType syncType = (AbstractExternalSystemLocalSettings.SyncType)abstractExternalSystemLocalSettings.getProjectSyncType().get(projectData.getLinkedExternalProjectPath());
            for (Module module2 : list2) {
                if (module2.isDisposed()) continue;
                String string2 = module2.getModuleFilePath();
                if (!ApplicationManager.getApplication().isHeadlessEnvironment() && syncType == AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT) {
                    try {
                        ServiceKt.getStateStore((ComponentManager)module2).save((List)new SmartList(), false);
                        VirtualFile virtualFile = module2.getModuleFile();
                        if (virtualFile != null) {
                            Path path2 = path.resolve(String.valueOf(string2.hashCode()));
                            FileUtil.writeToFile((File)path2.toFile(), (byte[])virtualFile.contentsToByteArray());
                            Path path3 = path.resolve(string2.hashCode() + ".path");
                            FileUtil.writeToFile((File)path3.toFile(), (String)string2);
                            set.add(path2);
                        }
                    }
                    catch (Exception exception) {
                        a.warn((Throwable)exception);
                    }
                }
                ideModifiableModelsProvider.getModifiableModuleModel().disposeModule(module2);
                ModuleBuilder.deleteModuleFile((String)string2);
            }
        }
        finally {
            localHistoryAction.finish();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 15: 
            case 18: 
            case 25: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 8: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModel";
                break;
            }
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemoveComputable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 13: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orphanModules";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSystem";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingModules";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModules";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingModules";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onSuccessImport";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showRemovedOrphanModules";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unlinkModuleFromExternalSystem";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeOrderEntries";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setSdk";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setBytecodeTargetLevel";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showRemovedOrphanModules$4";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onSuccessImport$1";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

