/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class ExternalSystemRunManagerListener
implements RunManagerListener {
    private Disposable a;
    private final ExternalProjectsManagerImpl c;
    private final Map<Integer, Pair<String, RunnerAndConfigurationSettings>> b;

    public ExternalSystemRunManagerListener(ExternalProjectsManager externalProjectsManager) {
        this.c = (ExternalProjectsManagerImpl)externalProjectsManager;
        this.b = ContainerUtil.newConcurrentMap();
    }

    public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings == null) {
            ExternalSystemRunManagerListener.a(0);
        }
        ExternalSystemRunManagerListener.a(this.b, runnerAndConfigurationSettings);
    }

    public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings == null) {
            ExternalSystemRunManagerListener.a(1);
        }
        if (runnerAndConfigurationSettings.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            Pair<String, RunnerAndConfigurationSettings> pair2 = this.b.remove(System.identityHashCode(runnerAndConfigurationSettings));
            if (pair2 == null) {
                return;
            }
            ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = this.c.getStateProvider();
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = ((ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).getSettings();
            if (externalSystemTaskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(externalSystemTaskExecutionSettings.getExternalSystemId(), externalSystemTaskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                Iterator<String> iterator = taskActivationState.getTasks(phase).iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    if (!((String)pair2.first).equals(string)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        Pair<String, RunnerAndConfigurationSettings> pair2;
        if (runnerAndConfigurationSettings == null) {
            ExternalSystemRunManagerListener.a(2);
        }
        if (runnerAndConfigurationSettings.getConfiguration() instanceof ExternalSystemRunConfiguration && (pair2 = this.b.get(System.identityHashCode(runnerAndConfigurationSettings))) != null) {
            ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = this.c.getStateProvider();
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = ((ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).getSettings();
            if (externalSystemTaskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(externalSystemTaskExecutionSettings.getExternalSystemId(), externalSystemTaskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                List<String> list2 = taskActivationState.getTasks(phase);
                for (String string : ContainerUtil.newArrayList(list2)) {
                    if (!((String)pair2.first).equals(string)) continue;
                    list2.remove(string);
                    String string2 = ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(runnerAndConfigurationSettings);
                    list2.add(string2);
                    this.b.put(System.identityHashCode(runnerAndConfigurationSettings), (Pair<String, RunnerAndConfigurationSettings>)Pair.create((Object)string2, (Object)runnerAndConfigurationSettings));
                    continue block0;
                }
            }
        }
    }

    public void attach() {
        this.b.clear();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType = ExternalSystemUtil.findConfigurationType(externalSystemManager.getSystemId());
            if (abstractExternalSystemTaskConfigurationType == null) continue;
            List list2 = RunManager.getInstance((Project)this.c.getProject()).getConfigurationSettingsList((ConfigurationType)abstractExternalSystemTaskConfigurationType);
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : list2) {
                ExternalSystemRunManagerListener.a(this.b, runnerAndConfigurationSettings);
            }
        }
        this.a = Disposer.newDisposable();
        this.c.getProject().getMessageBus().connect(this.a).subscribe(RunManagerListener.TOPIC, (Object)this);
    }

    public void detach() {
        this.b.clear();
        Disposable disposable = this.a;
        if (disposable != null) {
            this.a = null;
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static void a(@NotNull Map<Integer, Pair<String, RunnerAndConfigurationSettings>> map, @NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (map == null) {
            ExternalSystemRunManagerListener.a(3);
        }
        if (runnerAndConfigurationSettings == null) {
            ExternalSystemRunManagerListener.a(4);
        }
        if (runnerAndConfigurationSettings.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            map.put(System.identityHashCode(runnerAndConfigurationSettings), (Pair<String, RunnerAndConfigurationSettings>)Pair.create((Object)ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(runnerAndConfigurationSettings), (Object)runnerAndConfigurationSettings));
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemRunManagerListener";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationChanged";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

