/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTasksTree
extends Tree
implements Producer<ExternalTaskExecutionInfo> {
    private static final int b = 200;
    @NotNull
    private static final Comparator<TreePath> a = (treePath, treePath2) -> treePath2.getPathCount() - treePath.getPathCount();
    @NotNull
    private final Alarm c;
    @NotNull
    private final Set<TreePath> e;
    @NotNull
    private final Map<String, Boolean> d;
    private boolean f;

    public ExternalSystemTasksTree(@NotNull ExternalSystemTasksTreeModel externalSystemTasksTreeModel, @NotNull Map<String, Boolean> map, final @NotNull Project project2, final @NotNull ProjectSystemId projectSystemId) {
        if (externalSystemTasksTreeModel == null) {
            ExternalSystemTasksTree.a(0);
        }
        if (map == null) {
            ExternalSystemTasksTree.a(1);
        }
        if (project2 == null) {
            ExternalSystemTasksTree.a(2);
        }
        if (projectSystemId == null) {
            ExternalSystemTasksTree.a(3);
        }
        super((TreeModel)externalSystemTasksTreeModel);
        this.c = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.e = ContainerUtilRt.newHashSet();
        this.d = map;
        this.setRootVisible(false);
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
                if (!ExternalSystemTasksTree.this.f) {
                    ExternalSystemTasksTree.this.d.put(ExternalSystemTasksTree.a(treeExpansionEvent.getPath()), true);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
                if (!ExternalSystemTasksTree.this.f) {
                    ExternalSystemTasksTree.this.d.put(ExternalSystemTasksTree.a(treeExpansionEvent.getPath()), false);
                }
            }
        });
        externalSystemTasksTreeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                ExternalSystemTasksTree.this.c(treeModelEvent.getTreePath());
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                ExternalSystemTasksTree.this.c(treeModelEvent.getTreePath());
            }
        });
        new TreeSpeedSearch((JTree)((Object)this));
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalTaskExecutionInfo externalTaskExecutionInfo = ExternalSystemTasksTree.this.produce();
                if (externalTaskExecutionInfo == null) {
                    return;
                }
                ExternalSystemUtil.runTask(externalTaskExecutionInfo.getSettings(), externalTaskExecutionInfo.getExecutorId(), project2, projectSystemId);
            }
        });
    }

    private void c(@NotNull TreePath treePath) {
        if (treePath == null) {
            ExternalSystemTasksTree.a(4);
        }
        this.e.add(treePath);
        this.c.cancelAllRequests();
        this.c.addRequest(() -> {
            ArrayList arrayList = ContainerUtilRt.newArrayList(this.e);
            this.e.clear();
            Collections.sort(arrayList, a);
            for (TreePath treePath : arrayList) {
                this.b(treePath);
            }
            TreePath treePath = new TreePath(this.getModel().getRoot());
            if (this.isCollapsed(treePath)) {
                this.expandPath(treePath);
            }
        }, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(@NotNull TreePath treePath) {
        String string;
        Boolean bl2;
        if (treePath == null) {
            ExternalSystemTasksTree.a(5);
        }
        if ((bl2 = this.d.get(string = ExternalSystemTasksTree.a(treePath))) == null) {
            return;
        }
        boolean bl3 = this.f;
        this.f = true;
        try {
            if (bl2.booleanValue()) {
                this.expandPath(treePath);
            } else {
                this.collapsePath(treePath);
            }
        }
        finally {
            this.f = bl3;
        }
    }

    @NotNull
    private static String a(@NotNull TreePath treePath) {
        if (treePath == null) {
            ExternalSystemTasksTree.a(6);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            stringBuilder.append(treePath2.getLastPathComponent().toString()).append('/');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        String string = stringBuilder.toString();
        if (string == null) {
            ExternalSystemTasksTree.a(7);
        }
        return string;
    }

    @Nullable
    public ExternalTaskExecutionInfo produce() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        HashMap hashMap = ContainerUtil.newHashMap();
        for (TreePath treePath : treePathArray) {
            Object t2;
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof ExternalSystemNode) || !((t2 = ((ExternalSystemNode)object).getDescriptor().getElement()) instanceof ExternalTaskExecutionInfo)) continue;
            ExternalTaskExecutionInfo externalTaskExecutionInfo = (ExternalTaskExecutionInfo)t2;
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = externalTaskExecutionInfo.getSettings();
            String string = externalSystemTaskExecutionSettings.getExternalSystemIdString() + externalSystemTaskExecutionSettings.getExternalProjectPath() + externalSystemTaskExecutionSettings.getVmOptions();
            ExternalTaskExecutionInfo externalTaskExecutionInfo2 = (ExternalTaskExecutionInfo)hashMap.get(string);
            if (externalTaskExecutionInfo2 == null) {
                ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings2 = new ExternalSystemTaskExecutionSettings();
                externalSystemTaskExecutionSettings2.setExternalProjectPath(externalSystemTaskExecutionSettings.getExternalProjectPath());
                externalSystemTaskExecutionSettings2.setExternalSystemIdString(externalSystemTaskExecutionSettings.getExternalSystemIdString());
                externalSystemTaskExecutionSettings2.setVmOptions(externalSystemTaskExecutionSettings.getVmOptions());
                externalSystemTaskExecutionSettings2.setScriptParameters(externalSystemTaskExecutionSettings.getScriptParameters());
                externalSystemTaskExecutionSettings2.setExecutionName(externalSystemTaskExecutionSettings.getExecutionName());
                externalTaskExecutionInfo2 = new ExternalTaskExecutionInfo(externalSystemTaskExecutionSettings2, externalTaskExecutionInfo.getExecutorId());
                hashMap.put(string, externalTaskExecutionInfo2);
            }
            externalTaskExecutionInfo2.getSettings().getTaskNames().addAll(externalSystemTaskExecutionSettings.getTaskNames());
            externalTaskExecutionInfo2.getSettings().getTaskDescriptions().addAll(externalSystemTaskExecutionSettings.getTaskDescriptions());
        }
        if (hashMap.values().size() != 1) {
            return null;
        }
        return (ExternalTaskExecutionInfo)hashMap.values().iterator().next();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedStateHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTree";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCollapseStateAppliance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyCollapseState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

