/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTree;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathLookupElement;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPathField
extends ComponentWithBrowseButton<MyPathAndProjectButtonPanel>
implements TextAccessor {
    @NotNull
    private static final String a = "external.system.task.project.file.to.start";
    @NotNull
    private final Project b;
    @NotNull
    private final ProjectSystemId c;

    public ExternalProjectPathField(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull String string) {
        ActionListener[] actionListenerArray;
        if (project2 == null) {
            ExternalProjectPathField.a(0);
        }
        if (projectSystemId == null) {
            ExternalProjectPathField.a(1);
        }
        if (fileChooserDescriptor == null) {
            ExternalProjectPathField.a(2);
        }
        if (string == null) {
            ExternalProjectPathField.a(3);
        }
        super((JComponent)ExternalProjectPathField.createPanel(project2, projectSystemId), (ActionListener)new MyBrowseListener(fileChooserDescriptor, string, project2));
        for (ActionListener actionListener : actionListenerArray = this.getButton().getActionListeners()) {
            if (!(actionListener instanceof MyBrowseListener)) continue;
            ((MyBrowseListener)actionListener).a(((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField());
            break;
        }
        this.b = project2;
        this.c = projectSystemId;
    }

    @NotNull
    public static MyPathAndProjectButtonPanel createPanel(final @NotNull Project project2, final @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalProjectPathField.a(4);
        }
        if (projectSystemId == null) {
            ExternalProjectPathField.a(5);
        }
        final EditorTextField editorTextField = ExternalProjectPathField.b(project2, projectSystemId);
        final FixedSizeButton fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setIcon(AllIcons.Actions.Module);
        String string = ExternalSystemBundle.message((String)"run.configuration.tooltip.choose.registered.project", (Object[])new Object[]{projectSystemId.getReadableName()});
        fixedSizeButton.setToolTipText(string);
        fixedSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Ref ref = new Ref();
                Tree tree = ExternalProjectPathField.a(project2, projectSystemId);
                tree.setBorder(JBUI.Borders.empty((int)8));
                Runnable runnable = () -> {
                    Object t2;
                    Object object;
                    TreePath treePath;
                    if (projectSystemId == null) {
                        1.a(0);
                    }
                    if (project2 == null) {
                        1.a(1);
                    }
                    if ((treePath = tree.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) instanceof ExternalSystemNode && (t2 = ((ExternalSystemNode)object).getDescriptor().getElement()) instanceof ExternalProjectPojo) {
                        ExternalProjectPojo externalProjectPojo = (ExternalProjectPojo)t2;
                        editorTextField.setText(externalProjectPojo.getPath());
                        Editor editor = editorTextField.getEditor();
                        if (editor != null) {
                            ExternalProjectPathField.a(editor, projectSystemId, project2);
                        }
                    }
                    ((JBPopup)ref.get()).closeOk(null);
                };
                JBPopup jBPopup = new PopupChooserBuilder((JTree)tree).setTitle(ExternalSystemBundle.message((String)"run.configuration.title.choose.registered.project", (Object[])new Object[]{projectSystemId.getReadableName()})).setResizable(true).setItemChoosenCallback(runnable).setAutoselectOnMouseMove(true).setCloseOnEnter(false).createPopup();
                ref.set((Object)jBPopup);
                jBPopup.showUnderneathOf((Component)fixedSizeButton);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "externalSystemId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$1";
                objectArray[2] = "lambda$actionPerformed$0";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MyPathAndProjectButtonPanel myPathAndProjectButtonPanel = new MyPathAndProjectButtonPanel(editorTextField, fixedSizeButton);
        if (myPathAndProjectButtonPanel == null) {
            ExternalProjectPathField.a(6);
        }
        return myPathAndProjectButtonPanel;
    }

    @NotNull
    private static Tree a(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalProjectPathField.a(7);
        }
        if (projectSystemId == null) {
            ExternalProjectPathField.a(8);
        }
        ExternalSystemTasksTreeModel externalSystemTasksTreeModel = new ExternalSystemTasksTreeModel(projectSystemId);
        ExternalSystemTasksTree externalSystemTasksTree = new ExternalSystemTasksTree(externalSystemTasksTreeModel, ContainerUtilRt.newHashMap(), project2, projectSystemId);
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        assert (externalSystemManager != null);
        AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = (AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)project2);
        Map map = abstractExternalSystemLocalSettings.getAvailableProjects();
        ArrayList arrayList = ContainerUtilRt.newArrayList(map.keySet());
        ContainerUtil.sort((List)arrayList);
        for (ExternalProjectPojo externalProjectPojo : arrayList) {
            externalSystemTasksTreeModel.ensureSubProjectsStructure(externalProjectPojo, (Collection)map.get(externalProjectPojo));
        }
        ExternalSystemTasksTree externalSystemTasksTree2 = externalSystemTasksTree;
        if (externalSystemTasksTree2 == null) {
            ExternalProjectPathField.a(9);
        }
        return externalSystemTasksTree2;
    }

    @NotNull
    private static EditorTextField b(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ExternalProjectPathField.a(10);
        }
        if (projectSystemId == null) {
            ExternalProjectPathField.a(11);
        }
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        assert (externalSystemManager != null);
        final AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = (AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)project2);
        final ExternalSystemUiAware externalSystemUiAware = ExternalSystemUiUtil.getUiAware(projectSystemId);
        TextFieldCompletionProviderDumbAware textFieldCompletionProviderDumbAware = new TextFieldCompletionProviderDumbAware(){

            protected void addCompletionVariants(@NotNull String string, int n2, @NotNull String string2, @NotNull CompletionResultSet completionResultSet) {
                if (string == null) {
                    2.a(0);
                }
                if (string2 == null) {
                    2.a(1);
                }
                if (completionResultSet == null) {
                    2.a(2);
                }
                for (Map.Entry entry : abstractExternalSystemLocalSettings.getAvailableProjects().entrySet()) {
                    String string3 = ((ExternalProjectPojo)entry.getKey()).getPath();
                    String string4 = externalSystemUiAware.getProjectRepresentationName(string3, null);
                    ExternalProjectPathLookupElement externalProjectPathLookupElement = new ExternalProjectPathLookupElement(string4, string3);
                    completionResultSet.addElement((LookupElement)externalProjectPathLookupElement);
                    for (ExternalProjectPojo externalProjectPojo : (Collection)entry.getValue()) {
                        String string5 = externalProjectPojo.getPath();
                        if (string3.equals(string5)) continue;
                        String string6 = externalSystemUiAware.getProjectRepresentationName(string5, string3);
                        ExternalProjectPathLookupElement externalProjectPathLookupElement2 = new ExternalProjectPathLookupElement(string6, string5);
                        completionResultSet.addElement((LookupElement)externalProjectPathLookupElement2);
                    }
                }
                completionResultSet.stopHere();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EditorTextField editorTextField = textFieldCompletionProviderDumbAware.createEditor(project2, false, editor -> {
            if (projectSystemId == null) {
                ExternalProjectPathField.a(20);
            }
            if (project2 == null) {
                ExternalProjectPathField.a(21);
            }
            ExternalProjectPathField.a(editor, projectSystemId, project2);
            editor.getSettings().setShowIntentionBulb(false);
        });
        editorTextField.setBorder(UIUtil.getTextFieldBorder());
        editorTextField.setOneLineMode(true);
        editorTextField.setOpaque(true);
        editorTextField.setBackground(UIUtil.getTextFieldBackground());
        EditorTextField editorTextField2 = editorTextField;
        if (editorTextField2 == null) {
            ExternalProjectPathField.a(12);
        }
        return editorTextField2;
    }

    public void setText(String string) {
        ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().setText(string);
        Editor editor = ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getEditor();
        if (editor != null) {
            ExternalProjectPathField.a(editor, this.c, this.b);
        }
    }

    private static void a(@NotNull Editor editor, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2) {
        if (editor == null) {
            ExternalProjectPathField.a(13);
        }
        if (projectSystemId == null) {
            ExternalProjectPathField.a(14);
        }
        if (project2 == null) {
            ExternalProjectPathField.a(15);
        }
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        assert (externalSystemManager != null);
        AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = (AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)project2);
        ExternalSystemUiAware externalSystemUiAware = ExternalSystemUiUtil.getUiAware(projectSystemId);
        String string = editor.getDocument().getText();
        for (Map.Entry entry : abstractExternalSystemLocalSettings.getAvailableProjects().entrySet()) {
            if (((ExternalProjectPojo)entry.getKey()).getPath().equals(string)) {
                ExternalProjectPathField.collapse(editor, externalSystemUiAware.getProjectRepresentationName(project2, ((ExternalProjectPojo)entry.getKey()).getPath(), null));
                return;
            }
            for (ExternalProjectPojo externalProjectPojo : (Collection)entry.getValue()) {
                if (!externalProjectPojo.getPath().equals(string)) continue;
                ExternalProjectPathField.collapse(editor, externalSystemUiAware.getProjectRepresentationName(project2, externalProjectPojo.getPath(), ((ExternalProjectPojo)entry.getKey()).getPath()));
                return;
            }
        }
    }

    public static void collapse(@NotNull Editor editor, @NotNull String string) {
        if (editor == null) {
            ExternalProjectPathField.a(16);
        }
        if (string == null) {
            ExternalProjectPathField.a(17);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            if (editor == null) {
                ExternalProjectPathField.a(18);
            }
            if (string == null) {
                ExternalProjectPathField.a(19);
            }
            for (FoldRegion foldRegion : foldingModel.getAllFoldRegions()) {
                foldingModel.removeFoldRegion(foldRegion);
            }
            FoldRegion foldRegion = foldingModel.addFoldRegion(0, editor.getDocument().getTextLength(), string);
            if (foldRegion != null) {
                foldRegion.setExpanded(false);
            }
        });
    }

    public String getText() {
        return ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getText();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserTitle";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegisteredProjectsTree";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildRegisteredProjectsTree";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTextField";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collapseIfPossible";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collapse";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collapse$1";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTextField$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyPathAndProjectButtonPanel
    extends JPanel {
        @NotNull
        private final EditorTextField b;
        @NotNull
        private final FixedSizeButton a;

        public MyPathAndProjectButtonPanel(@NotNull EditorTextField editorTextField, @NotNull FixedSizeButton fixedSizeButton) {
            if (editorTextField == null) {
                MyPathAndProjectButtonPanel.a(0);
            }
            if (fixedSizeButton == null) {
                MyPathAndProjectButtonPanel.a(1);
            }
            super(new GridBagLayout());
            this.b = editorTextField;
            this.a = fixedSizeButton;
            this.add((Component)this.b, new GridBag().weightx(1.0).fillCellHorizontally());
            this.add((Component)this.a, new GridBag().insets(0, 3, 0, 1));
        }

        @NotNull
        public EditorTextField getTextField() {
            EditorTextField editorTextField = this.b;
            if (editorTextField == null) {
                MyPathAndProjectButtonPanel.a(2);
            }
            return editorTextField;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registeredProjectsButton";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextField";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyBrowseListener
    implements ActionListener {
        @NotNull
        private final FileChooserDescriptor a;
        @NotNull
        private final Project c;
        private EditorTextField b;

        MyBrowseListener(@NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull String string, @NotNull Project project2) {
            if (fileChooserDescriptor == null) {
                MyBrowseListener.a(0);
            }
            if (string == null) {
                MyBrowseListener.a(1);
            }
            if (project2 == null) {
                MyBrowseListener.a(2);
            }
            fileChooserDescriptor.setTitle(string);
            this.a = fileChooserDescriptor;
            this.c = project2;
        }

        private void a(@NotNull EditorTextField editorTextField) {
            if (editorTextField == null) {
                MyBrowseListener.a(3);
            }
            this.b = editorTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VirtualFile virtualFile;
            if (this.b == null) {
                assert (false);
                return;
            }
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.c);
            String string = this.b.getText();
            if (StringUtil.isEmpty((String)string)) {
                string = propertiesComponent.getValue(ExternalProjectPathField.a);
            }
            VirtualFile virtualFile2 = null;
            if (!StringUtil.isEmpty((String)string)) {
                virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string);
            }
            if ((virtualFile = FileChooser.chooseFile((FileChooserDescriptor)this.a, (Project)this.c, (VirtualFile)virtualFile2)) != null) {
                String string2 = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)virtualFile);
                this.b.setText(string2);
                propertiesComponent.setValue(ExternalProjectPathField.a, string2);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileChooserTitle";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathField";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyBrowseListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPathField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

