/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends ExternalSystemNode {
    private final RunnerAndConfigurationSettings h;

    public RunConfigurationNode(@NotNull ExternalProjectsView externalProjectsView, RunConfigurationsNode runConfigurationsNode, @NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (externalProjectsView == null) {
            RunConfigurationNode.b(0);
        }
        if (runnerAndConfigurationSettings == null) {
            RunConfigurationNode.b(1);
        }
        super(externalProjectsView, runConfigurationsNode);
        this.h = runnerAndConfigurationSettings;
    }

    protected void update(PresentationData presentationData) {
        super.update(presentationData);
        presentationData.setIcon(ProgramRunnerUtil.getConfigurationIcon((RunnerAndConfigurationSettings)this.h, (boolean)false));
        ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)this.h.getConfiguration();
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = externalSystemRunConfiguration.getSettings();
        String string = StringUtil.nullize((String)this.getShortcutsManager().getDescription(externalSystemTaskExecutionSettings.getExternalProjectPath(), this.h.getName()));
        String string2 = StringUtil.nullize((String)this.getTaskActivator().getDescription(externalSystemTaskExecutionSettings.getExternalSystemId(), externalSystemTaskExecutionSettings.getExternalProjectPath(), ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(this.h)));
        String string3 = string == null ? string2 : (string2 == null ? string : string + ", " + string2);
        this.setNameAndTooltip(this.getName(), StringUtil.join((Collection)externalSystemTaskExecutionSettings.getTaskNames(), (String)" "), string3);
    }

    public RunnerAndConfigurationSettings getSettings() {
        return this.h;
    }

    public String getName() {
        return this.h.getName();
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.RunConfigurationMenu";
    }

    public void updateRunConfiguration() {
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree simpleTree, InputEvent inputEvent) {
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.h, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        RunManager.getInstance((Project)this.h.getConfiguration().getProject()).setSelectedConfiguration(this.h);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return new Navigatable(){

            public void navigate(boolean bl2) {
                RunManager.getInstance((Project)RunConfigurationNode.this.myProject).setSelectedConfiguration(RunConfigurationNode.this.h);
                EditConfigurationsDialog editConfigurationsDialog = new EditConfigurationsDialog(RunConfigurationNode.this.myProject);
                editConfigurationsDialog.show();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        };
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "externalProjectsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/view/RunConfigurationNode";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

