/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraphEventManager
extends GraphBuilderEventManager {
    private final Graph2DView a;
    private final EditMode b;
    private final ViewMode f = new NavigationMode();
    private final MagnifierViewMode g = new MagnifierViewMode();
    private volatile boolean c = false;
    private volatile boolean d = false;
    private final List<GraphBuilderListener> i = new ArrayList<GraphBuilderListener>();
    private final GraphBuilder e;
    private boolean h = false;

    GraphEventManager(EditMode editMode, GraphBuilder graphBuilder) {
        this.e = graphBuilder;
        this.a = graphBuilder.getView();
        this.b = editMode;
        this.g.setMagnifierRadius(150);
        Disposer.register((Disposable)graphBuilder, (Disposable)this);
        JComponent jComponent = this.a.getCanvasComponent();
        jComponent.addMouseMotionListener((MouseMotionListener)((Object)this));
        jComponent.addKeyListener((KeyListener)((Object)this));
        jComponent.addMouseWheelListener((MouseWheelListener)((Object)this));
        jComponent.addFocusListener((FocusListener)((Object)this));
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (GraphEventManager.this.h) {
                    GraphEventManager.this.h = false;
                    GraphEventManager.this.a(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
            this.a();
        } else if (mouseEvent.isAltDown() && !mouseEvent.isControlDown()) {
            this.c();
        } else {
            if (!this.h) {
                this.h = true;
                this.a(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.b();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && this.d || !mouseEvent.isControlDown() && this.c) {
            this.b();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        boolean bl2 = keyEvent.isAltDown();
        boolean bl3 = keyEvent.isControlDown();
        if (bl3 && GraphEventManager.b(n2)) {
            this.a(n2);
        } else if (n2 == 17 && !bl2) {
            this.a();
        } else if (n2 == 18 && !bl3) {
            this.c();
        } else {
            this.b();
        }
    }

    private void a(int n2) {
        Graph2D graph2D = this.a.getGraph2D();
        List list2 = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list2.size() > 0) {
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : list2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean b(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void a() {
        if (!this.c) {
            this.a.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.b.setEditing(false);
            this.b.reactivateParent();
            this.c = true;
            this.a.removeViewMode((ViewMode)(this.d ? this.g : this.b));
            this.d = false;
            this.a.addViewMode(this.f);
        }
    }

    private synchronized void c() {
        if (!this.d) {
            this.d = true;
            double d2 = this.a.getZoom();
            d2 = d2 < 1.0 ? 1.5 / d2 : 2.0 * d2;
            this.g.setMagnifierZoomFactor(d2);
            this.a.removeViewMode((ViewMode)(this.c ? this.f : this.b));
            this.c = false;
            this.a.addViewMode((ViewMode)this.g);
        }
    }

    private synchronized void b() {
        if (this.c) {
            this.a(GraphBuilderEvent.GRAPH_MOVED, false);
            this.c = false;
            this.a.removeViewMode(this.f);
            this.a.addViewMode((ViewMode)this.b);
        } else if (this.d) {
            this.d = false;
            this.a.removeViewMode((ViewMode)this.g);
            this.a.updateView();
            this.a.addViewMode((ViewMode)this.b);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18) {
            this.b();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (mouseWheelEvent.isControlDown()) {
            double d2 = this.a.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)UIUtil.getParentOfType(Magnificator.class, (Component)this.a.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d2 / this.a.getZoom(), mouseWheelEvent.getPoint());
            }
        }
    }

    public double zoomView(double d2) {
        this.a(GraphBuilderEvent.ZOOM_CHANGED, true);
        double d3 = Math.min(10.0, Math.max(d2, 0.1));
        this.a.setZoom(d3);
        this.a.updateView();
        this.a(GraphBuilderEvent.ZOOM_CHANGED, false);
        return d3;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.b();
    }

    public void subscribe(GraphBuilderListener graphBuilderListener) {
        if (!this.i.contains(graphBuilderListener)) {
            this.i.add(graphBuilderListener);
        }
    }

    public void dispose() {
        this.i.clear();
    }

    private void a(GraphBuilderEvent graphBuilderEvent, boolean bl2) {
        for (GraphBuilderListener graphBuilderListener : this.i) {
            if (bl2) {
                graphBuilderListener.beforeActionPerformed(this.e, graphBuilderEvent);
                continue;
            }
            graphBuilderListener.actionPerformed(this.e, graphBuilderEvent);
        }
    }
}

