/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final Icon e = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)16));
    @Nullable
    private final Condition<Sdk> c;
    @Nullable
    private final Condition<SdkTypeId> b;
    private JButton d;
    private final Condition<SdkTypeId> a;

    public JdkComboBox(@NotNull ProjectSdksModel projectSdksModel) {
        if (projectSdksModel == null) {
            JdkComboBox.a(0);
        }
        this(projectSdksModel, null);
    }

    public JdkComboBox(@NotNull ProjectSdksModel projectSdksModel, @Nullable Condition<SdkTypeId> condition) {
        if (projectSdksModel == null) {
            JdkComboBox.a(1);
        }
        this(projectSdksModel, condition, JdkComboBox.getSdkFilter(condition), condition, false);
    }

    public JdkComboBox(final @NotNull ProjectSdksModel projectSdksModel, @Nullable Condition<SdkTypeId> condition, @Nullable Condition<Sdk> condition2, @Nullable Condition<SdkTypeId> condition3, boolean bl2) {
        if (projectSdksModel == null) {
            JdkComboBox.a(2);
        }
        super((ComboBoxModel)new JdkComboBoxModel(projectSdksModel, condition, condition2, bl2));
        this.c = condition2;
        this.a = condition;
        this.b = condition3;
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdkComboBoxItem> jList, JdkComboBoxItem jdkComboBoxItem, int n2, boolean bl2, boolean bl3) {
                if (jList == null) {
                    1.a(0);
                }
                if (JdkComboBox.this.isEnabled()) {
                    this.setIcon(e);
                    if (jdkComboBoxItem instanceof InvalidJdkComboBoxItem) {
                        String string = jdkComboBoxItem.toString();
                        this.append(string, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (jdkComboBoxItem instanceof ProjectJdkComboBoxItem) {
                        Sdk sdk = projectSdksModel.getProjectSdk();
                        if (sdk != null) {
                            this.setIcon(((SdkType)sdk.getSdkType()).getIcon());
                            this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(" (" + sdk.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            String string = jdkComboBoxItem.toString();
                            this.append(string, SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    } else if (jdkComboBoxItem instanceof SuggestedJdkItem) {
                        SdkType sdkType = ((SuggestedJdkItem)jdkComboBoxItem).getSdkType();
                        String string = ((SuggestedJdkItem)jdkComboBoxItem).getPath();
                        this.setIcon(sdkType.getIconForAddAction());
                        String string2 = sdkType.getVersionString(string);
                        this.append(string2 == null ? sdkType.getPresentableName() : string2);
                        this.append(" (" + string + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (jdkComboBoxItem != null) {
                        OrderEntryAppearanceService.getInstance().forJdk(jdkComboBoxItem.getJdk(), false, bl2, true).customize((SimpleColoredComponent)this);
                    } else {
                        this.customizeCellRenderer(jList, new NoneJdkComboBoxItem(), n2, bl2, bl3);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$1", "customizeCellRenderer"));
            }
        });
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = ScreenUtil.getScreenRectangle((int)0, (int)0);
        Dimension dimension = super.getPreferredSize();
        int n2 = rectangle.width / 4;
        if (dimension.width > n2) {
            dimension.width = n2;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    public void setSetupButton(JButton jButton, @Nullable Project project2, ProjectSdksModel projectSdksModel, JdkComboBoxItem jdkComboBoxItem, @Nullable Condition<Sdk> condition, boolean bl2) {
        this.setSetupButton(jButton, project2, projectSdksModel, jdkComboBoxItem, condition, ProjectBundle.message((String)"project.roots.set.up.jdk.title", (Object[])new Object[]{bl2 ? 1 : 2}));
    }

    public void setSetupButton(JButton jButton, @Nullable Project project2, ProjectSdksModel projectSdksModel, JdkComboBoxItem jdkComboBoxItem, @Nullable Condition<Sdk> condition, String string) {
        this.d = jButton;
        this.d.addActionListener(actionEvent -> {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            projectSdksModel.createAddActions(defaultActionGroup, (JComponent)((Object)this), this.getSelectedJdk(), sdk -> {
                if (project2 != null) {
                    JdkListConfigurable jdkListConfigurable = JdkListConfigurable.getInstance(project2);
                    jdkListConfigurable.addJdkNode((Sdk)sdk, false);
                }
                this.reloadModel(new ActualJdkComboBoxItem((Sdk)sdk), project2);
                this.setSelectedJdk((Sdk)sdk);
                if (condition != null && condition.value(sdk)) {
                    this.setSelectedJdk(jdkComboBoxItem.getJdk());
                }
            }, this.b);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (defaultActionGroup.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(string, (ActionGroup)defaultActionGroup, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)jButton);
            } else {
                AnActionEvent anActionEvent = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                defaultActionGroup.getChildren(anActionEvent)[0].actionPerformed(anActionEvent);
            }
        });
    }

    public void setEditButton(JButton jButton, Project project2, Computable<Sdk> computable) {
        jButton.addActionListener(actionEvent -> {
            Sdk sdk = (Sdk)computable.compute();
            if (sdk != null) {
                ProjectStructureConfigurable.getInstance(project2).select(sdk, true);
            }
        });
        this.addActionListener(actionEvent -> {
            JdkComboBoxItem jdkComboBoxItem = this.getSelectedItem();
            if (jdkComboBoxItem instanceof ProjectJdkComboBoxItem) {
                jButton.setEnabled(ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk() != null);
            } else {
                jButton.setEnabled(!(jdkComboBoxItem instanceof InvalidJdkComboBoxItem) && jdkComboBoxItem != null && jdkComboBoxItem.getJdk() != null);
            }
        });
    }

    public JButton getSetUpButton() {
        return this.d;
    }

    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem jdkComboBoxItem = this.getSelectedItem();
        return jdkComboBoxItem != null ? jdkComboBoxItem.getJdk() : null;
    }

    public void setSelectedJdk(Sdk sdk) {
        int n2 = this.a(sdk);
        if (n2 >= 0) {
            this.setSelectedIndex(n2);
        }
    }

    public void setInvalidJdk(String string) {
        this.a();
        this.addItem(new InvalidJdkComboBoxItem(string));
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private int a(Sdk sdk) {
        JdkComboBoxModel jdkComboBoxModel = (JdkComboBoxModel)this.getModel();
        int n2 = jdkComboBoxModel.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Sdk sdk2;
            JdkComboBoxItem jdkComboBoxItem = (JdkComboBoxItem)jdkComboBoxModel.getElementAt(i2);
            if (!(sdk == null ? jdkComboBoxItem instanceof NoneJdkComboBoxItem || jdkComboBoxItem instanceof ProjectJdkComboBoxItem : (sdk2 = jdkComboBoxItem.getJdk()) != null && sdk.getName().equals(sdk2.getName()))) continue;
            return i2;
        }
        return -1;
    }

    private void a() {
        JdkComboBoxModel jdkComboBoxModel = (JdkComboBoxModel)this.getModel();
        int n2 = jdkComboBoxModel.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            JdkComboBoxItem jdkComboBoxItem = (JdkComboBoxItem)jdkComboBoxModel.getElementAt(i2);
            if (!(jdkComboBoxItem instanceof InvalidJdkComboBoxItem)) continue;
            this.removeItemAt(i2);
            break;
        }
    }

    public void reloadModel(JdkComboBoxItem jdkComboBoxItem, @Nullable Project project2) {
        JdkComboBoxModel jdkComboBoxModel = (JdkComboBoxModel)this.getModel();
        if (project2 == null) {
            jdkComboBoxModel.addElement(jdkComboBoxItem);
            return;
        }
        jdkComboBoxModel.reload(jdkComboBoxItem, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel(), this.a, this.c, false);
    }

    public static Condition<Sdk> getSdkFilter(@Nullable Condition<SdkTypeId> condition) {
        return condition == null ? Conditions.alwaysTrue() : sdk -> condition.value((Object)sdk.getSdkType());
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
    }

    public static class SuggestedJdkItem
    extends JdkComboBoxItem {
        private final SdkType a;
        private final String b;

        SuggestedJdkItem(@NotNull SdkType sdkType, @NotNull String string) {
            if (sdkType == null) {
                SuggestedJdkItem.a(0);
            }
            if (string == null) {
                SuggestedJdkItem.a(1);
            }
            this.a = sdkType;
            this.b = string;
        }

        @NotNull
        public SdkType getSdkType() {
            SdkType sdkType = this.a;
            if (sdkType == null) {
                SuggestedJdkItem.a(2);
            }
            return sdkType;
        }

        @NotNull
        public String getPath() {
            String string = this.b;
            if (string == null) {
                SuggestedJdkItem.a(3);
            }
            return string;
        }

        public String toString() {
            return this.b;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InvalidJdkComboBoxItem
    extends JdkComboBoxItem {
        private final String a;

        InvalidJdkComboBoxItem(String string) {
            this.a = string;
        }

        @Override
        public String getSdkName() {
            return this.a;
        }

        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{this.a});
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem {
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.none.item", (Object[])new Object[0]);
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem {
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]);
        }
    }

    public static class ActualJdkComboBoxItem
    extends JdkComboBoxItem {
        private final Sdk a;

        public ActualJdkComboBoxItem(@NotNull Sdk sdk) {
            if (sdk == null) {
                ActualJdkComboBoxItem.a(0);
            }
            this.a = sdk;
        }

        public String toString() {
            return this.a.getName();
        }

        @Override
        @Nullable
        public Sdk getJdk() {
            return this.a;
        }

        @Override
        @Nullable
        public String getSdkName() {
            return this.a.getName();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkComboBoxItem", "<init>"));
        }
    }

    public static abstract class JdkComboBoxItem {
        @Nullable
        public Sdk getJdk() {
            return null;
        }

        @Nullable
        public String getSdkName() {
            return null;
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel<JdkComboBoxItem> {
        JdkComboBoxModel(@NotNull ProjectSdksModel projectSdksModel, @Nullable Condition<SdkTypeId> condition, @Nullable Condition<Sdk> condition2, boolean bl2) {
            if (projectSdksModel == null) {
                JdkComboBoxModel.a(0);
            }
            this.reload(null, projectSdksModel, condition, condition2, bl2);
        }

        void reload(@Nullable JdkComboBoxItem jdkComboBoxItem, @NotNull ProjectSdksModel projectSdksModel, @Nullable Condition<SdkTypeId> condition, @Nullable Condition<Sdk> condition2, boolean bl2) {
            Sdk[] sdkArray;
            if (projectSdksModel == null) {
                JdkComboBoxModel.a(1);
            }
            this.removeAllElements();
            if (jdkComboBoxItem != null) {
                this.addElement(jdkComboBoxItem);
            }
            for (Sdk sdk : sdkArray = JdkComboBoxModel.a(projectSdksModel.getSdks())) {
                if (condition2 != null && !condition2.value((Object)sdk)) continue;
                this.addElement(new ActualJdkComboBoxItem(sdk));
            }
            if (bl2) {
                this.addSuggestedItems(condition, sdkArray);
            }
        }

        @NotNull
        private static Sdk[] a(@NotNull Sdk[] sdkArray) {
            if (sdkArray == null) {
                JdkComboBoxModel.a(2);
            }
            Sdk[] sdkArray2 = (Sdk[])sdkArray.clone();
            Arrays.sort(sdkArray2, (sdk, sdk2) -> {
                SdkType sdkType = (SdkType)sdk.getSdkType();
                SdkType sdkType2 = (SdkType)sdk2.getSdkType();
                if (!sdkType.getComparator().equals(sdkType2.getComparator())) {
                    return StringUtil.compare((String)sdkType.getPresentableName(), (String)sdkType2.getPresentableName(), (boolean)true);
                }
                return sdkType.getComparator().compare(sdk, sdk2);
            });
            if (sdkArray2 == null) {
                JdkComboBoxModel.a(3);
            }
            return sdkArray2;
        }

        void addSuggestedItems(@Nullable Condition<SdkTypeId> condition, Sdk[] sdkArray) {
            SdkType[] sdkTypeArray;
            for (SdkType sdkType : sdkTypeArray = SdkType.getAllTypes()) {
                if (condition != null && (!condition.value((Object)sdkType) || ContainerUtil.find((Object[])sdkArray, sdk -> sdk.getSdkType() == sdkType) != null)) continue;
                Collection collection = sdkType.suggestHomePaths();
                for (String string : collection) {
                    if (string == null || !sdkType.isValidSdkHome(string)) continue;
                    this.addElement(new SuggestedJdkItem(sdkType, string));
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdksModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdks";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sortSdks";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reload";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "sortSdks";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

