/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class LanguageLevelCombo
extends ComboBox {
    private boolean b;
    private final String a;

    public LanguageLevelCombo(String string) {
        this.a = string;
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            this.addItem(languageLevel);
        }
        this.setRenderer((ListCellRenderer)new ColoredListCellRendererWrapper(){

            protected void doCustomize(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                if (object instanceof LanguageLevel) {
                    this.append(((LanguageLevel)object).getPresentableText());
                } else if (object instanceof String) {
                    this.append((String)object);
                    LanguageLevel languageLevel = LanguageLevelCombo.this.getDefaultLevel();
                    if (languageLevel != null) {
                        this.append(" (" + languageLevel.getPresentableText() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        });
    }

    public void reset(@NotNull Project project2) {
        if (project2 == null) {
            LanguageLevelCombo.a(0);
        }
        this.removeAllItems();
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            this.addItem(languageLevel);
        }
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
        this.sdkUpdated(sdk, project2.isDefault());
        LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)project2);
        if (languageLevelProjectExtension.isDefault()) {
            this.setSelectedItem(this.a);
        } else {
            this.setSelectedItem(languageLevelProjectExtension.getLanguageLevel());
        }
    }

    protected abstract LanguageLevel getDefaultLevel();

    void sdkUpdated(Sdk sdk, boolean bl2) {
        JavaSdkVersion javaSdkVersion;
        LanguageLevel languageLevel = null;
        if (sdk != null && (javaSdkVersion = JavaSdk.getInstance().getVersion(sdk)) != null) {
            languageLevel = javaSdkVersion.getMaxLanguageLevel();
        }
        this.a(languageLevel, bl2);
    }

    private void a(LanguageLevel languageLevel, boolean bl2) {
        if (languageLevel == null && !bl2) {
            if (this.a()) {
                boolean bl3;
                boolean bl4 = bl3 = this.getSelectedItem() == this.a;
                if (bl3) {
                    this.setSelectedItem(this.getDefaultLevel());
                }
                this.b = bl3;
                this.removeItem(this.a);
            }
        } else if (!this.a()) {
            this.addDefaultItem();
            if (this.b) {
                this.setSelectedIndex(0);
            }
        }
        this.repaint();
    }

    private boolean a() {
        return this.getItemAt(0) instanceof String;
    }

    void addDefaultItem() {
        this.insertItemAt(this.a, 0);
    }

    public LanguageLevel getSelectedLevel() {
        Object object = this.getSelectedItem();
        return object instanceof LanguageLevel ? (LanguageLevel)object : this.getDefaultLevel();
    }

    public boolean isDefault() {
        return !(this.getSelectedItem() instanceof LanguageLevel);
    }

    public void setSelectedItem(Object object) {
        super.setSelectedItem(object == null ? this.a : object);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/LanguageLevelCombo", "reset"));
    }
}

