/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ModuleJdkConfigurable
implements Disposable {
    private JdkComboBox a;
    private JPanel b;
    private ClasspathEditor d;
    private final ProjectSdksModel f;
    private boolean c = false;
    private final SdkModel.Listener e = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
            ModuleJdkConfigurable.this.a();
        }

        public void beforeSdkRemove(Sdk sdk) {
            ModuleJdkConfigurable.this.a();
        }

        public void sdkChanged(Sdk sdk, String string) {
            ModuleJdkConfigurable.this.a();
        }

        public void sdkHomeSelected(Sdk sdk, String string) {
            ModuleJdkConfigurable.this.a();
        }
    };

    public ModuleJdkConfigurable(ClasspathEditor classpathEditor, ProjectSdksModel projectSdksModel) {
        this.d = classpathEditor;
        this.f = projectSdksModel;
        this.f.addListener(this.e);
        this.d();
    }

    public JComponent createComponent() {
        return this.b;
    }

    private void a() {
        this.c = true;
        this.a.reloadModel(new JdkComboBox.ProjectJdkComboBoxItem(), this.getRootModel().getModule().getProject());
        this.reset();
        this.c = false;
    }

    protected abstract ModifiableRootModel getRootModel();

    private void d() {
        this.b = new JPanel(new GridBagLayout());
        this.a = new JdkComboBox(this.f);
        this.a.insertItemAt(new JdkComboBox.ProjectJdkComboBoxItem(), 0);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModuleJdkConfigurable.this.c) {
                    return;
                }
                Sdk sdk = ModuleJdkConfigurable.this.a.getSelectedJdk();
                ModuleJdkConfigurable.this.d.setSdk(sdk);
                ModuleJdkConfigurable.this.b();
            }
        });
        this.b.add((Component)new JLabel(ProjectBundle.message((String)"module.libraries.target.jdk.module.radio", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)6), 0, 0));
        this.b.add((Component)((Object)this.a), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBUI.insetsRight((int)4), 0, 0));
        Project project2 = this.getRootModel().getModule().getProject();
        JButton jButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
        this.a.setSetupButton(jButton, project2, this.f, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.ProjectJdkComboBoxItem(), (Condition<Sdk>)((Condition)sdk -> {
            int n2;
            Sdk sdk2 = this.f.getProjectSdk();
            if (sdk2 == null && (n2 = Messages.showYesNoDialog((Component)this.b, (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.message", (Object[])new Object[0]), (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon())) == 0) {
                this.f.setProjectSdk(sdk);
                return true;
            }
            return false;
        }), true);
        this.b.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)4), 0, 0));
        JButton jButton2 = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
        this.a.setEditButton(jButton2, this.getRootModel().getModule().getProject(), (Computable<Sdk>)((Computable)() -> this.getRootModel().getSdk()));
        this.b.add((Component)jButton2, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.b.setBorder(JBUI.Borders.empty((int)6));
    }

    private void b() {
        Module module2 = this.getRootModel().getModule();
        Project project2 = module2.getProject();
        StructureConfigurableContext structureConfigurableContext = ModuleStructureConfigurable.getInstance(project2).getContext();
        structureConfigurableContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(structureConfigurableContext, module2));
    }

    public void reset() {
        this.c = true;
        String string = this.getRootModel().getSdkName();
        if (string != null && !this.getRootModel().isSdkInherited()) {
            Sdk sdk = this.f.findSdk(string);
            if (sdk != null) {
                this.a.setSelectedJdk(sdk);
            } else {
                this.a.setInvalidJdk(string);
                this.b();
            }
        } else {
            this.a.setSelectedJdk(null);
        }
        this.c = false;
    }

    public void dispose() {
        this.d = null;
        this.a = null;
        this.b = null;
        this.f.removeListener(this.e);
    }
}

