/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.Facet;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ObsoleteLibraryFilesRemover;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurableContributor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurableFilter;
import com.intellij.openapi.roots.ui.configuration.SidePanel;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Place.Navigator,
Configurable.NoMargin,
Configurable.NoScroll {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable");
    public static final DataKey<ProjectStructureConfigurable> KEY = DataKey.create((String)"ProjectStructureConfiguration");
    protected final UIState myUiState = new UIState();
    private JBSplitter e;
    private JComponent i;
    @NonNls
    public static final String CATEGORY = "category";
    private JComponent a;
    private final Project s;
    private final FacetStructureConfigurable r;
    private final ArtifactsStructureConfigurable w;
    private History t = new History((Place.Navigator)this);
    private SidePanel g;
    private JPanel q;
    private final Wrapper b = new Wrapper();
    private Configurable h;
    private final ProjectSdksModel o = new ProjectSdksModel();
    private ProjectConfigurable l;
    private final ProjectLibrariesConfigurable d;
    private final GlobalLibrariesConfigurable c;
    private ModuleStructureConfigurable p;
    private boolean k;
    private final List<Configurable> j = new ArrayList<Configurable>();
    private final StructureConfigurableContext x;
    private final ModulesConfigurator u;
    private JdkListConfigurable v;
    private final JLabel m = new JLabel("<html><body><center>Select a setting to view or edit its details here</center></body></html>", 0);
    private final ObsoleteLibraryFilesRemover n;

    public ProjectStructureConfigurable(Project project2, ProjectLibrariesConfigurable projectLibrariesConfigurable, GlobalLibrariesConfigurable globalLibrariesConfigurable, ModuleStructureConfigurable moduleStructureConfigurable, FacetStructureConfigurable facetStructureConfigurable, ArtifactsStructureConfigurable artifactsStructureConfigurable) {
        this.s = project2;
        this.r = facetStructureConfigurable;
        this.w = artifactsStructureConfigurable;
        this.u = new ModulesConfigurator(this.s);
        this.x = new StructureConfigurableContext(this.s, this.u);
        this.u.setContext(this.x);
        this.d = projectLibrariesConfigurable;
        this.c = globalLibrariesConfigurable;
        this.p = moduleStructureConfigurable;
        this.d.init(this.x);
        this.c.init(this.x);
        this.p.init(this.x);
        this.r.init(this.x);
        if (!project2.isDefault()) {
            this.w.init(this.x, this.p, this.d, this.c);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.s);
        this.myUiState.lastEditedConfigurable = propertiesComponent.getValue("project.structure.last.edited");
        String string = propertiesComponent.getValue("project.structure.proportion");
        this.myUiState.proportion = string != null ? Float.parseFloat(string) : 0.0f;
        String string2 = propertiesComponent.getValue("project.structure.side.proportion");
        this.myUiState.sideProportion = string2 != null ? Float.parseFloat(string2) : 0.0f;
        this.n = new ObsoleteLibraryFilesRemover(project2);
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.structure" == null) {
            ProjectStructureConfigurable.a(0);
        }
        return "project.structure";
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.h != null ? this.h.getHelpTopic() : "";
    }

    public JComponent createComponent() {
        this.q = new MyPanel();
        this.e = new OnePixelSplitter(false, 0.15f);
        this.e.setSplitterProportionKey("ProjectStructure.TopLevelElements");
        this.e.setHonorComponentsMinimumSize(true);
        this.c();
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                return new Dimension(Math.max(dimension.width, 100), dimension.height);
            }
        };
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new BackAction((JComponent)this.q));
        defaultActionGroup.add((AnAction)new ForwardAction((JComponent)this.q));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ProjectStructure", (ActionGroup)defaultActionGroup, true);
        actionToolbar.setTargetComponent((JComponent)this.q);
        this.i = actionToolbar.getComponent();
        jPanel.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.i.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        jPanel.add((Component)this.i, "North");
        jPanel.add((Component)this.g, "Center");
        this.e.setFirstComponent((JComponent)jPanel);
        this.e.setSecondComponent((JComponent)this.b);
        this.q.add((Component)this.e, "Center");
        this.k = true;
        return this.q;
    }

    private void c() {
        ProjectStructureConfigurableContributor[] projectStructureConfigurableContributorArray;
        boolean bl2 = this.s == ProjectManager.getInstance().getDefaultProject();
        this.g = new SidePanel(this);
        this.g.addSeparator("Project Settings");
        this.b();
        if (!bl2) {
            this.e();
        }
        this.a();
        if (!bl2) {
            this.j();
            this.i();
        }
        for (ProjectStructureConfigurableContributor projectStructureConfigurableContributor : projectStructureConfigurableContributorArray = (ProjectStructureConfigurableContributor[])ProjectStructureConfigurableContributor.EP_NAME.getExtensions()) {
            for (Configurable configurable : projectStructureConfigurableContributor.getExtraProjectConfigurables(this.s, this.x)) {
                this.a(configurable, true);
            }
        }
        this.g.addSeparator("Platform Settings");
        this.g();
        this.h();
        for (ProjectStructureConfigurableContributor projectStructureConfigurableContributor : projectStructureConfigurableContributorArray) {
            for (Configurable configurable : projectStructureConfigurableContributor.getExtraPlatformConfigurables(this.s, this.x)) {
                this.a(configurable, true);
            }
        }
        this.g.addSeparator("--");
        this.d();
    }

    private void i() {
        this.a((Configurable)this.w, ProjectStructureConfigurableFilter.ConfigurableId.ARTIFACTS);
    }

    private void a(Configurable configurable, ProjectStructureConfigurableFilter.ConfigurableId configurableId) {
        this.a(configurable, this.a(configurableId));
    }

    private boolean a(ProjectStructureConfigurableFilter.ConfigurableId configurableId) {
        for (ProjectStructureConfigurableFilter projectStructureConfigurableFilter : (ProjectStructureConfigurableFilter[])ProjectStructureConfigurableFilter.EP_NAME.getExtensions()) {
            if (projectStructureConfigurableFilter.isAvailable(configurableId, this.s)) continue;
            return false;
        }
        return true;
    }

    public ArtifactsStructureConfigurable getArtifactsStructureConfigurable() {
        return this.w;
    }

    private void j() {
        if (this.r.isVisible()) {
            this.a((Configurable)this.r, ProjectStructureConfigurableFilter.ConfigurableId.FACETS);
        }
    }

    private void g() {
        if (this.v == null) {
            this.v = JdkListConfigurable.getInstance(this.s);
            this.v.init(this.x);
        }
        this.a((Configurable)this.v, ProjectStructureConfigurableFilter.ConfigurableId.JDK_LIST);
    }

    private void b() {
        this.l = new ProjectConfigurable(this.s, this.x, this.u, this.o);
        this.a((Configurable)this.l, ProjectStructureConfigurableFilter.ConfigurableId.PROJECT);
    }

    private void a() {
        this.a((Configurable)this.d, ProjectStructureConfigurableFilter.ConfigurableId.PROJECT_LIBRARIES);
    }

    private void d() {
        this.a((Configurable)new ErrorPaneConfigurable(this.s, this.x, () -> this.g.getList().repaint()), true);
    }

    private void h() {
        this.a((Configurable)this.c, ProjectStructureConfigurableFilter.ConfigurableId.GLOBAL_LIBRARIES);
    }

    private void e() {
        this.p = ModuleStructureConfigurable.getInstance(this.s);
        this.a((Configurable)this.p, ProjectStructureConfigurableFilter.ConfigurableId.MODULES);
    }

    public boolean isModified() {
        for (Configurable configurable : this.j) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        f.assertTrue(TransactionGuard.getInstance().getContextTransaction() != null, (Object)"Project Structure should be shown in a transaction, see AnAction#startInTransaction");
        for (Configurable object : this.j) {
            if (!(object instanceof BaseStructureConfigurable) || !object.isModified()) continue;
            ((BaseStructureConfigurable)object).checkCanApply();
        }
        Ref ref = Ref.create();
        try {
            for (Configurable configurable : this.j) {
                if (!configurable.isModified()) continue;
                configurable.apply();
            }
        }
        catch (ConfigurationException configurationException) {
            ref.set((Object)configurationException);
        }
        if (!ref.isNull()) {
            throw (ConfigurationException)((Object)ref.get());
        }
        this.n.deleteFiles();
        this.x.getDaemonAnalyzer().clearCaches();
        BuildManager.getInstance().scheduleAutoMake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken accessToken = HeavyProcessLatch.INSTANCE.processStarted("Resetting Project Structure");
        try {
            this.x.reset();
            this.o.reset(this.s);
            Configurable configurable = null;
            for (Configurable configurable2 : this.j) {
                if (this.myUiState.lastEditedConfigurable != null && this.myUiState.lastEditedConfigurable.equals(configurable2.getDisplayName())) {
                    configurable = configurable2;
                }
                if (configurable2 instanceof MasterDetailsComponent) {
                    ((MasterDetailsComponent)configurable2).setHistory(this.t);
                }
                configurable2.reset();
            }
            this.t.clear();
            if (configurable == null && this.j.size() > 0) {
                configurable = this.j.iterator().next();
            }
            this.k();
            this.navigateTo(configurable != null ? ProjectStructureConfigurable.a(configurable) : null, false);
            if (this.myUiState.proportion > 0.0f) {
                this.e.setProportion(this.myUiState.proportion);
            }
        }
        finally {
            accessToken.finish();
        }
    }

    public void disposeUIResources() {
        if (!this.k) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.s);
        propertiesComponent.setValue("project.structure.last.edited", this.myUiState.lastEditedConfigurable);
        propertiesComponent.setValue("project.structure.proportion", String.valueOf(this.myUiState.proportion));
        propertiesComponent.setValue("project.structure.side.proportion", String.valueOf(this.myUiState.sideProportion));
        this.myUiState.proportion = this.e.getProportion();
        this.l();
        this.x.getDaemonAnalyzer().stop();
        for (Configurable configurable : this.j) {
            configurable.disposeUIResources();
        }
        this.x.clear();
        this.j.clear();
        this.u.getFacetsConfigurator().clearMaps();
        this.k = false;
    }

    public boolean isUiInitialized() {
        return this.k;
    }

    public History getHistory() {
        return this.t;
    }

    public void setHistory(History history) {
        this.t = history;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            ProjectStructureConfigurable.a(1);
        }
        place.putPath(CATEGORY, (Object)this.h);
        Place.queryFurther((Object)this.h, (Place)place);
    }

    public ActionCallback selectProjectGeneralSettings(boolean bl2) {
        return this.navigateTo(this.createProjectConfigurablePlace(), bl2);
    }

    public Place createProjectConfigurablePlace() {
        return ProjectStructureConfigurable.a((Configurable)this.l);
    }

    public ActionCallback select(@Nullable String string, @Nullable String string2, boolean bl2) {
        Place place = this.createModulesPlace();
        if (string != null) {
            Module module2 = ModuleManager.getInstance((Project)this.s).findModuleByName(string);
            assert (module2 != null);
            place = place.putPath("treeObject", (Object)module2).putPath("selectedEditor", (Object)string2);
        }
        return this.navigateTo(place, bl2);
    }

    public Place createModulesPlace() {
        return ProjectStructureConfigurable.a((Configurable)this.p);
    }

    public Place createModulePlace(@NotNull Module module2) {
        if (module2 == null) {
            ProjectStructureConfigurable.a(2);
        }
        return this.createModulesPlace().putPath("treeObject", (Object)module2);
    }

    public ActionCallback select(@Nullable Facet facet, boolean bl2) {
        Place place = this.createModulesPlace();
        if (facet != null) {
            place = place.putPath("treeObject", (Object)facet);
        }
        return this.navigateTo(place, bl2);
    }

    public ActionCallback select(@NotNull Sdk sdk, boolean bl2) {
        if (sdk == null) {
            ProjectStructureConfigurable.a(3);
        }
        Place place = ProjectStructureConfigurable.a((Configurable)this.v);
        place.putPath("treeName", (Object)sdk.getName());
        return this.navigateTo(place, bl2);
    }

    public ActionCallback selectGlobalLibraries(boolean bl2) {
        Place place = ProjectStructureConfigurable.a((Configurable)this.c);
        return this.navigateTo(place, bl2);
    }

    public ActionCallback selectProjectOrGlobalLibrary(@NotNull Library library, boolean bl2) {
        if (library == null) {
            ProjectStructureConfigurable.a(4);
        }
        Place place = this.createProjectOrGlobalLibraryPlace(library);
        return this.navigateTo(place, bl2);
    }

    public Place createProjectOrGlobalLibraryPlace(Library library) {
        Place place = ProjectStructureConfigurable.a((Configurable)this.getConfigurableFor(library));
        place.putPath("treeName", (Object)library.getName());
        return place;
    }

    public ActionCallback select(@Nullable Artifact artifact, boolean bl2) {
        Place place = this.createArtifactPlace(artifact);
        return this.navigateTo(place, bl2);
    }

    public Place createArtifactPlace(Artifact artifact) {
        Place place = ProjectStructureConfigurable.a((Configurable)this.w);
        if (artifact != null) {
            place.putPath("treeName", (Object)artifact.getName());
        }
        return place;
    }

    public ActionCallback select(@NotNull LibraryOrderEntry libraryOrderEntry, boolean bl2) {
        Library library;
        if (libraryOrderEntry == null) {
            ProjectStructureConfigurable.a(5);
        }
        if ((library = libraryOrderEntry.getLibrary()) == null || library.getTable() == null) {
            return this.selectOrderEntry(libraryOrderEntry.getOwnerModule(), (OrderEntry)libraryOrderEntry);
        }
        Place place = ProjectStructureConfigurable.a((Configurable)this.getConfigurableFor(library));
        place.putPath("treeName", (Object)libraryOrderEntry.getLibraryName());
        return this.navigateTo(place, bl2);
    }

    public ActionCallback selectOrderEntry(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        if (module2 == null) {
            ProjectStructureConfigurable.a(6);
        }
        return ModuleStructureConfigurable.getInstance(this.s).selectOrderEntry(module2, orderEntry);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean bl2) {
        JComponent jComponent;
        Configurable configurable = (Configurable)place.getPath(CATEGORY);
        JComponent jComponent2 = this.b.getTargetComponent();
        if (this.h != configurable) {
            if (this.h instanceof BaseStructureConfigurable) {
                ((BaseStructureConfigurable)this.h).onStructureUnselected();
            }
            this.l();
            this.k();
            if (configurable != null) {
                jComponent2 = configurable.createComponent();
                this.b.setContent(jComponent2);
            }
            this.h = configurable;
            if (this.h != null) {
                this.myUiState.lastEditedConfigurable = this.h.getDisplayName();
            }
            if (configurable instanceof MasterDetailsComponent) {
                jComponent = (MasterDetailsComponent)configurable;
                if (this.myUiState.sideProportion > 0.0f) {
                    jComponent.getSplitter().setProportion(this.myUiState.sideProportion);
                }
                jComponent.setHistory(this.t);
            }
            if (configurable instanceof DetailsComponent.Facade) {
                ((DetailsComponent.Facade)configurable).getDetailsComponent().setBannerMinHeight(this.i.getPreferredSize().height);
            }
            if (configurable instanceof BaseStructureConfigurable) {
                ((BaseStructureConfigurable)configurable).onStructureSelected();
            }
        }
        if (jComponent2 != null) {
            jComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)jComponent2);
            if (jComponent == null) {
                jComponent = jComponent2;
            }
            if (bl2) {
                this.a = jComponent;
                UIUtil.requestFocus((JComponent)jComponent);
            }
        }
        jComponent = new ActionCallback();
        Place.goFurther((Object)configurable, (Place)place, (boolean)bl2).notifyWhenDone((ActionCallback)jComponent);
        this.b.revalidate();
        this.b.repaint();
        if (configurable != null) {
            this.g.select(ProjectStructureConfigurable.a(configurable));
        }
        if (!this.t.isNavigatingNow() && this.h != null) {
            this.t.pushQueryPlace();
        }
        return jComponent;
    }

    private void l() {
        if (this.h instanceof MasterDetailsComponent) {
            this.myUiState.sideProportion = ((MasterDetailsComponent)this.h).getSplitter().getProportion();
        }
    }

    private void k() {
        this.b.removeAll();
        this.h = null;
        this.myUiState.lastEditedConfigurable = null;
        this.b.add((Component)this.m, (Object)"Center");
    }

    public static ProjectStructureConfigurable getInstance(Project project2) {
        return (ProjectStructureConfigurable)((Object)ServiceManager.getService((Project)project2, ProjectStructureConfigurable.class));
    }

    @NotNull
    public ProjectSdksModel getProjectJdksModel() {
        ProjectSdksModel projectSdksModel = this.o;
        if (projectSdksModel == null) {
            ProjectStructureConfigurable.a(7);
        }
        return projectSdksModel;
    }

    public JdkListConfigurable getJdkConfig() {
        return this.v;
    }

    public ModuleStructureConfigurable getModulesConfig() {
        return this.p;
    }

    public ProjectConfigurable getProjectConfig() {
        return this.l;
    }

    public void registerObsoleteLibraryRoots(@NotNull Collection<VirtualFile> collection) {
        if (collection == null) {
            ProjectStructureConfigurable.a(8);
        }
        this.n.registerObsoleteLibraryRoots(collection);
    }

    private void a(Configurable configurable, boolean bl2) {
        this.j.add(configurable);
        if (bl2) {
            this.g.addPlace(ProjectStructureConfigurable.a(configurable), new Presentation(configurable.getDisplayName()));
        }
    }

    private static Place a(Configurable configurable) {
        return new Place().putPath(CATEGORY, (Object)configurable);
    }

    public StructureConfigurableContext getContext() {
        return this.x;
    }

    public BaseLibrariesConfigurable getConfigurableFor(Library library) {
        if ("project".equals(library.getTable().getTableLevel())) {
            return this.d;
        }
        return this.c;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryOrderEntry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectJdksModel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModulePlace";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectProjectOrGlobalLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectOrderEntry";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerObsoleteLibraryRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String string) {
            if (KEY.is(string)) {
                return ProjectStructureConfigurable.this;
            }
            if (History.KEY.is(string)) {
                return ProjectStructureConfigurable.this.getHistory();
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)1024, (int)768);
        }
    }

    public static class UIState {
        public float proportion;
        public float sideProportion;
        public String lastEditedConfigurable;
    }
}

