/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import org.jetbrains.annotations.Nullable;

public class UIRootConfigurationAccessor
extends RootConfigurationAccessor {
    private final Project a;

    public UIRootConfigurationAccessor(Project project2) {
        this.a = project2;
    }

    @Nullable
    public Library getLibrary(Library library, String string, String string2) {
        StructureConfigurableContext structureConfigurableContext = ProjectStructureConfigurable.getInstance(this.a).getContext();
        if (library == null) {
            if (string != null) {
                library = structureConfigurableContext.getLibrary(string, string2);
            }
        } else {
            Library library2 = structureConfigurableContext.getLibraryModel(library);
            if (library2 != null) {
                library = library2;
            }
            library = structureConfigurableContext.getLibrary(library.getName(), library.getTable().getTableLevel());
        }
        return library;
    }

    @Nullable
    public Sdk getSdk(Sdk sdk, String string) {
        ProjectSdksModel projectSdksModel = ProjectStructureConfigurable.getInstance(this.a).getJdkConfig().getJdksTreeModel();
        return string != null ? projectSdksModel.findSdk(string) : sdk;
    }

    public Module getModule(Module module2, String string) {
        if (module2 == null) {
            return ModuleStructureConfigurable.getInstance(this.a).getModule(string);
        }
        return module2;
    }

    public Sdk getProjectSdk(Project project2) {
        return ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk();
    }

    @Nullable
    public String getProjectSdkName(Project project2) {
        String string = ProjectRootManager.getInstance((Project)project2).getProjectSdkName();
        Sdk sdk = this.getProjectSdk(project2);
        if (sdk != null) {
            return sdk.getName();
        }
        ProjectSdksModel projectSdksModel = ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel();
        return projectSdksModel.findSdk(string) == null ? string : null;
    }
}

