/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutNodesDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.SimpleDnDAwareTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class LayoutTree
extends SimpleDnDAwareTree
implements AdvancedDnDSource {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree");
    private final ArtifactEditorImpl b;

    public LayoutTree(ArtifactEditorImpl artifactEditorImpl) {
        this.b = artifactEditorImpl;
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setCellEditor(new LayoutTreeCellEditor());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerSource((AdvancedDnDSource)this);
        }
        this.setToolTipText("");
    }

    public void addSubtreeToUpdate(DefaultMutableTreeNode defaultMutableTreeNode) {
        AbstractTreeBuilder.getBuilderFor((JTree)((Object)this)).addSubtreeToUpdate(defaultMutableTreeNode);
    }

    protected void configureUiHelper(TreeUIHelper treeUIHelper) {
        Convertor convertor = treePath -> {
            SimpleNode simpleNode = this.getNodeFor((TreePath)treePath);
            if (simpleNode instanceof PackagingElementNode) {
                return ((PackagingElementNode)simpleNode).getElementPresentation().getSearchName();
            }
            return "";
        };
        new TreeSpeedSearch((Tree)this, convertor, true);
    }

    private List<PackagingElementNode<?>> a() {
        return this.getSelection().getNodes();
    }

    public boolean canStartDragging(DnDAction dnDAction, Point point) {
        return !this.a().isEmpty();
    }

    public DnDDragStartBean startDragging(DnDAction dnDAction, Point point) {
        return new DnDDragStartBean((Object)new LayoutNodesDraggingObject(this.b, this.a()));
    }

    public Pair<Image, Point> createDraggedImage(DnDAction dnDAction, Point point) {
        List<PackagingElementNode<?>> list2 = this.a();
        if (list2.size() == 1) {
            return DnDAwareTree.getDragImage((Tree)this, (TreePath)this.getPathFor((SimpleNode)list2.get(0)), (Point)point);
        }
        return DnDAwareTree.getDragImage((Tree)this, (String)ProjectBundle.message((String)"drag.n.drop.text.0.packaging.elements", (Object[])new Object[]{list2.size()}), (Point)point);
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int n2) {
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterSource((AdvancedDnDSource)this);
        }
    }

    public LayoutTreeSelection getSelection() {
        return new LayoutTreeSelection(this);
    }

    @Nullable
    public PackagingElement<?> getElementByPath(TreePath treePath) {
        List list2;
        SimpleNode simpleNode = this.getNodeFor(treePath);
        if (simpleNode instanceof PackagingElementNode && !(list2 = ((PackagingElementNode)simpleNode).getPackagingElements()).isEmpty()) {
            return (PackagingElement)list2.get(0);
        }
        return null;
    }

    public PackagingElementNode<?> getRootPackagingNode() {
        SimpleNode simpleNode = this.getNodeFor(new TreePath(this.getRootNode()));
        return simpleNode instanceof PackagingElementNode ? (PackagingElementNode)simpleNode : null;
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public List<PackagingElementNode<?>> findNodes(Collection<? extends PackagingElement<?>> collection) {
        ArrayList arrayList = new ArrayList();
        TreeUtil.traverseDepth((TreeNode)this.getRootNode(), object -> {
            PackagingElementNode packagingElementNode;
            List list3;
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof PackagingElementNode && ContainerUtil.intersects(list3 = (packagingElementNode = (PackagingElementNode)((Object)((Object)object2))).getPackagingElements(), (Collection)collection)) {
                arrayList.add(packagingElementNode);
            }
            return true;
        });
        return arrayList;
    }

    public void addSubtreeToUpdate(PackagingElementNode packagingElementNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getRootNode(), (Object)((Object)packagingElementNode));
        if (defaultMutableTreeNode != null) {
            this.addSubtreeToUpdate(defaultMutableTreeNode);
        }
    }

    @Nullable
    public PackagingElementNode<?> findCompositeNodeByPath(String string) {
        CompositePackagingElementNode compositePackagingElementNode = this.getRootPackagingNode();
        for (String string2 : StringUtil.split((String)string, (String)"/")) {
            if (compositePackagingElementNode == null) {
                return null;
            }
            compositePackagingElementNode = compositePackagingElementNode.findCompositeChild(string2);
        }
        return compositePackagingElementNode;
    }

    private class LayoutTreeCellEditor
    extends DefaultCellEditor {
        public LayoutTreeCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2) {
            JTextField jTextField = (JTextField)super.getTreeCellEditorComponent(jTree, object, bl2, bl3, bl4, n2);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            Object e2 = ((PackagingElementNode)((Object)object2)).getElementIfSingle();
            a.assertTrue(e2 != null);
            String string = ((RenameablePackagingElement)e2).getName();
            jTextField.setText(string);
            int n3 = string.lastIndexOf(46);
            jTextField.setSelectionStart(0);
            jTextField.setSelectionEnd(n3 != -1 ? n3 : string.length());
            return jTextField;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl2;
            Object e2;
            String string = ((JTextField)this.editorComponent).getText();
            TreePath treePath = LayoutTree.this.getEditingPath();
            SimpleNode simpleNode = LayoutTree.this.getNodeFor(treePath);
            RenameablePackagingElement renameablePackagingElement = null;
            if (simpleNode instanceof PackagingElementNode && (e2 = ((PackagingElementNode)simpleNode).getElementIfSingle()) instanceof RenameablePackagingElement) {
                renameablePackagingElement = (RenameablePackagingElement)e2;
            }
            if ((bl2 = super.stopCellEditing()) && renameablePackagingElement != null) {
                RenameablePackagingElement renameablePackagingElement2 = renameablePackagingElement;
                LayoutTree.this.b.getLayoutTreeComponent().editLayout(() -> renameablePackagingElement2.rename(string));
                LayoutTree.this.b.queueValidation();
                LayoutTree.this.b.getLayoutTreeComponent().updatePropertiesPanel(true);
                LayoutTree.this.addSubtreeToUpdate((DefaultMutableTreeNode)treePath.getLastPathComponent());
                this.a();
            }
            return bl2;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.a();
        }

        private void a() {
            IdeFocusManager.getInstance((Project)LayoutTree.this.b.getContext().getProject()).requestFocus((Component)((Object)LayoutTree.this), true);
        }
    }
}

