/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ExtractArtifactDialog;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.IExtractArtifactDialog;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ExtractArtifactAction
extends LayoutTreeActionBase {
    public ExtractArtifactAction(ArtifactEditorEx artifactEditorEx) {
        super(ProjectBundle.message((String)"action.name.extract.artifact", (Object[])new Object[0]), artifactEditorEx);
    }

    @Override
    protected boolean isEnabled() {
        return this.myArtifactEditor.getLayoutTreeComponent().getSelection().getCommonParentElement() != null;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        IExtractArtifactDialog iExtractArtifactDialog;
        LayoutTreeComponent layoutTreeComponent = this.myArtifactEditor.getLayoutTreeComponent();
        LayoutTreeSelection layoutTreeSelection = layoutTreeComponent.getSelection();
        CompositePackagingElement<?> compositePackagingElement = layoutTreeSelection.getCommonParentElement();
        if (compositePackagingElement == null) {
            return;
        }
        CompositePackagingElementNode compositePackagingElementNode = layoutTreeSelection.getNodes().get(0).getParentNode();
        if (compositePackagingElementNode == null) {
            return;
        }
        if (!layoutTreeComponent.checkCanModifyChildren((PackagingElement<?>)compositePackagingElement, compositePackagingElementNode, (Collection<? extends PackagingElementNode<?>>)layoutTreeSelection.getNodes())) {
            return;
        }
        List<PackagingElement<?>> list2 = layoutTreeSelection.getElements();
        String string = "artifact";
        if (list2.size() == 1) {
            string = PathUtil.suggestFileName((String)((PackagingElement)ContainerUtil.getFirstItem(list2, null)).createPresentation(this.myArtifactEditor.getContext()).getPresentableName());
        }
        if ((iExtractArtifactDialog = this.showDialog(layoutTreeComponent, string)) == null) {
            return;
        }
        Project project2 = this.myArtifactEditor.getContext().getProject();
        ModifiableArtifactModel modifiableArtifactModel = this.myArtifactEditor.getContext().getOrCreateModifiableArtifactModel();
        ModifiableArtifact modifiableArtifact = modifiableArtifactModel.addArtifact(iExtractArtifactDialog.getArtifactName(), iExtractArtifactDialog.getArtifactType());
        layoutTreeComponent.editLayout(() -> {
            for (PackagingElement packagingElement : list2) {
                modifiableArtifact.getRootElement().addOrFindChild(ArtifactUtil.copyWithChildren(packagingElement, project2));
            }
            for (PackagingElement packagingElement : list2) {
                compositePackagingElement.removeChild(packagingElement);
            }
            compositePackagingElement.addOrFindChild((PackagingElement)new ArtifactPackagingElement(project2, ArtifactPointerManager.getInstance((Project)project2).createPointer((Artifact)modifiableArtifact, this.myArtifactEditor.getContext().getArtifactModel())));
        });
        layoutTreeComponent.rebuildTree();
    }

    @Nullable
    protected IExtractArtifactDialog showDialog(LayoutTreeComponent layoutTreeComponent, String string) {
        ExtractArtifactDialog extractArtifactDialog = new ExtractArtifactDialog(this.myArtifactEditor.getContext(), layoutTreeComponent, string);
        if (!extractArtifactDialog.showAndGet()) {
            return null;
        }
        return extractArtifactDialog;
    }
}

