/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.RenameablePackagingElement;
import javax.swing.tree.TreePath;

public class RenamePackagingElementAction
extends DumbAwareAction {
    private final ArtifactEditorEx a;

    public RenamePackagingElementAction(ArtifactEditorEx artifactEditorEx) {
        super(ProjectBundle.message((String)"action.name.rename.packaging.element", (Object[])new Object[0]));
        this.registerCustomShortcutSet(CommonShortcuts.getRename(), artifactEditorEx.getLayoutTreeComponent().getTreePanel());
        this.a = artifactEditorEx;
    }

    public void update(AnActionEvent anActionEvent) {
        LayoutTreeSelection layoutTreeSelection = this.a.getLayoutTreeComponent().getSelection();
        PackagingElement<?> packagingElement = layoutTreeSelection.getElementIfSingle();
        boolean bl2 = packagingElement instanceof RenameablePackagingElement && ((RenameablePackagingElement)packagingElement).canBeRenamed();
        anActionEvent.getPresentation().setEnabled(bl2);
        anActionEvent.getPresentation().setVisible(bl2);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        LayoutTreeSelection layoutTreeSelection = this.a.getLayoutTreeComponent().getSelection();
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        PackagingElement<?> packagingElement = layoutTreeSelection.getElementIfSingle();
        if (packagingElementNode == null || packagingElement == null) {
            return;
        }
        if (!this.a.getLayoutTreeComponent().checkCanModify(packagingElement, packagingElementNode)) {
            return;
        }
        TreePath treePath = layoutTreeSelection.getPath(packagingElementNode);
        this.a.getLayoutTreeComponent().startRenaming(treePath);
    }
}

