/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ArtifactEditorFindUsagesActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.treeStructure.Tree;
import java.util.List;

public class SourceItemFindUsagesAction
extends ArtifactEditorFindUsagesActionBase {
    private final SourceItemsTree d;

    public SourceItemFindUsagesAction(SourceItemsTree sourceItemsTree, Project project2, ArtifactsStructureConfigurableContext artifactsStructureConfigurableContext) {
        super((Tree)sourceItemsTree, project2, artifactsStructureConfigurableContext);
        this.d = sourceItemsTree;
    }

    @Override
    protected ProjectStructureElement getSelectedElement() {
        List<SourceItemNode> list2 = this.d.getSelectedSourceItemNodes();
        if (list2.size() != 1) {
            return null;
        }
        ArtifactsTreeNode artifactsTreeNode = list2.get(0);
        if (!(artifactsTreeNode instanceof SourceItemNode)) {
            return null;
        }
        PackagingSourceItem packagingSourceItem = ((SourceItemNode)artifactsTreeNode).getSourceItem();
        if (packagingSourceItem == null) {
            return null;
        }
        StructureConfigurableContext structureConfigurableContext = this.getContext();
        if (packagingSourceItem instanceof ModuleOutputSourceItem) {
            return new ModuleProjectStructureElement(structureConfigurableContext, ((ModuleOutputSourceItem)packagingSourceItem).getModule());
        }
        if (packagingSourceItem instanceof LibrarySourceItem) {
            return new LibraryProjectStructureElement(structureConfigurableContext, ((LibrarySourceItem)packagingSourceItem).getLibrary());
        }
        if (packagingSourceItem instanceof ArtifactSourceItem) {
            return this.myArtifactContext.getOrCreateArtifactElement(((ArtifactSourceItem)packagingSourceItem).getArtifact());
        }
        return null;
    }
}

