/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.lang.reflect.Proxy;

public class InlineModuleDependencyAction
extends AnAction {
    private static final Logger a = Logger.getInstance(InlineModuleDependencyAction.class);
    private final ClasspathPanelImpl b;

    public InlineModuleDependencyAction(ClasspathPanelImpl classpathPanelImpl) {
        super("Inline Module Dependency", "Replace dependency on a module without source roots by the list of its dependencies", null);
        this.b = classpathPanelImpl;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        OrderEntry orderEntry = this.b.getSelectedEntry();
        if (!(orderEntry instanceof ModuleOrderEntry)) {
            return;
        }
        ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
        Module module2 = moduleOrderEntry.getModule();
        if (module2 == null) {
            return;
        }
        ModifiableRootModel modifiableRootModel = this.b.getRootModel();
        int n2 = InlineModuleDependencyAction.a(modifiableRootModel, module2);
        if (n2 == -1) {
            return;
        }
        modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
        RootModelImpl rootModelImpl = Proxy.isProxyClass(modifiableRootModel.getClass()) ? (RootModelImpl)((ModuleEditor.ProxyDelegateAccessor)((Object)Proxy.getInvocationHandler(modifiableRootModel))).getDelegate() : (RootModelImpl)modifiableRootModel;
        int n3 = 0;
        ModuleRootModel moduleRootModel = this.b.getModuleConfigurationState().getModulesProvider().getRootModel(module2);
        ProjectRootManagerImpl projectRootManagerImpl = ProjectRootManagerImpl.getInstanceImpl((Project)this.b.getProject());
        VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        for (OrderEntry orderEntry2 : moduleRootModel.getOrderEntries()) {
            if (!(orderEntry2 instanceof LibraryOrderEntry) && !(orderEntry2 instanceof ModuleOrderEntry)) continue;
            a.assertTrue(orderEntry2 instanceof ClonableOrderEntry, (Object)orderEntry2);
            ExportableOrderEntry exportableOrderEntry = (ExportableOrderEntry)orderEntry2;
            ExportableOrderEntry exportableOrderEntry2 = (ExportableOrderEntry)((ClonableOrderEntry)orderEntry2).cloneEntry(rootModelImpl, projectRootManagerImpl, virtualFilePointerManager);
            exportableOrderEntry2.setExported(moduleOrderEntry.isExported() && exportableOrderEntry.isExported());
            exportableOrderEntry2.setScope(OrderEntryUtil.intersectScopes((DependencyScope)moduleOrderEntry.getScope(), (DependencyScope)exportableOrderEntry.getScope()));
            modifiableRootModel.addOrderEntry((OrderEntry)exportableOrderEntry2);
            ++n3;
        }
        OrderEntry[] orderEntryArray = modifiableRootModel.getOrderEntries();
        OrderEntry[] orderEntryArray2 = new OrderEntry[orderEntryArray.length];
        System.arraycopy(orderEntryArray, 0, orderEntryArray2, 0, n2);
        System.arraycopy(orderEntryArray, orderEntryArray.length - n3, orderEntryArray2, n2, n3);
        System.arraycopy(orderEntryArray, n2, orderEntryArray2, n2 + n3, orderEntryArray.length - n2 - n3);
        modifiableRootModel.rearrangeOrderEntries(orderEntryArray2);
        StructureConfigurableContext structureConfigurableContext = ProjectStructureConfigurable.getInstance(this.b.getProject()).getContext();
        structureConfigurableContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(structureConfigurableContext, module2));
    }

    private static int a(ModifiableRootModel modifiableRootModel, Module module2) {
        OrderEntry[] orderEntryArray = modifiableRootModel.getOrderEntries();
        for (int i2 = 0; i2 < orderEntryArray.length; ++i2) {
            OrderEntry orderEntry = orderEntryArray[i2];
            if (!(orderEntry instanceof ModuleOrderEntry) || !module2.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
            return i2;
        }
        return -1;
    }

    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setEnabledAndVisible(this.a());
    }

    private boolean a() {
        OrderEntry orderEntry = this.b.getSelectedEntry();
        if (!(orderEntry instanceof ModuleOrderEntry)) {
            return false;
        }
        Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
        if (module2 == null) {
            return false;
        }
        ModuleRootModel moduleRootModel = this.b.getModuleConfigurationState().getModulesProvider().getRootModel(module2);
        return moduleRootModel.getSourceRootUrls().length == 0;
    }
}

