/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExcludedRootElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class LibraryTreeStructure
extends AbstractTreeStructure {
    private final NodeDescriptor b;
    private final LibraryRootsComponent a;
    private final LibraryRootsComponentDescriptor c;

    LibraryTreeStructure(LibraryRootsComponent libraryRootsComponent, LibraryRootsComponentDescriptor libraryRootsComponentDescriptor) {
        this.a = libraryRootsComponent;
        this.c = libraryRootsComponentDescriptor;
        this.b = new NodeDescriptor(null, null){

            public boolean update() {
                this.myName = ProjectBundle.message((String)"library.root.node", (Object[])new Object[0]);
                return false;
            }

            public Object getElement() {
                return this;
            }
        };
    }

    public Object getRootElement() {
        return this.b;
    }

    public Object[] getChildElements(Object object) {
        LibraryEditor libraryEditor = this.a.getLibraryEditor();
        if (object == this.b) {
            ArrayList<OrderRootTypeElement> arrayList = new ArrayList<OrderRootTypeElement>(3);
            for (OrderRootType orderRootType : this.c.getRootTypes()) {
                String[] stringArray = libraryEditor.getUrls(orderRootType);
                if (stringArray.length <= 0) continue;
                OrderRootTypePresentation orderRootTypePresentation = this.c.getRootTypePresentation(orderRootType);
                if (orderRootTypePresentation == null) {
                    orderRootTypePresentation = DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(orderRootType);
                }
                arrayList.add(new OrderRootTypeElement(this.b, orderRootType, orderRootTypePresentation.getNodeText(), orderRootTypePresentation.getIcon()));
            }
            return arrayList.toArray();
        }
        if (object instanceof OrderRootTypeElement) {
            OrderRootTypeElement orderRootTypeElement = (OrderRootTypeElement)((Object)object);
            OrderRootType orderRootType = orderRootTypeElement.getOrderRootType();
            String[] stringArray = (String[])libraryEditor.getUrls(orderRootType).clone();
            Arrays.sort(stringArray, LibraryRootsComponent.ourUrlComparator);
            ArrayList<ItemElement> arrayList = new ArrayList<ItemElement>(stringArray.length);
            for (String string : stringArray) {
                arrayList.add(new ItemElement(orderRootTypeElement, string, orderRootType, libraryEditor.isJarDirectory(string, orderRootType), libraryEditor.isValid(string, orderRootType)));
            }
            return arrayList.toArray();
        }
        if (object instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)((Object)object);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : libraryEditor.getExcludedRootUrls()) {
                if (!VfsUtilCore.isEqualOrAncestor((String)itemElement.getUrl(), (String)string)) continue;
                arrayList.add(string);
            }
            Object[] objectArray = new ExcludedRootElement[arrayList.size()];
            Collections.sort(arrayList, LibraryRootsComponent.ourUrlComparator);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                objectArray[i2] = new ExcludedRootElement(itemElement, itemElement.getUrl(), (String)arrayList.get(i2));
            }
            return objectArray;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    public Object getParentElement(Object object) {
        return ((NodeDescriptor)object).getParentDescriptor();
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object object, NodeDescriptor nodeDescriptor) {
        NodeDescriptor nodeDescriptor2 = (NodeDescriptor)object;
        if (nodeDescriptor2 == null) {
            LibraryTreeStructure.a(0);
        }
        return nodeDescriptor2;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryTreeStructure", "createDescriptor"));
    }
}

