/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesContainerFactory {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory");
    private static final Library[] b = Library.EMPTY_ARRAY;

    private LibrariesContainerFactory() {
    }

    @NotNull
    public static LibrariesContainer createContainer(@Nullable Project project2) {
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(project2, null, null);
        if (librariesContainerImpl == null) {
            LibrariesContainerFactory.a(0);
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull Module module2) {
        if (module2 == null) {
            LibrariesContainerFactory.a(1);
        }
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module2.getProject(), module2, null);
        if (librariesContainerImpl == null) {
            LibrariesContainerFactory.a(2);
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull ModifiableRootModel modifiableRootModel) {
        if (modifiableRootModel == null) {
            LibrariesContainerFactory.a(3);
        }
        Module module2 = modifiableRootModel.getModule();
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module2.getProject(), module2, modifiableRootModel);
        if (librariesContainerImpl == null) {
            LibrariesContainerFactory.a(4);
        }
        return librariesContainerImpl;
    }

    public static LibrariesContainer createContainer(StructureConfigurableContext structureConfigurableContext) {
        return new StructureConfigurableLibrariesContainer(structureConfigurableContext);
    }

    public static Library createLibrary(@Nullable LibrariesContainer librariesContainer, @NotNull LibrariesContainer librariesContainer2, @NotNull @NonNls NewLibraryEditor newLibraryEditor, @NotNull LibrariesContainer.LibraryLevel libraryLevel) {
        if (librariesContainer2 == null) {
            LibrariesContainerFactory.a(5);
        }
        if (newLibraryEditor == null) {
            LibrariesContainerFactory.a(6);
        }
        if (libraryLevel == null) {
            LibrariesContainerFactory.a(7);
        }
        if (librariesContainer != null && librariesContainer.canCreateLibrary(libraryLevel)) {
            return librariesContainer.createLibrary(newLibraryEditor, libraryLevel);
        }
        return librariesContainer2.createLibrary(newLibraryEditor, libraryLevel);
    }

    @NotNull
    private static Library a(@NotNull NewLibraryEditor newLibraryEditor, LibraryTable libraryTable) {
        if (newLibraryEditor == null) {
            LibrariesContainerFactory.a(8);
        }
        LibraryTable.ModifiableModel modifiableModel = libraryTable.getModifiableModel();
        String string = StringUtil.isEmpty((String)newLibraryEditor.getName()) ? null : LibrariesContainerFactory.a(newLibraryEditor.getName(), modifiableModel);
        LibraryType<?> libraryType = newLibraryEditor.getType();
        Library library = modifiableModel.createLibrary(string, libraryType == null ? null : libraryType.getKind());
        LibraryEx.ModifiableModelEx modifiableModelEx = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        newLibraryEditor.applyTo(modifiableModelEx);
        modifiableModelEx.commit();
        modifiableModel.commit();
        Library library2 = library;
        if (library2 == null) {
            LibrariesContainerFactory.a(9);
        }
        return library2;
    }

    private static String a(String string2, LibraryTable.ModifiableModel modifiableModel) {
        return UniqueNameGenerator.generateUniqueName((String)string2, (String)"", (String)"", (String)" (", (String)")", string -> modifiableModel.getLibraryByName(string) == null);
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        LibrariesContainer librariesContainer;
        if (wizardContext == null) {
            LibrariesContainerFactory.a(10);
        }
        if (modulesProvider == null) {
            LibrariesContainerFactory.a(11);
        }
        if (modulesProvider instanceof ModulesConfigurator) {
            ModulesConfigurator modulesConfigurator = (ModulesConfigurator)modulesProvider;
            librariesContainer = LibrariesContainerFactory.createContainer(modulesConfigurator.getContext());
        } else {
            librariesContainer = LibrariesContainerFactory.createContainer(wizardContext.getProject());
        }
        LibrariesContainer librariesContainer2 = librariesContainer;
        if (librariesContainer2 == null) {
            LibrariesContainerFactory.a(12);
        }
        return librariesContainer2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container2";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryInTable";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryInTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StructureConfigurableLibrariesContainer
    extends LibrariesContainerBase {
        private final StructureConfigurableContext b;

        public StructureConfigurableLibrariesContainer(StructureConfigurableContext structureConfigurableContext) {
            this.b = structureConfigurableContext;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor newLibraryEditor, @NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            LibraryTableModifiableModelProvider libraryTableModifiableModelProvider;
            if (newLibraryEditor == null) {
                StructureConfigurableLibrariesContainer.b(0);
            }
            if (libraryLevel == null) {
                StructureConfigurableLibrariesContainer.b(1);
            }
            if ((libraryTableModifiableModelProvider = this.a(libraryLevel)) == null) {
                a.error("cannot create module library in this context");
            }
            LibraryTable.ModifiableModel modifiableModel = libraryTableModifiableModelProvider.getModifiableModel();
            LibraryType<?> libraryType = newLibraryEditor.getType();
            Library library = modifiableModel.createLibrary(LibrariesContainerFactory.a(newLibraryEditor.getName(), modifiableModel), libraryType == null ? null : libraryType.getKind());
            ExistingLibraryEditor existingLibraryEditor = ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(library);
            existingLibraryEditor.setProperties(newLibraryEditor.getProperties());
            newLibraryEditor.applyTo(existingLibraryEditor);
            return library;
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            LibraryTable libraryTable;
            if (library == null) {
                StructureConfigurableLibrariesContainer.b(2);
            }
            if ((libraryTable = library.getTable()) == null) {
                return null;
            }
            LibraryTable.ModifiableModel modifiableModel = this.b.getModifiableLibraryTable(libraryTable);
            if (modifiableModel instanceof LibrariesModifiableModel) {
                return ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(library);
            }
            return null;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.b.getProject();
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            LibraryTableModifiableModelProvider libraryTableModifiableModelProvider;
            if (libraryLevel == null) {
                StructureConfigurableLibrariesContainer.b(3);
            }
            Library[] libraryArray = (libraryTableModifiableModelProvider = this.a(libraryLevel)) != null ? libraryTableModifiableModelProvider.getModifiableModel().getLibraries() : b;
            if (libraryArray == null) {
                StructureConfigurableLibrariesContainer.b(4);
            }
            return libraryArray;
        }

        @Nullable
        private LibraryTableModifiableModelProvider a(LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT) {
                return this.b.getProjectLibrariesProvider();
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                return this.b.getGlobalLibrariesProvider();
            }
            return null;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                StructureConfigurableLibrariesContainer.b(5);
            }
            return libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL || libraryLevel == LibrariesContainer.LibraryLevel.PROJECT;
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType orderRootType) {
            LibrariesModifiableModel librariesModifiableModel;
            if (library == null) {
                StructureConfigurableLibrariesContainer.b(6);
            }
            if (orderRootType == null) {
                StructureConfigurableLibrariesContainer.b(7);
            }
            if ((librariesModifiableModel = this.b.getProjectLibrariesProvider().getModifiableModel()).hasLibraryEditor(library)) {
                ExistingLibraryEditor existingLibraryEditor = librariesModifiableModel.getLibraryEditor(library);
                VirtualFile[] virtualFileArray = existingLibraryEditor.getFiles(orderRootType);
                if (virtualFileArray == null) {
                    StructureConfigurableLibrariesContainer.b(8);
                }
                return virtualFileArray;
            }
            LibrariesModifiableModel librariesModifiableModel2 = this.b.getGlobalLibrariesProvider().getModifiableModel();
            if (librariesModifiableModel2.hasLibraryEditor(library)) {
                ExistingLibraryEditor existingLibraryEditor = librariesModifiableModel2.getLibraryEditor(library);
                VirtualFile[] virtualFileArray = existingLibraryEditor.getFiles(orderRootType);
                if (virtualFileArray == null) {
                    StructureConfigurableLibrariesContainer.b(9);
                }
                return virtualFileArray;
            }
            VirtualFile[] virtualFileArray = library.getFiles(orderRootType);
            if (virtualFileArray == null) {
                StructureConfigurableLibrariesContainer.b(10);
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryEditor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryLevel";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryFiles";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraries";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreateLibrary";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LibrariesContainerImpl
    extends LibrariesContainerBase {
        @Nullable
        private final Project c;
        @Nullable
        private final Module d;
        @Nullable
        private final ModifiableRootModel b;

        private LibrariesContainerImpl(@Nullable Project project2, @Nullable Module module2, @Nullable ModifiableRootModel modifiableRootModel) {
            this.c = project2;
            this.d = module2;
            this.b = modifiableRootModel;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.c;
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                LibrariesContainerImpl.b(0);
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE && this.d != null) {
                Library[] libraryArray = this.a();
                if (libraryArray == null) {
                    LibrariesContainerImpl.b(1);
                }
                return libraryArray;
            }
            LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                Library[] libraryArray = libraryTablesRegistrar.getLibraryTable().getLibraries();
                if (libraryArray == null) {
                    LibrariesContainerImpl.b(2);
                }
                return libraryArray;
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT && this.c != null) {
                Library[] libraryArray = libraryTablesRegistrar.getLibraryTable(this.c).getLibraries();
                if (libraryArray == null) {
                    LibrariesContainerImpl.b(3);
                }
                return libraryArray;
            }
            Library[] libraryArray = b;
            if (libraryArray == null) {
                LibrariesContainerImpl.b(4);
            }
            return libraryArray;
        }

        private Library[] a() {
            if (this.b != null) {
                return this.b.getModuleLibraryTable().getLibraries();
            }
            List list2 = OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)this.d));
            return list2.toArray(Library.EMPTY_ARRAY);
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType orderRootType) {
            if (library == null) {
                LibrariesContainerImpl.b(5);
            }
            if (orderRootType == null) {
                LibrariesContainerImpl.b(6);
            }
            VirtualFile[] virtualFileArray = library.getFiles(orderRootType);
            if (virtualFileArray == null) {
                LibrariesContainerImpl.b(7);
            }
            return virtualFileArray;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                LibrariesContainerImpl.b(8);
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE) {
                return this.b != null;
            }
            return libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL || this.c != null;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor newLibraryEditor, @NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            LibraryTable libraryTable;
            if (newLibraryEditor == null) {
                LibrariesContainerImpl.b(9);
            }
            if (libraryLevel == null) {
                LibrariesContainerImpl.b(10);
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE && this.b != null) {
                return LibrariesContainerFactory.a(newLibraryEditor, this.b.getModuleLibraryTable());
            }
            LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                libraryTable = libraryTablesRegistrar.getLibraryTable();
            } else if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT && this.c != null) {
                libraryTable = libraryTablesRegistrar.getLibraryTable(this.c);
            } else {
                return null;
            }
            return LibrariesContainerFactory.a(newLibraryEditor, libraryTable);
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            if (library == null) {
                LibrariesContainerImpl.b(11);
            }
            return null;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryLevel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryEditor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryFiles";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraries";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryFiles";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreateLibrary";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createLibrary";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryEditor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class LibrariesContainerBase
    implements LibrariesContainer {
        private UniqueNameGenerator a;

        private LibrariesContainerBase() {
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String string, @NotNull LibrariesContainer.LibraryLevel libraryLevel, @NotNull VirtualFile[] virtualFileArray, @NotNull VirtualFile[] virtualFileArray2) {
            if (string == null) {
                LibrariesContainerBase.a(0);
            }
            if (libraryLevel == null) {
                LibrariesContainerBase.a(1);
            }
            if (virtualFileArray == null) {
                LibrariesContainerBase.a(2);
            }
            if (virtualFileArray2 == null) {
                LibrariesContainerBase.a(3);
            }
            NewLibraryEditor newLibraryEditor = new NewLibraryEditor();
            newLibraryEditor.setName(string);
            for (VirtualFile virtualFile : virtualFileArray) {
                newLibraryEditor.addRoot(virtualFile, OrderRootType.CLASSES);
            }
            for (VirtualFile virtualFile : virtualFileArray2) {
                newLibraryEditor.addRoot(virtualFile, OrderRootType.SOURCES);
            }
            return this.createLibrary(newLibraryEditor, libraryLevel);
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String string, @NotNull LibrariesContainer.LibraryLevel libraryLevel, @NotNull Collection<? extends OrderRoot> collection) {
            if (string == null) {
                LibrariesContainerBase.a(4);
            }
            if (libraryLevel == null) {
                LibrariesContainerBase.a(5);
            }
            if (collection == null) {
                LibrariesContainerBase.a(6);
            }
            NewLibraryEditor newLibraryEditor = new NewLibraryEditor();
            newLibraryEditor.setName(string);
            newLibraryEditor.addRoots(collection);
            return this.createLibrary(newLibraryEditor, libraryLevel);
        }

        @Override
        @NotNull
        public Library[] getAllLibraries() {
            Object[] objectArray;
            Object[] objectArray2 = this.getLibraries(LibrariesContainer.LibraryLevel.GLOBAL);
            Object[] objectArray3 = this.getLibraries(LibrariesContainer.LibraryLevel.PROJECT);
            if (objectArray3.length > 0) {
                objectArray2 = (Library[])ArrayUtil.mergeArrays((Object[])objectArray2, (Object[])objectArray3);
            }
            if ((objectArray = this.getLibraries(LibrariesContainer.LibraryLevel.MODULE)).length > 0) {
                objectArray2 = (Library[])ArrayUtil.mergeArrays((Object[])objectArray2, (Object[])objectArray);
            }
            if (objectArray2 == null) {
                LibrariesContainerBase.a(7);
            }
            return objectArray2;
        }

        @Override
        @NotNull
        public List<LibrariesContainer.LibraryLevel> getAvailableLevels() {
            ArrayList<LibrariesContainer.LibraryLevel> arrayList = new ArrayList<LibrariesContainer.LibraryLevel>();
            for (LibrariesContainer.LibraryLevel libraryLevel : LibrariesContainer.LibraryLevel.values()) {
                if (!this.canCreateLibrary(libraryLevel)) continue;
                arrayList.add(libraryLevel);
            }
            ArrayList<LibrariesContainer.LibraryLevel> arrayList2 = arrayList;
            if (arrayList2 == null) {
                LibrariesContainerBase.a(8);
            }
            return arrayList2;
        }

        @Override
        @NotNull
        public String suggestUniqueLibraryName(@NotNull String string) {
            if (string == null) {
                LibrariesContainerBase.a(9);
            }
            if (this.a == null) {
                this.a = new UniqueNameGenerator(Arrays.asList(this.getAllLibraries()), library -> library.getName());
            }
            String string2 = this.a.generateUniqueName(string, "", "", " (", ")");
            if (string2 == null) {
                LibrariesContainerBase.a(10);
            }
            return string2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classRoots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoots";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLibraries";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestUniqueLibraryName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLibrary";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestUniqueLibraryName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

