/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private LibraryRootsComponent e;
    private final Library f;
    private final StructureLibraryTableModifiableModelProvider a;
    private final StructureConfigurableContext h;
    private final Project d;
    private final LibraryProjectStructureElement g;
    private boolean b;
    private boolean c;

    protected LibraryConfigurable(StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider, Library library, StructureConfigurableContext structureConfigurableContext, Runnable runnable) {
        super(true, runnable);
        this.a = structureLibraryTableModifiableModelProvider;
        this.h = structureConfigurableContext;
        this.d = structureConfigurableContext.getProject();
        this.f = library;
        this.g = new LibraryProjectStructureElement(structureConfigurableContext, this.f);
    }

    public JComponent createOptionsPanel() {
        this.e = new LibraryRootsComponent(this.d, (Computable<LibraryEditor>)((Computable)() -> this.getLibraryEditor()));
        this.e.addListener(() -> {
            this.h.getDaemonAnalyzer().queueUpdate(this.g);
            this.updateName();
        });
        return this.e.getComponent();
    }

    public boolean isModified() {
        return this.e != null && this.e.hasChanges();
    }

    @Override
    @NotNull
    public ProjectStructureElement getProjectStructureElement() {
        LibraryProjectStructureElement libraryProjectStructureElement = this.g;
        if (libraryProjectStructureElement == null) {
            LibraryConfigurable.a(0);
        }
        return libraryProjectStructureElement;
    }

    public void apply() {
        this.c();
    }

    public void reset() {
        this.d();
    }

    public void disposeUIResources() {
        if (this.e != null) {
            Disposer.dispose((Disposable)this.e);
            this.e = null;
        }
    }

    public void setDisplayName(String string) {
        if (!this.b) {
            this.getLibraryEditor().setName(string);
            if (this.e != null) {
                this.e.onLibraryRenamed();
            }
            this.h.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
        }
    }

    protected LibraryEditor getLibraryEditor() {
        return this.a.getModifiableModel().getLibraryEditor(this.f);
    }

    public void updateName() {
        this.b = true;
        try {
            super.updateName();
        }
        finally {
            this.b = false;
        }
    }

    public Library getEditableObject() {
        return this.f;
    }

    public String getBannerSlogan() {
        LibraryTable libraryTable = this.f.getTable();
        String string = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), string});
    }

    public String getDisplayName() {
        if (this.a.getModifiableModel().hasLibraryEditor(this.f)) {
            return this.getLibraryEditor().getName();
        }
        return this.f.getName();
    }

    public void onSelected() {
        this.d();
    }

    public void onUnselected() {
        this.c();
    }

    private void d() {
        if (this.e != null) {
            this.e.updatePropertiesLabel();
            this.e.resetProperties();
            this.c = true;
        }
    }

    private void c() {
        if (this.e != null && this.c) {
            this.e.applyProperties();
            this.c = false;
        }
    }

    public Icon getIcon(boolean bl2) {
        return LibraryPresentationManager.getInstance().getNamedLibraryIcon(this.f, this.h);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }

    public void updateComponent() {
        if (this.e != null) {
            this.e.updateRootsTree();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibraryConfigurable", "getProjectStructureElement"));
    }
}

