/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;

class ProjectStructureElementRenderer
extends ColoredTreeCellRenderer {
    private final StructureConfigurableContext a;

    public ProjectStructureElementRenderer(StructureConfigurableContext structureConfigurableContext) {
        this.a = structureConfigurableContext;
    }

    public void customizeCellRenderer(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        if (object instanceof MasterDetailsComponent.MyNode) {
            ProjectStructureElement projectStructureElement;
            MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)object;
            NamedConfigurable namedConfigurable = myNode.getConfigurable();
            if (namedConfigurable == null) {
                return;
            }
            String string = myNode.getDisplayName();
            Icon icon = namedConfigurable.getIcon(bl3);
            this.setIcon(icon);
            this.setToolTipText(null);
            this.setFont(UIUtil.getTreeFont());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (myNode.isDisplayInBold()) {
                simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            } else if (namedConfigurable instanceof ProjectStructureElementConfigurable && (projectStructureElement = ((ProjectStructureElementConfigurable)namedConfigurable).getProjectStructureElement()) != null) {
                ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = this.a.getDaemonAnalyzer();
                ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = projectStructureDaemonAnalyzer.getProblemsHolder(projectStructureElement);
                if (projectStructureProblemsHolderImpl != null && projectStructureProblemsHolderImpl.containsProblems()) {
                    int n3;
                    boolean bl6 = projectStructureProblemsHolderImpl.containsProblems(ProjectStructureProblemType.Severity.UNUSED);
                    boolean bl7 = projectStructureProblemsHolderImpl.containsProblems(ProjectStructureProblemType.Severity.WARNING);
                    boolean bl8 = projectStructureProblemsHolderImpl.containsProblems(ProjectStructureProblemType.Severity.ERROR);
                    Color color = bl6 ? UIUtil.getInactiveTextColor() : null;
                    int n4 = n3 = bl7 || bl8 ? 8 : -1;
                    JBColor jBColor = bl8 ? JBColor.RED : (bl7 ? JBColor.GRAY : null);
                    simpleTextAttributes = simpleTextAttributes.derive(n3, color, null, (Color)jBColor);
                    this.setToolTipText(projectStructureProblemsHolderImpl.composeTooltipMessage());
                }
                this.append(string, simpleTextAttributes);
                String string2 = projectStructureElement.getDescription();
                if (string2 != null) {
                    this.append(" (" + string2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES, false);
                }
                return;
            }
            this.append(string, simpleTextAttributes);
        }
    }
}

